<?
  /*
  Notes: 210.001mm x 297.00mm
  */

  $pubuserpkey=$_GET['userid'];

  //include_once('../includes.php');
  include_once('../dbincludes.php');
  include_once('../lib/lib_general.php');

  define('FPDF_FONTPATH','../lib/fpdf/font/');
  require('../lib/fpdf/fpdf.php');

  include_once('../models/userModel.php');
  $myuserModel=new userModel;

  $user_data = $myuserModel->getdata_user($pubuserpkey);

  include_once('../models/reportModel.php');
  $myreportModel=new reportModel;

  $header_data = $myreportModel->loadheader_sps($pubuserpkey);
  $report_data = $myreportModel->loaddata_sps($pubuserpkey);

  //$projectname = $header_data['hdr_projectname'];


  class PDF extends FPDF {

    // Page header
    function Header() {

      global $header_data;

      if ($this->PageNo()==1) {

        // zikay logo..
        $this->Image('../gfx/zikayheader.png',55,10,100,20);	//390, 87);

        // title
        $this->SetXY(65,35);
        $this->SetFont('Arial','B',9);
        $this->Cell(80,5,'SUPPLIER PERFORMANCE SUMMARY REPORT','B',1,'C');

        // project info
        $this->SetXY(10,45);
        $this->SetFont('Arial','B',7);
        $this->Cell(28,5,'PROJECT TITLE',0,0);
        $this->SetX(35);
        $this->Cell(5,5,':',0,0);
        $this->SetX(40);
        $this->Cell(200,5,$header_data['hdr_projectname'],0,0);

        // project info
        $this->SetXY(10,52);
        $this->SetFont('Arial','B',7);
        $this->Cell(28,5,'SUPPLIER',0,0);
        $this->SetX(35);
        $this->Cell(5,5,':',0,0);
        $this->SetX(40);
        $this->Cell(200,5,$header_data['hdr_suppliername'],0,0);

        // date filter
        $this->SetXY(10,59);
        $this->SetFont('Arial','B',7);
        $this->Cell(28,5,'DATE',0,0);
        $this->SetX(35);
        $this->Cell(5,5,':',0,0);
        $this->SetX(40);
        $this->Cell(20,5,$header_data['hdr_datefrom'],1,0);
        $this->SetX(65);
        $this->Cell(5,5,'TO',0,0);
        $this->SetX(75);
        $this->Cell(20,5,$header_data['hdr_dateto'],1,0);

        //Line break
        $this->Ln(15);
      }

      $this->SetFont('Arial','B',6);
      $this->SetX(10);

      $header=array('NO','SUPPLIER','PO NO','PO DATE','DO NO','DATE OF DELIVERY','EXPECTED DELIVERY','DELIVERY PERIOD');

      //Column widths
      $w=array(10,45,20,20,20,25,25,25);

      //Headers
      for($i=0;$i<count($header);$i++)
          $this->Cell($w[$i],5,$header[$i],1,0,'C');
      $this->Ln();

    }

    // Page footer
    function Footer() {

      global $user_data;

      $this->Line(10,282,203,282);

      // printer and date (1.5 cm from bottom)..
      $this->SetXY(10,-15);
      $this->SetFont('Arial','',7);
      $this->Cell(0,5,'Print Date : '.unconverttounixslash(getdatestamp()).' - Printed By : '.$user_data['staff_name'],0,0,'L');

      // page no (1.5 cm from bottom)..
      $this->SetXY(-15,-15);
      $this->SetFont('Arial','',7);
      $this->Cell(0,5,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }

  }


  $pdf=new PDF('P','mm','A4');
  $pdf->Open();
  $pdf->AliasNbPages();
  $pdf->AddPage('P','A4');
  $pdf->SetFont('Arial','',8);

  // data area..

  //for($i=1;$i<=40;$i++)
  //  $pdf->Cell(40,40,'Printing line number '.$i.$pubuserpkey,0,1);
  //$pdf->Cell(40,10,'Hello World');

  //Column widths
  $w=array(10,45,20,20,20,25,25,25);

  $pdf->SetFont('Courier','',7);

  foreach($report_data as $row) {
    $pdf->SetFont('Arial','',6);
    if (($prevpono != $row['data_pono'])||($prevsupp != $row['data_suppliername'])) {
      $pdf->Cell($w[0],5,$row['data_no'],1,0,'C');
      $pdf->Cell($w[1],5,$row['data_suppliername'],1,0,'C');
      $pdf->Cell($w[2],5,$row['data_pono'],1,0,'C');
      $pdf->Cell($w[3],5,$row['data_podate'],1,0,'C');
    } else {
      $pdf->Cell($w[0],5,'',1,0,'C');
      $pdf->Cell($w[1],5,'',1,0,'C');
      $pdf->Cell($w[2],5,'',1,0,'C');
      $pdf->Cell($w[3],5,'',1,0,'C');
    }
    $pdf->Cell($w[4],5,$row['data_dono'],1,0,'C');
    $pdf->Cell($w[5],5,$row['data_dodate'],1,0,'C');
    $pdf->Cell($w[6],5,$row['data_expecteddate'],1,0,'C');
    $pdf->SetFont('Arial','',6);	// C7
    
	 //====== arie add ===========
	//$pdf->Cell($w[7],5,number_format($row['data_deliveryperiod'],2),1,0,'C');
	
	$varDP = $row['data_deliveryperiod'];
	$varCheck = substr($varDP, 0, 1);
	if ($varCheck  == "-")
	{		
		$pdf->SetFont('Arial','B',6); //arie add
		$pdf->SetTextColor(220,50,50); //red
		$pdf->Cell($w[7],5,number_format($row['data_deliveryperiod'],2),1,0,'C');
	}
	else
	{
		//$pdf->SetFont('Arial','B',6); //arie add
		//$pdf->SetTextColor(220,50,50); //red
		$pdf->Cell($w[7],5,number_format($row['data_deliveryperiod'],2),1,0,'C');
	}
     //====== end arie add ===========
	$pdf->SetTextColor(0); 
	$pdf->Ln();
    $prevpono = $row['data_pono'];
    $prevsupp = $row['data_suppliername'];
  }


  // output..

  $pdf->Output();
  exit;


  /* For outputting to a file..
  $file = basename(tempnam('.', 'tmp'));
  rename($file, $file.'.pdf');
  $file .= '.pdf';
  $pdf->Output($file, 'F');
  header('Location: '.$file);
  */

?>