<?
  /*
  Notes: 210.001mm x 297.00mm
  */

  $pubuserpkey=$_GET['userid'];

  //include_once('../includes.php');
  include_once('../dbincludes.php');
  include_once('../lib/lib_general.php');

  define('FPDF_FONTPATH','../lib/fpdf/font/');
  require('../lib/fpdf/fpdf.php');

  include_once('../models/userModel.php');
  $myuserModel=new userModel;

  $user_data = $myuserModel->getdata_user($pubuserpkey);

  include_once('../models/reportModel.php');
  $myreportModel=new reportModel;

  $header_data = $myreportModel->loadheader_sp($pubuserpkey);
  $report_data = $myreportModel->loaddata_sp($pubuserpkey);

  //$projectname = $header_data['hdr_projectname'];


  class PDF extends FPDF {

    // Page header
    function Header() {

      global $header_data;

      if ($this->PageNo()==1) {

        // zikay logo..
        $this->Image('../gfx/zikayheader.png',98,10,100,20);	//390, 87);

        // title
        $this->SetXY(118,35);
        $this->SetFont('Arial','B',9);
        $this->Cell(60,5,'SUPPLIER PERFORMANCE REPORT','B',1,'C');

        // project info
        $this->SetXY(10,45);
        $this->SetFont('Arial','B',7);
        $this->Cell(30,5,'PROJECT TITLE',0,0);
        $this->SetX(40);
        $this->Cell(5,5,':',0,0);
        $this->SetX(50);
        $this->Cell(200,5,$header_data['hdr_projectname'],0,0);

        // date filter
        $this->SetXY(10,50);
        $this->SetFont('Arial','B',7);
        $this->Cell(30,5,'DATE',0,0);
        $this->SetX(40);
        $this->Cell(5,5,':',0,0);
        $this->SetX(50);
        $this->Cell(25,5,$header_data['hdr_datefrom'],1,0);
        $this->SetX(80);
        $this->Cell(5,5,'TO',0,0);
        $this->SetX(90);
        $this->Cell(25,5,$header_data['hdr_dateto'],1,0);

        //Line break
        $this->Ln(15);
      }

      $this->SetFont('Arial','B',6);
      $this->SetX(10);

      $header=array('NO','SUPPLIER','PO ISSUED','PO CANCELLED','PO DELIVERED','PO OUTSTANDING','PO ON TIME','PO NOT ON TIME');

      //Column widths (276)
      $w=array(10,86,30,30,30,30,30,30);

      //Headers
      for($i=0;$i<count($header);$i++)
          $this->Cell($w[$i],5,$header[$i],1,0,'C');
      $this->Ln();

    }

    // Page footer
    function Footer() {

      global $user_data;

      $this->Line(10,194,290,194);

      // printer and date (1.5 cm from bottom)..
      $this->SetXY(10,-15);
      $this->SetFont('Arial','',7);
      $this->Cell(0,5,'Print Date : '.unconverttounixslash(getdatestamp()).' - Printed By : '.$user_data['staff_name'],0,0,'L');

      // page no (1.5 cm from bottom)..
      $this->SetXY(-15,-15);
      $this->SetFont('Arial','',7);
      $this->Cell(0,5,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }

  }


  $pdf=new PDF('L','mm','A4');
  $pdf->Open();
  $pdf->AliasNbPages();
  $pdf->AddPage('L','A4');
  $pdf->SetFont('Arial','',8);

  // data area..

  //for($i=1;$i<=40;$i++)
  //  $pdf->Cell(40,40,'Printing line number '.$i.$pubuserpkey,0,1);
  //$pdf->Cell(40,10,'Hello World');

  //Column widths (276)
  $w=array(10,86,30,30,30,30,30,30);

  $pdf->SetFont('Courier','',7);

  $poissued=0;
  $pocancelled=0;
  $podelivered=0;
  $pooutstanding=0;
  $poontime=0;
  $ponotontime=0;

  foreach($report_data as $row) {
    $poissued += $row[2];
    $pocancelled += $row[3];
    $podelivered += $row[4];
    $pooutstanding += $row[5];
    $poontime += $row[6];
    $ponotontime += $row[7];
    $pdf->SetFont('Arial','',6);
    $pdf->Cell($w[0],5,$row[0],1,0,'C');
    $pdf->Cell($w[1],5,$row[1],1,0);
    $pdf->SetFont('Courier','',7);
    $pdf->Cell($w[2],5,number_format($row[2]),1,0,'C');
    $pdf->Cell($w[3],5,number_format($row[3]),1,0,'C');
    $pdf->Cell($w[4],5,number_format($row[4]),1,0,'C');
    $pdf->Cell($w[5],5,number_format($row[5]),1,0,'C');
    $pdf->Cell($w[6],5,number_format($row[6]),1,0,'C');
    $pdf->Cell($w[7],5,number_format($row[7]),1,0,'C');
    $pdf->Ln();
  }

  $pdf->Ln();
  $pdf->Ln();
  $pdf->SetFont('Arial','B',6);
  $pdf->Cell($w[0],5,'',1);
  $pdf->Cell($w[1],5,'TOTAL',1);
  $pdf->SetFont('Courier','B',7);
  $pdf->Cell($w[2],5,number_format($poissued,0),1,0,'C');
  $pdf->Cell($w[3],5,number_format($pocancelled,0),1,0,'C');
  $pdf->Cell($w[4],5,number_format($podelivered,0),1,0,'C');
  $pdf->Cell($w[5],5,number_format($pooutstanding,0),1,0,'C');
  $pdf->Cell($w[6],5,number_format($poontime,0),1,0,'C');
  $pdf->Cell($w[7],5,number_format($ponotontime,0),1,0,'C');
  $pdf->Ln();


  // output..

  $pdf->Output();
  exit;


  /* For outputting to a file..
  $file = basename(tempnam('.', 'tmp'));
  rename($file, $file.'.pdf');
  $file .= '.pdf';
  $pdf->Output($file, 'F');
  header('Location: '.$file);
  */

?>