<?
  /*
  Notes: 210.001mm x 297.00mm
  */

  $pubuserpkey=$_GET['userid'];

  //include_once('../includes.php');
  include_once('../dbincludes.php');
  include_once('../lib/lib_general.php');

  define('FPDF_FONTPATH','../lib/fpdf/font/');
  require('../lib/fpdf/fpdf.php');

  include_once('../models/userModel.php');
  $myuserModel=new userModel;

  $user_data = $myuserModel->getdata_user($pubuserpkey);

  include_once('../models/reportModel.php');
  $myreportModel=new reportModel;

  $header_data = $myreportModel->loadheader_scm($pubuserpkey);
  $report_data = $myreportModel->loaddata_scm($pubuserpkey);

  //$projectname = $header_data['hdr_projectname'];
  if($header_data['hdr_subconname']=='' || strlen($header_data['hdr_subconname'])<2) {
    $subcontitle = "ALL";
  }else{
    $subcontitle = $header_data['hdr_subconname'];
  }

  class PDF extends FPDF {

    // Page header
    function Header() {

      global $header_data,$subcontitle;

      if ($this->PageNo()==1) {

        // zikay logo..
        $this->Image('../gfx/zikayheader.png',98,10,100,20);	//390, 87);

        // title
        $this->SetXY(118,35);
        $this->SetFont('Arial','B',9);
        $this->Cell(60,5,'SUB-CON MATERIAL REPORT','B',1,'C');

        // project info
        $this->SetXY(10,45);
        $this->SetFont('Arial','B',7);
        $this->Cell(30,5,'PROJECT TITLE',0,0);
        $this->SetX(40);
        $this->Cell(5,5,':',0,0);
        $this->SetX(50);
        $this->Cell(200,5,$header_data['hdr_projectname'],0,0);

        // subcon info
        $this->SetXY(10,50);
        $this->SetFont('Arial','B',7);
        $this->Cell(30,5,'SUB-CONTRACTOR',0,0);
        $this->SetX(40);
        $this->Cell(5,5,':',0,0);
        $this->SetX(50);
        $this->Cell(200,5, $subcontitle ,0,0); //# myapit $header_data['hdr_subconname'],0,0);

        // date filter
        $this->SetXY(10,55);
        $this->SetFont('Arial','B',7);
        $this->Cell(30,5,'DATE',0,0);
        $this->SetX(40);
        $this->Cell(5,5,':',0,0);
        $this->SetX(50);
        $this->Cell(25,5,$header_data['hdr_datefrom'],1,0);
        $this->SetX(80);
        $this->Cell(5,5,'TO',0,0);
        $this->SetX(90);
        $this->Cell(25,5,$header_data['hdr_dateto'],1,0);

        //Line break
        $this->Ln(15);
      }

      $this->SetFont('Arial','B',6);
      $this->SetX(10);

      $header=array('NO','SUPPLIER','PO NO','PO DATE','PO AMOUNT','INVOICE NO','INVOICE DATE','AMOUNT');

      //Column widths (276)
      $w=array(10,86,30,30,30,30,30,30);

      //Headers
      for($i=0;$i<count($header);$i++)
          $this->Cell($w[$i],5,$header[$i],1,0,'C'); // asal Cell
      $this->Ln();

    }

    // Page footer
    function Footer() {

      global $user_data;

      $this->Line(10,194,290,194);

      // printer and date (1.5 cm from bottom)..
      $this->SetXY(10,-15);
      $this->SetFont('Arial','',7);
      $this->Cell(0,5,'Print Date : '.unconverttounixslash(getdatestamp()).' - Printed By : '.$user_data['staff_name'],0,0,'L');

      // page no (1.5 cm from bottom)..
      $this->SetXY(-15,-15);
      $this->SetFont('Arial','',7);
      $this->Cell(0,5,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }

  }


  $pdf=new PDF('L','mm','A4');
  $pdf->Open();
  $pdf->AliasNbPages();
  $pdf->AddPage('L','A4');
  $pdf->SetFont('Arial','',8);

  // data area..

  //for($i=1;$i<=40;$i++)
  //  $pdf->Cell(40,40,'Printing line number '.$i.$pubuserpkey,0,1);
  //$pdf->Cell(40,10,'Hello World');

  //Column widths (276)
  $w=array(10,86,30,30,30,30,30,30);

  $pdf->SetFont('Courier','',6);
  #Cell($w[$i],5,$header[$i],1,0,'C');
  foreach($report_data as $row) {
    if (($prevpono != $row['data_pono'])||($prevsupp != $row['data_suppliername'])) {
      $pdf->Cell($w[0],5,$row['data_no'],1);
      $pdf->Cell($w[1],5,$row['data_suppliername'],1,0,'C');
      $pdf->Cell($w[2],5,$row['data_pono'],1,0,'C');
      $pdf->Cell($w[3],5,$row['data_podate'],1,0,'C');
      $pdf->Cell($w[4],5,number_format($row['data_poamount'],2),1,0,'R');
    } else {
      $pdf->Cell($w[0],5,'',1);
      $pdf->Cell($w[1],5,'',1);
      $pdf->Cell($w[2],5,'',1);
      $pdf->Cell($w[3],5,'',1);
      $pdf->Cell($w[4],5,'',1,0,'R');
    }
    $pdf->Cell($w[5],5,$row['data_invoiceno'],1,0,'C');
    $pdf->Cell($w[6],5,$row['data_invoicedate'],1,0,'C');
    $pdf->Cell($w[7],5,number_format($row['data_amount'],2),1,0,'R');
    $pdf->Ln();
    $prevpono = $row['data_pono'];
    $prevsupp = $row['data_suppliername'];
  }
  //Closure line
  //$pdf->Cell(array_sum($w),0,'','T');


  // output..

  $pdf->Output();
  exit;


  /* For outputting to a file..
  $file = basename(tempnam('.', 'tmp'));
  rename($file, $file.'.pdf');
  $file .= '.pdf';
  $pdf->Output($file, 'F');
  header('Location: '.$file);
  */

?>