<?
  /*
  Notes: 210.001mm x 297.00mm
  */

  $pubuserpkey=$_GET['userid'];

  //include_once('../includes.php');
  include_once('../dbincludes.php');
  include_once('../lib/lib_general.php');

  define('FPDF_FONTPATH','../lib/fpdf/font/');
  require('../lib/fpdf/fpdf.php');

  include_once('../models/userModel.php');
  $myuserModel=new userModel;

  $user_data = $myuserModel->getdata_user($pubuserpkey);

  include_once('../models/reportModel.php');
  $myreportModel=new reportModel;

  $header_data = $myreportModel->loadheader_qv($pubuserpkey);
  $report_data = $myreportModel->loaddata_qv($pubuserpkey);

  //$projectname = $header_data['hdr_projectname'];
	
	

  class PDF extends FPDF {

    // Page header
    function Header() {

      global $header_data;
      global $newsection;
      global $datatype;

      if ($this->PageNo()==1) {

        // zikay logo..
        $this->Image('../gfx/zikayheader.png',110,10,100,20);	//390, 87);

        // title
        $this->SetXY(118,35);
        $this->SetFont('Arial','B',9);
        $this->Cell(60,5,'QUANTITY VARIANCE REPORT','B',1,'C');

        // project info
        $this->SetXY(10,45);
        $this->SetFont('Arial','B',7);
        $this->Cell(28,5,'PROJECT TITLE',0,0);
        $this->SetX(35);
        $this->Cell(5,5,':',0,0);
        $this->SetX(40);
        $this->Cell(200,5,$header_data['hdr_projectname'],0,0);

        // date filter
        $this->SetXY(10,52);
        $this->SetFont('Arial','B',7);
        $this->Cell(28,5,'DATE',0,0);
        $this->SetX(35);
        $this->Cell(5,5,':',0,0);
        $this->SetX(40);
        $this->Cell(20,5,$header_data['hdr_datefrom'],1,0);
        $this->SetX(65);
        $this->Cell(5,5,'TO',0,0);
        $this->SetX(75);
        $this->Cell(20,5,$header_data['hdr_dateto'],1,0);

        //Line break
        $this->Ln(10);	//15
      }

      if ($newsection==true) {

        $this->SetFont('Arial','B',7);
        if ($datatype==1) {
          $this->Cell(100,6,'QUANTITY VARIANCE - MATERIAL BUDGET LIST',0,0);
        } else if ($datatype==2) {
          $this->Cell(120,6,'QUANTITY VARIANCE - NOT IN THE MATERIAL BUDGET LIST',0,0);
        }
        $this->Ln();

      }

      $this->SetFont('Arial','B',6);
      $this->SetX(10);

      $header=array('ITEM','MATERIAL','UNIT','EST. QTY','ORDER QTY','QTY VARIANCE','PERCENTAGE','REMARKS');

      //Column widths
      $w=array(10,130,20,20,20,20,20,30);

      //Headers
      for($i=0;$i<count($header);$i++)
          $this->Cell($w[$i],5,$header[$i],1,0,'C');
      $this->Ln();

    }

    // Page footer
    function Footer() {

      global $user_data;

      $this->Line(10,282,203,282);

      // printer and date (1.5 cm from bottom)..
      $this->SetXY(10,-15);
      $this->SetFont('Arial','',7);
      $this->Cell(0,5,'Print Date : '.unconverttounixslash(getdatestamp()).' - Printed By : '.$user_data['staff_name'],0,0,'L');

      // page no (1.5 cm from bottom)..
      $this->SetXY(-15,-15);
      $this->SetFont('Arial','',7);
      $this->Cell(0,5,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }

  }

  $newsection = true;
  $datatype = 1;

  $pdf=new PDF('P','mm','A4');
  $pdf->Open();
  $pdf->AliasNbPages();
  $pdf->AddPage('L','A4');
  $pdf->SetFont('Arial','',8);

  // data area..

  //for($i=1;$i<=40;$i++)
  //  $pdf->Cell(40,40,'Printing line number '.$i.$pubuserpkey,0,1);
  //$pdf->Cell(40,10,'Hello World');

  //Column widths
  $w=array(10,130,20,20,20,20,20,30);

  $pdf->SetFont('Courier','',7);

  $prevgroup="";

  foreach($report_data as $row) {
    if ($datatype!=$row['data_itemtype']) {
      $newsection=true;
      $datatype=$row['data_itemtype'];
      $pdf->AddPage('L','A4');
    } else {
      $newsection=false;
    }
    $pdf->SetFont('Arial','',6);
    //if (($row['data_itemgroup']!=$prevgroup)&&($prevgroup!="")) {
    if ($row['data_itemgroup']!=$prevgroup) {
      //$prevgroup = $row['data_itemgroup'];
	 	 
      $pdf->Cell($w[0],5,'',1);
      $pdf->Cell($w[1],5,'',1);
      $pdf->Cell($w[2],5,'',1);
      $pdf->Cell($w[3],5,'',1);
      $pdf->Cell($w[4],5,'',1);
      $pdf->Cell($w[5],5,'',1);
      $pdf->Cell($w[6],5,'',1);
      $pdf->Cell($w[7],5,'',1);
      $pdf->Ln();
    }
    $prevgroup = $row['data_itemgroup'];
    if ($row['data_itemname']=="") {
      $pdf->SetFont('Arial','B',6);
      $pdf->Cell($w[0],5,$row['data_itemno'].')',1,0,'C');
      $pdf->Cell($w[1],5,dottedstr($row['data_itemgroup'],100),1);
	 
    } else {
      $pdf->SetFont('Arial','',6);
      $pdf->Cell($w[0],5,$row['data_itemno'],1,0,'C');
      $pdf->Cell($w[1],5,dottedstr($row['data_itemname'],100),1);
	 // $pdf->Cell($w[0],5,$row['data_itemno'],1,0,'L',false);
//      $pdf->Cell($w[1],30,$row['data_itemname'],1,'L',false);
    }
    $pdf->Cell($w[2],5,$row['data_itemunit'],1,0,'C');
    if (($row['data_itemname']=="")&&($row['data_estimatedquantity']<=0)) {
      $pdf->SetFont('Arial','',6);	// C7
      $pdf->Cell($w[3],5,'',1);
      $pdf->Cell($w[4],5,'',1);
      $pdf->Cell($w[5],5,'',1);
      $pdf->Cell($w[6],5,'',1);
    } else {
      $pdf->SetFont('Arial','',6);	// C7
      //$pdf->Cell($w[3],5,number_format($row['data_estimatedquantity']),1,0,'R');
	  $pdf->Cell($w[3],5,number_format($row['data_estimatedquantity'],4),1,0,'R');	  
      $pdf->Cell($w[4],5,number_format($row['data_orderquantity'],4),1,0,'R');
      if ($row['data_itemtype']==2) {
	  //====== arie add ===========
			//+++++++++ qty varian +++++++++++++
			$varQV = $row['data_quantityvariance'];
			$varCheck = substr($varQV, 0, 1);
			if ($varCheck  == "-")
			{
				$pdf->SetFont('Arial','B',6); //arie add
				$pdf->SetTextColor(220,50,50); //green x ada effect				
				$pdf->Cell($w[5],5,'+'.substr(number_format($row['data_quantityvariance'],4),1),1,0,'R');
			}
			else
			{
				if ($row['data_quantityvariance']  == 0)
				{
					$pdf->SetFont('Arial','B',6); //arie add
					$pdf->SetTextColor(0,180,0); //green
					$pdf->Cell($w[5],5,substr(number_format($row['data_quantityvariance'],4),0),1,0,'R');				
				}
				
				else
				{
					$pdf->SetFont('Arial','B',6); //arie add
					$pdf->SetTextColor(220,50,50); //red
					$pdf->Cell($w[5],5,'+'.substr(number_format($row['data_quantityvariance'],4),0),1,0,'R'); //negatif nonbudgeted
				}
			}
			
			//+++++++++ qty percentage +++++++++++++
			$varQV = $row['data_percentage'];
			$varCheck = substr($varQV, 0, 1);
			if ($varCheck  == "-")
			{
				$pdf->SetFont('Arial','B',6); //arie add
				$pdf->SetTextColor(0,180,0); //green 
				$pdf->Cell($w[5],5,'+'.substr(number_format($row['data_percentage'],4),1).'%',1,0,'R');
			}
			else
			{
				if ($row['data_percentage']  == 0)
				{
					$pdf->SetFont('Arial','B',6); //arie add
					$pdf->SetTextColor(0,180,0); //green 
					$pdf->Cell($w[5],5,substr(number_format($row['data_percentage'],4),0).'%',1,0,'R');
				}
				else
				{
					$pdf->SetFont('Arial','B',6); //arie add
					$pdf->SetTextColor(220,50,50); //red
					$pdf->Cell($w[5],5,'+'.substr(number_format($row['data_percentage'],4),0).'%',1,0,'R');
				}
			}
			$pdf->SetTextColor(0); 
	 //====== end arie add ===========
      
	    //$pdf->Cell($w[5],5,'+'.number_format($row['data_quantityvariance'],4),1,0,'R');
       // $pdf->Cell($w[6],5,'+'.number_format($row['data_percentage'],4).'%',1,0,'R');
	   
      } else {
        
			 //====== arie add ===========
			$varQV = $row['data_quantityvariance'];
			$varCheck = substr($varQV, 0, 1);
			if ($varCheck  == "-")
			{
				$pdf->SetFont('Arial','B',6); //arie add
				$pdf->SetTextColor(0,180,0); //green negatif budgeted
				$pdf->Cell($w[5],5,'-'.substr(number_format($row['data_quantityvariance'],4),1),1,0,'R');
			}
			else
			{
				if ($row['data_quantityvariance']  == 0)
				{
					$pdf->SetFont('Arial','B',6); //arie add
					$pdf->SetTextColor(220,50,50); //green
					$pdf->Cell($w[5],5,substr(number_format($row['data_quantityvariance'],4),0),1,0,'R');
				}
				
				else
				{
					$pdf->SetFont('Arial','B',6); //arie add
					$pdf->SetTextColor(220,50,50); //merah
					$pdf->Cell($w[5],5,'+'.substr(number_format($row['data_quantityvariance'],4),0),1,0,'R'); //positif budgeted
				}
			}
			
			//+++++++++ qty percentage +++++++++++++
			$varQV = $row['data_percentage'];
			$varCheck = substr($varQV, 0, 1);
			if ($varCheck  == "-")
			{
				$pdf->SetFont('Arial','B',6); //arie add
				$pdf->SetTextColor(0,180,0); //green				
				$pdf->Cell($w[6],5,'-'.substr(number_format($row['data_percentage'],4),1).'%',1,0,'R');
			}
			else
			{
				if ($row['data_quantityvariance']  == 0)
				{
					$pdf->SetFont('Arial','B',6); //arie add
					$pdf->SetTextColor(220,50,50); //green
					$pdf->Cell($w[6],5,substr(number_format($row['data_percentage'],4),0).'%',1,0,'R');
				}
				else
				{				
					$pdf->SetFont('Arial','B',6); //arie add
					$pdf->SetTextColor(220,50,50); //merah
					$pdf->Cell($w[6],5,'+'.substr(number_format($row['data_percentage'],4),0).'%',1,0,'R'); //+ve budgeted
				}
			}
			$pdf->SetTextColor(0); 
		
		 //====== end arie add ===========
		
		//$pdf->Cell($w[5],5,number_format($row['data_quantityvariance'],4),1,0,'R');
        //$pdf->Cell($w[6],5,number_format($row['data_percentage'],4).'%',1,0,'R');
      }
    }
    $pdf->SetFont('Arial','',6);
    $pdf->Cell($w[7],5,$row['data_remarks'],1);
    $pdf->Ln();
  }
  $pdf->Cell($w[0],5,'',1);
  $pdf->Cell($w[1],5,'',1);
  $pdf->Cell($w[2],5,'',1);
  $pdf->Cell($w[3],5,'',1);
  $pdf->Cell($w[4],5,'',1);
  $pdf->Cell($w[5],5,'',1);
  $pdf->Cell($w[6],5,'',1);
  $pdf->Cell($w[7],5,'',1);
  $pdf->Ln();


  // output..

  $pdf->Output();
  exit;


  /* For outputting to a file..
  $file = basename(tempnam('.', 'tmp'));
  rename($file, $file.'.pdf');
  $file .= '.pdf';
  $pdf->Output($file, 'F');
  header('Location: '.$file);
  */

?>