<?
  /*
  Notes: 210.001mm x 297.00mm
  */

  $pubuserpkey=$_GET['userid'];

  //include_once('../includes.php');
  include_once('../dbincludes.php');
  include_once('../lib/lib_general.php');

  define('FPDF_FONTPATH','../lib/fpdf/font/');
  require('../lib/fpdf/fpdf.php');

  include_once('../models/userModel.php');
  $myuserModel=new userModel;

  $user_data = $myuserModel->getdata_user($pubuserpkey);

  include_once('../models/reportModel.php');
  $myreportModel=new reportModel;

  $header_data = $myreportModel->loadheader_po($pubuserpkey);
  $report_data = $myreportModel->loaddata_po($pubuserpkey);

  if ($header_data['hdr_suppliername']=="") $header_data['hdr_suppliername']="ALL";
  if ($header_data['hdr_pono']=="PO000") $header_data['hdr_pono']="ALL";
  if ($header_data['hdr_podate']=="") $header_data['hdr_podate']="ALL";

  //$projectname = $header_data['hdr_projectname'];


  class PDF extends FPDF {

    // Page header
    function Header() {

      global $header_data;

      if ($this->PageNo()==1) {

        // zikay logo..
        $this->Image('../gfx/zikayheader.png',98,10,100,20);	//390, 87);

        // title
        $this->SetXY(123,35);
        $this->SetFont('Arial','B',9);
        $this->Cell(50,5,'PURCHASE ORDER REPORT','B',1,'C');

        // project info
        $this->SetXY(10,45);
        $this->SetFont('Arial','B',7);
        $this->Cell(30,5,'PROJECT TITLE',0,0);
        $this->SetX(40);
        $this->Cell(5,5,':',0,0);
        $this->SetX(50);
        $this->Cell(200,5,$header_data['hdr_projectname'],0,0);

        // supplier info
        $this->SetXY(10,50);
        $this->SetFont('Arial','B',7);
        $this->Cell(30,5,'SUPPLIER',0,0);
        $this->SetX(40);
        $this->Cell(5,5,':',0,0);
        $this->SetX(50);
        $this->Cell(200,5,$header_data['hdr_suppliername'],0,0);

        // po info
        $this->SetXY(10,55);
        $this->SetFont('Arial','B',7);
        $this->Cell(30,5,'PO NO',0,0);
        $this->SetX(40);
        $this->Cell(5,5,':',0,0);
        $this->SetX(50);
        $this->Cell(200,5,$header_data['hdr_pono'],0,0);
        $this->SetXY(10,60);
        $this->SetFont('Arial','B',7);
        $this->Cell(30,5,'PO DATE',0,0);
        $this->SetX(40);
        $this->Cell(5,5,':',0,0);
        $this->SetX(50);
        $this->Cell(200,5,$header_data['hdr_podate'],0,0);

        // date filter
        $this->SetXY(10,65);
        $this->SetFont('Arial','B',7);
        $this->Cell(30,5,'DATE',0,0);
        $this->SetX(40);
        $this->Cell(5,5,':',0,0);
        $this->SetX(50);
        $this->Cell(25,5,$header_data['hdr_datefrom'],1,0);
        $this->SetX(80);
        $this->Cell(5,5,'TO',0,0);
        $this->SetX(90);
        $this->Cell(25,5,$header_data['hdr_dateto'],1,0);

        //Line break
        $this->Ln(15);
      }

      $this->SetFont('Arial','B',6);
      $this->SetX(10);

      $header=array('PO NO','DATE','SUPPLIER','','DATE','DO NO','','','');

      //Column widths
      $w=array(20,20,56,80,20,20,20,20,20);

      //Headers
      $this->Cell(96,5,'PO','TB',0,'C');
      $this->Cell(80,5,'TRADE','TB',0,'C');
      $this->Cell(40,5,'','TB',0,'C');
      $this->Cell(20,5,'QUANTITY','TB',0,'C');
      $this->Cell(20,5,'U/RATE','TB',0,'C');
      $this->Cell(20,5,'AMOUNT','TB',1,'C');
      //$this->SetXY(10,$this->GetY()+1);
      $nexty = $this->GetY()+1;
      $this->Line(10,$nexty,286,$nexty);
      $this->SetXY(10,$nexty);
      for($i=0;$i<count($header);$i++)
          $this->Cell($w[$i],5,$header[$i],'B',0,'C');
      $this->Ln();

    }

    // Page footer
    function Footer() {

      global $user_data;

      $this->Line(10,194,290,194);

      // printer and date (1.5 cm from bottom)..
      $this->SetXY(10,-15);
      $this->SetFont('Arial','',7);
      $this->Cell(0,5,'Print Date : '.unconverttounixslash(getdatestamp()).' - Printed By : '.$user_data['staff_name'],0,0,'L');

      // page no (1.5 cm from bottom)..
      $this->SetXY(-15,-15);
      $this->SetFont('Arial','',7);
      $this->Cell(0,5,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }

  }


  $pdf=new PDF('L','mm','A4');
  $pdf->Open();
  $pdf->AliasNbPages();
  $pdf->AddPage('L','A4');
  $pdf->SetFont('Arial','',8);

  // data area..

  //for($i=1;$i<=40;$i++)
  //  $pdf->Cell(40,40,'Printing line number '.$i.$pubuserpkey,0,1);
  //$pdf->Cell(40,10,'Hello World');

  //Column widths
  $w=array(20,20,56,80,20,20,20,20,20);

  $pdf->SetFont('Courier','',6);

  $prevpo = "";
  $prevsupp = "";
  $previtem = "";

  $quantitysub=0;
  $amountsub=0;
  $quantitytotal=0;
  $amounttotal=0;

  $pdf->SetFont('Arial','',6);

  foreach($report_data as $row) {
    if ($previtem != $row['data_itemname']) {
      if ($previtem != "") {
        $pdf->Cell($w[0],5,'',0,0,'L');
        $pdf->Cell($w[1],5,'',0,0,'L');
        $pdf->Cell($w[2],5,'',0,0,'L');
        $pdf->Cell($w[3],5,'',0,0,'L');
        $pdf->Cell($w[4],5,'',0,0,'L');
        $pdf->Cell($w[5],5,'',0,0,'L');
        $pdf->Cell($w[6],5,number_format($quantitysub,4),'TB',0,'R');
        $pdf->Cell($w[7],5,'',0,0,'R');
        $pdf->Cell($w[8],5,number_format($amountsub,2),'TB',0,'R');
        $pdf->Ln();
        $pdf->Ln();
        $quantitysub = 0;
        $amountsub = 0;
      }
    }
    $quantitysub += $row['data_quantity'];
    $amountsub += $row['data_amount'];
    $quantitytotal += $row['data_quantity'];
    $amounttotal += $row['data_amount'];
    if ($prevpo != $row['data_pono']) {
      $pdf->Cell($w[0],5,$row['data_pono'],0,0,'L');
      $pdf->Cell($w[1],5,$row['data_podate'],0,0,'L');
    } else {
      $pdf->Cell($w[0],5,'',0,0,'L');
      $pdf->Cell($w[1],5,'',0,0,'L');
    }
    if (($prevsupp == $row['data_suppliername'])&&($prevpo == $row['data_pono'])) {
      $pdf->Cell($w[2],5,'',0,0,'L');
    } else {
      $pdf->Cell($w[2],5,$row['data_suppliername'],0,0,'L');
    }
    if (($previtem == $row['data_itemname'])&&($prevsupp == $row['data_suppliername'])&&($prevpo == $row['data_pono'])) {
      $pdf->Cell($w[3],5,'',0,0,'L');
    } else {
      $pdf->Cell($w[3],5,$row['data_itemname'],0,0,'L');
    }
    $pdf->Cell($w[4],5,$row['data_dodate'],0,0,'L');
    $pdf->Cell($w[5],5,$row['data_dono'],0,0,'L');
    $pdf->Cell($w[6],5,number_format($row['data_quantity'],4),0,0,'R');
    $pdf->Cell($w[7],5,number_format($row['data_rate'],2),0,0,'R');
    $pdf->Cell($w[8],5,number_format($row['data_amount'],2),0,0,'R');
    $pdf->Ln();
    $prevpo = $row['data_pono'];
    $prevsupp = $row['data_suppliername'];
    $previtem = $row['data_itemname'];
  }

  $pdf->Cell($w[0],5,'',0,0,'L');
  $pdf->Cell($w[1],5,'',0,0,'L');
  $pdf->Cell($w[2],5,'',0,0,'L');
  $pdf->Cell($w[3],5,'',0,0,'L');
  $pdf->Cell($w[4],5,'',0,0,'L');
  $pdf->Cell($w[5],5,'',0,0,'L');
  $pdf->Cell($w[6],5,number_format($quantitysub,4),'TB',0,'R');
  $pdf->Cell($w[7],5,'',0,0,'R');
  $pdf->Cell($w[8],5,number_format($amountsub,2),'TB',0,'R');
  $pdf->Ln();

  $pdf->Ln();
  $pdf->SetFont('Arial','B',6);
  $pdf->Cell($w[0],5,'GRAND TOTAL','TB');
  $pdf->Cell($w[1],5,'','TB');
  $pdf->Cell($w[2],5,'','TB');
  $pdf->Cell($w[3],5,'','TB');
  $pdf->Cell($w[4],5,'','TB');
  $pdf->Cell($w[5],5,'','TB');
  $pdf->SetFont('Arial','B',6);	// C7
  $pdf->Cell($w[6],5,number_format($quantitytotal,4),'TB',0,'R');
  $pdf->Cell($w[7],5,'','TB');
  $pdf->Cell($w[8],5,number_format($amounttotal,2),'TB',0,'R');
  $pdf->Ln();


  // output..

  $pdf->Output();
  exit;


  /* For outputting to a file..
  $file = basename(tempnam('.', 'tmp'));
  rename($file, $file.'.pdf');
  $file .= '.pdf';
  $pdf->Output($file, 'F');
  header('Location: '.$file);
  */

?>