<?
  /*
  Notes: 210.001mm x 297.00mm
  */

  $pubuserpkey=$_GET['userid'];

  //include_once('../includes.php');
  include_once('../dbincludes.php');
  include_once('../lib/lib_general.php');

  define('FPDF_FONTPATH','../lib/fpdf/font/');
  require('../lib/fpdf/fpdf.php');

  include_once('../models/userModel.php');
  $myuserModel=new userModel;

  $user_data = $myuserModel->getdata_user($pubuserpkey);

  include_once('../models/reportModel.php');
  $myreportModel=new reportModel;

  $header_data = $myreportModel->loadheader_pmc($pubuserpkey);
  $report_data = $myreportModel->loaddata_pmc($pubuserpkey);

  //$projectname = $header_data['hdr_projectname'];


  class PDF extends FPDF {

    // Page header
    function Header() {

      global $header_data;

      if ($this->PageNo()==1) {

        // zikay logo..
        $this->Image('../gfx/zikayheader.png',98,10,100,20);	//390, 87);

        // title
        $this->SetXY(118,35);
        $this->SetFont('Arial','B',9);
        $this->Cell(60,5,'PROJECT MATERIAL COST REPORT','B',1,'C');

        // project info
        $this->SetXY(10,45);
        $this->SetFont('Arial','B',7);
        $this->Cell(30,5,'PROJECT TITLE',0,0);
        $this->SetX(40);
        $this->Cell(5,5,':',0,0);
        $this->SetX(50);
        $this->Cell(200,5,$header_data['hdr_projectname'],0,0);

        // po info
        $this->SetXY(10,50);
        $this->SetFont('Arial','B',7);
        $this->Cell(30,5,'PO NO',0,0);
        $this->SetX(40);
        $this->Cell(5,5,':',0,0);
        $this->SetX(50);
        $this->Cell(200,5,$header_data['hdr_pono'],0,0);

        // date filter
        $this->SetXY(10,55);
        $this->SetFont('Arial','B',7);
        $this->Cell(30,5,'DATE',0,0);
        $this->SetX(40);
        $this->Cell(5,5,':',0,0);
        $this->SetX(50);
        $this->Cell(25,5,$header_data['hdr_datefrom'],1,0);
        $this->SetX(80);
        $this->Cell(5,5,'TO',0,0);
        $this->SetX(90);
        $this->Cell(25,5,$header_data['hdr_dateto'],1,0);

        //Line break
        $this->Ln(15);
      }

      $this->SetFont('Arial','B',6);
      $this->SetX(10);

      $header=array('PO NO','DATE','DESCRIPTION','','INVOICE','DO','QUANTITY','U/RATE','AMOUNT');

      //Column widths
      $w=array(20,20,81,25,25,25,25,25,30);

      //Headers
      for($i=0;$i<count($header);$i++)
          $this->Cell($w[$i],5,$header[$i],'B',0,'C');
      $this->Ln();
      $nexty = $this->GetY()+1;
      $this->Line(10,$nexty,286,$nexty);
      $this->Ln();

    }

    // Page footer
    function Footer() {

      global $user_data;

      $this->Line(10,194,290,194);

      // printer and date (1.5 cm from bottom)..
      $this->SetXY(10,-15);
      $this->SetFont('Arial','',7);
      $this->Cell(0,5,'Print Date : '.unconverttounixslash(getdatestamp()).' - Printed By : '.$user_data['staff_name'],0,0,'L');

      // page no (1.5 cm from bottom)..
      $this->SetXY(-15,-15);
      $this->SetFont('Arial','',7);
      $this->Cell(0,5,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }

  }


  $pdf=new PDF('L','mm','A4');
  $pdf->Open();
  $pdf->AliasNbPages();
  $pdf->AddPage('L','A4');
  $pdf->SetFont('Arial','',8);

  // data area..

  //for($i=1;$i<=40;$i++)
  //  $pdf->Cell(40,40,'Printing line number '.$i.$pubuserpkey,0,1);
  //$pdf->Cell(40,10,'Hello World');

  //Column widths
  $w=array(20,20,81,25,25,25,25,25,30);

  $pdf->SetFont('Courier','',7);

  $grandtotal=0;

  foreach($report_data as $row) {
    $grandtotal +=  str_replace(",","",number_format($row['data_amount'],2));
    if (($prevpono != $row['data_pono'])||($previtem != $row['data_itemname'])) {
      $pdf->Cell($w[0],5,$row['data_pono'],0);
      $pdf->Cell($w[1],5,$row['data_podate'],0);
      $pdf->Cell($w[2],5,substr($row['data_itemname'],0,50),0);
    } else {
      $pdf->Cell($w[0],5,'',0);
      $pdf->Cell($w[1],5,'',0);
      $pdf->Cell($w[2],5,'',0);
    }
    $pdf->Cell($w[3],5,$row['data_date'],0);
    $pdf->Cell($w[4],5,$row['data_invoiceno'],0);
    $pdf->Cell($w[5],5,$row['data_dono'],0);
    $pdf->Cell($w[6],5,number_format($row['data_quantity'],2),0,0,'R');
    $pdf->Cell($w[7],5,number_format($row['data_rate'],2),0,0,'R');
    $pdf->Cell($w[8],5,number_format($row['data_amount'],2),0,0,'R');
    $pdf->Ln();
    $prevpono = $row['data_pono'];
    $previtem = $row['data_itemname'];
  }

  $pdf->Ln();
  $pdf->Ln();
  $pdf->Cell($w[0],5,'',0);
  $pdf->Cell($w[1],5,'',0);
  $pdf->Cell($w[2],5,'',0);
  $pdf->Cell($w[3],5,'',0);
  $pdf->Cell($w[4],5,'',0);
  $pdf->Cell($w[5],5,'',0);
  $pdf->SetFont('Arial','B',6);
  $pdf->Cell($w[6],5,'GRAND TOTAL',0);
  $pdf->Cell($w[7],5,'',0);
  $pdf->SetFont('Courier','',7);
  $pdf->Cell($w[8],5,number_format($grandtotal,2),'B',0,'R');
  $pdf->Ln();


  // output..

  $pdf->Output();
  exit;


  /* For outputting to a file..
  $file = basename(tempnam('.', 'tmp'));
  rename($file, $file.'.pdf');
  $file .= '.pdf';
  $pdf->Output($file, 'F');
  header('Location: '.$file);
  */

?>