<?
  /*
  Notes: 210.001mm x 297.00mm
  */

  $pubuserpkey=$_GET['userid'];

  //include_once('../includes.php');
  include_once('../dbincludes.php');
  include_once('../lib/lib_general.php');

  define('FPDF_FONTPATH','../lib/fpdf/font/');
  require('../lib/fpdf/fpdf.php');

  include_once('../models/userModel.php');
  $myuserModel=new userModel;

  $user_data = $myuserModel->getdata_user($pubuserpkey);

  include_once('../models/reportModel.php');
  $myreportModel=new reportModel;

  $header_data = $myreportModel->loadheader_bm($pubuserpkey);
  $report_data = $myreportModel->loaddata_bm($pubuserpkey);

  //$projectname = $header_data['hdr_projectname'];


  class PDF extends FPDF {

    // Page header
    function Header() {

      global $header_data;

      if ($this->PageNo()==1) {

        // zikay logo..
        $this->Image('../gfx/zikayheader.png',98,10,100,20);	//390, 87);

        // title
        $this->SetXY(118,35);
        $this->SetFont('Arial','B',9);
        $this->Cell(60,5,'BUDGET MONITORING REPORT','B',1,'C');

        // project info
        $this->SetXY(10,45);
        $this->SetFont('Arial','B',7);
        $this->Cell(30,5,'PROJECT TITLE',0,0);
        $this->SetX(40);
        $this->Cell(5,5,':',0,0);
        $this->SetX(50);
        $this->Cell(200,5,$header_data['hdr_projectname'],0,0);

        // date filter
        $this->SetXY(10,50);
        $this->SetFont('Arial','B',7);
        $this->Cell(30,5,'DATE',0,0);
        $this->SetX(40);
        $this->Cell(5,5,':',0,0);
        $this->SetX(50);
        $this->Cell(25,5,$header_data['hdr_datefrom'],1,0);
        $this->SetX(80);
        $this->Cell(5,5,'TO',0,0);
        $this->SetX(90);
        $this->Cell(25,5,$header_data['hdr_dateto'],1,0);

        //Line break
        $this->Ln(15);
      }

      $this->SetFont('Arial','B',7);
      $this->SetX(10);

      $header=array('NO','RFQ NO','TRADE','BUDGET','TOTAL AMOUNT','DIFFERENCE','PERCENTAGE');

      //Column widths (276)
      $w=array(10,30,96,35,35,35,35);

      //Headers
      for($i=0;$i<count($header);$i++)
          $this->Cell($w[$i],5,$header[$i],1,0,'C');
      $this->Ln();

    }

    // Page footer
    function Footer() {

      global $user_data;

      $this->Line(10,194,290,194);

      // printer and date (1.5 cm from bottom)..
      $this->SetXY(10,-15);
      $this->SetFont('Arial','',7);
      $this->Cell(0,5,'Print Date : '.unconverttounixslash(getdatestamp()).' - Printed By : '.$user_data['staff_name'],0,0,'L');

      // page no (1.5 cm from bottom)..
      $this->SetXY(-15,-15);
      $this->SetFont('Arial','',7);
      $this->Cell(0,5,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }

  }


  $pdf=new PDF('L','mm','A4');
  $pdf->Open();
  $pdf->AliasNbPages();
  $pdf->AddPage('L','A4');
  $pdf->SetFont('Arial','',8);

  // data area..

  //for($i=1;$i<=40;$i++)
  //  $pdf->Cell(40,40,'Printing line number '.$i.$pubuserpkey,0,1);
  //$pdf->Cell(40,10,'Hello World');

  //Column widths (276)
  $w=array(10,30,96,35,35,35,35);

  $pdf->SetFont('Courier','',7);

  $myno=0;
  $prevtrade="";

  $budgetsub=0;
  $amountsub=0;
  $diffsub=0;
  $percentsub=0;

  $budgettotal=0;
  $amounttotal=0;
  $difftotal=0;
  $percenttotal=0;

  $good=0;
  $bad=0;

  foreach($report_data as $row) {
    if ($prevtrade != $row['data_subtrade']) {
      $myno=0;
      if ($prevtrade != "") {
        $diffsub = $budgetsub - $amountsub;
        if($diffsub == 0) {
          $percentsub = 0;
        } else {
          //$percentsub = ($diffsub/$budgetsub)*100;
        }
        if ($diffsub>=0) { $good++; } else { $bad++; }
        $pdf->SetLineWidth(0);	//.5
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell($w[0],5,'','LTB');
        $pdf->Cell($w[1],5,'','TB');
        $pdf->Cell($w[2],5,'','TB');
        $pdf->Cell($w[3],5,number_format($budgetsub,2),'TB',0,'R');
        $pdf->Cell($w[4],5,number_format($amountsub,2),'TB',0,'R');
        $pdf->Cell($w[5],5,number_format($diffsub,2),0,'TB','R');
        $pdf->Cell($w[6],5,number_format($percentsub,0).'%','RTB',0,'C');
        $pdf->SetLineWidth(0);
        $pdf->Ln();
        $budgetsub = 0;
        $amountsub = 0;
        $diffsub = 0;
      }
    }
    $myno++;
    $budgettotal += $row['data_budgetamount'];
    $amounttotal += $row['data_actualamount'];
    $difftotal += $row['data_difference'];
    $budgetsub += $row['data_budgetamount'];
    $amountsub += $row['data_actualamount'];
    $diffsub += $row['data_difference'];
    $pdf->SetFont('Arial','',7);
    $pdf->Cell($w[0],5,$myno,1);
    $pdf->Cell($w[1],5,$row['data_rfqno'],1);
    $pdf->Cell($w[2],5,$row['data_subtrade'],1);
    $pdf->SetFont('Arial','',7);	// c7
    $pdf->Cell($w[3],5,number_format($row['data_budgetamount'],2),1,0,'R');
    $pdf->Cell($w[4],5,number_format($row['data_actualamount'],2),1,0,'R');
    $pdf->Cell($w[5],5,number_format($row['data_difference'],2),1,0,'R');
    $pdf->Cell($w[6],5,number_format($row['data_percentage'],0).'%',1,0,'C');
    $pdf->Ln();
    $prevtrade = $row['data_subtrade'];
  }

  $diffsub = $budgetsub - $amountsub;
  if($diffsub == 0){
    $percentsub = 0;
  } else {
    $percentsub = ($diffsub/$budgetsub)*100;
  }
  if ($diffsub>=0) { $good++; } else { $bad++; }
  $pdf->SetLineWidth(0);	//.5
  $pdf->SetFont('Arial','B',7);
  $pdf->Cell($w[0],5,'','LTB');
  $pdf->Cell($w[1],5,'','TB');
  $pdf->Cell($w[2],5,'','TB');
  $pdf->Cell($w[3],5,number_format($budgetsub,2),'TB',0,'R');
  $pdf->Cell($w[4],5,number_format($amountsub,2),'TB',0,'R');
  $pdf->Cell($w[5],5,number_format($diffsub,2),'TB',0,'R');
  $pdf->Cell($w[6],5,number_format($percentsub,0).'%','RTB',0,'C');
  $pdf->SetLineWidth(0);
  $pdf->Ln();
  $pdf->Ln();
  $pdf->Ln();

  $pdf->SetFont('Arial','B',7);
  $pdf->Cell(140,5,'Summary',0,1);
  $pdf->SetFont('Arial','',7);
  $pdf->Cell(80,5,'Budget Not Exceeded',0,0);
  $pdf->Cell(35,5,$good,0,0);
  $pdf->Cell(35,5,'(+)',0,1);
  $pdf->Cell(80,5,'Budget Exceeded',0,0);
  $pdf->Cell(35,5,''.$bad,0,0);
  $pdf->Cell(35,5,'(-)',0,0);
  $pdf->Ln();

  /*
  $percenttotal = ($difftotal/$budgettotal)*100;
  $pdf->Ln();
  $pdf->Ln();
  $pdf->Cell($w[0],5,'',1);
  $pdf->Cell($w[1],5,'',1);
  $pdf->Cell($w[2],5,'',1);
  $pdf->SetFont('Arial','',7);	// C7
  $pdf->Cell($w[3],5,number_format($budgettotal,4),1,0,'R');
  $pdf->Cell($w[4],5,number_format($amounttotal,4),1,0,'R');
  $pdf->Cell($w[5],5,number_format($difftotal,4),1,0,'R');
  $pdf->Cell($w[6],5,number_format($percenttotal,0).'%',1,0,'C');
  $pdf->Ln();
  */

  // output..

  $pdf->Output();
  exit;


  /* For outputting to a file..
  $file = basename(tempnam('.', 'tmp'));
  rename($file, $file.'.pdf');
  $file .= '.pdf';
  $pdf->Output($file, 'F');
  header('Location: '.$file);
  */

?>