<?
include_once('baseModelPMS.php');

class userModel extends baseModelPMS {


	/* ********************************************************************************
	Select list of users
	******************************************************************************** */

	function getlist_users($grouppkey=""){

		$listdata=array();

		$sql="Select GU.user_pkey, GU.user_name, GU.user_password, GU.user_role, GU.user_status, GUG.group_name, SUR.roletype_string, SP.staff_name from general_users GU inner join settings_userroletypes SUR on GU.user_role=SUR.roletype_code left join staff_profiles SP on GU.user_pkey=SP.staff_userpkey left join general_usergroups GUG on GU.user_grouppkey=GUG.group_pkey where GU.user_grouppkey like '".$grouppkey."%' order by SP.staff_name";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of access groups (optional grouppkey)
	******************************************************************************** */

	function getlist_usergroups($grouppkey=""){

		$listdata=array();

		$sql="Select GUG.group_pkey, GUG.group_name, GUG.group_description, GUG.group_level from general_usergroups GUG where GUG.group_pkey like '".$grouppkey."%' order by GUG.group_name";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select a specific user
	******************************************************************************** */

	function getdata_user($userpkey){

		$data=array();

		$sql="Select GU.*, GUG.group_name, SP.staff_name from general_users GU left join general_usergroups GUG on GU.user_grouppkey=GUG.group_pkey left join staff_profiles SP on GU.user_pkey=SP.staff_userpkey where GU.user_pkey='".$userpkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select a specific access group
	******************************************************************************** */

	function getdata_usergroup($grouppkey){

		$data=array();

		$sql="Select GUG.group_name, GUG.group_description, GUG.group_level from general_usergroups GUG where GUG.group_pkey='".$grouppkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select a specific access group complete with access levels
	******************************************************************************** */

	function getdata_usergroupaccess($grouppkey){

		$data=array();

		$sql="Select GUG.group_pkey, GUG.group_name, GUG.group_description, GUG.group_level, GA.* from general_usergroups GUG inner join general_usergroupaccess GA on GUG.group_pkey=GA.access_grouppkey where GUG.group_pkey='".$grouppkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select list of staff profiles
	******************************************************************************** */

	function getlist_staff(){

		$listdata=array();

		$sql="Select SP.*, GU.user_name from staff_profiles SP left join general_users GU on SP.staff_userpkey=GU.user_pkey order by staff_name";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of staff profiles by group pkey
	******************************************************************************** */

	function getlist_staffbygroup($grouppkey){

		$listdata=array();

		$sql="Select SP.*, GU.user_name from staff_profiles SP left join general_users GU on SP.staff_userpkey=GU.user_pkey inner join general_usergroups GUG on GU.user_grouppkey=GUG.group_pkey where GU.user_grouppkey='".$grouppkey."' order by staff_designation, staff_name";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select a specific staff profile (by userpkey!!)
	******************************************************************************** */

	function getdata_staff($userpkey){

		$data=array();

		$sql="Select SP.*, GU.user_name from staff_profiles SP left join general_users GU on SP.staff_userpkey=GU.user_pkey where SP.staff_userpkey='".$userpkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select list of department
	******************************************************************************** */

	function getlist_departments(){

		$listdata=array();

		$sql="Select DEPT.*, DV.div_name from staff_departments DEPT inner join staff_divisions DV on DEPT.dept_divpkey=DV.div_pkey order by DV.div_name, DEPT.dept_name";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select a specific department
	******************************************************************************** */

	function getdata_department($deptpkey){

		$data=array();

		$sql="Select DEPT.*, DV.div_name from staff_departments DEPT inner join staff_divisions DV on DEPT.dept_divpkey=DV.div_pkey where DEPT.dept_pkey='".$deptpkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select list of division
	******************************************************************************** */

	function getlist_divisions(){

		$listdata=array();

		$sql="Select * from staff_divisions order by div_name";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select a specific division
	******************************************************************************** */

	function getdata_division($divpkey){

		$data=array();

		$sql="Select * from staff_divisions where div_pkey='".$divpkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* FUNCTIONS TO INSERT RECORDS */


	/* ********************************************************************************
	Insert/Create a user
	******************************************************************************** */

	function insertdata_user($user_pkey, $user_grouppkey, $user_type, $user_name, $user_password, $user_role, $user_status) {

		// clean/convert/add params..
		if ($user_type=="") $user_type="2";
		if ($user_status=="") $user_status="1";
		if ($user_password=="") $user_password=md5(strtolower($user_name));

		// update..
		$user_pkey=md5(microtime());
		$sa = $this->add_data("User [Add]", "general_users", "user_pkey, user_grouppkey, user_type, user_name, user_password, user_role, user_status",
			"'".$user_pkey."','".$user_grouppkey."',".$user_type.
			",'".$user_name."','".$user_password."',".$user_role.
			",".$user_status);

		// return result..
		if ($sa==1) {
			return $user_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Insert/Create a user group with access levels
	******************************************************************************** */

	//function insertdata_usergroup($group_pkey, $group_name, $group_description, $group_level, $access_grouppkey, $access_supplier_edit, $access_supplier_recommend, $access_supplier_approve, $access_supplier_activate, $access_trade_edit, $access_mbl_edit, $access_mro_edit, $access_mro_approvenormal, $access_mro_recommendvariance, $access_mro_approvevariance, $access_mro_cancel, $access_itq_edit, $access_itq_invite, $access_itq_evaluate, $access_itq_review, $access_itq_approve50k, $access_itq_approve100k, $access_itq_approve1m, $access_itq_approveall, $access_itq_cancel, $access_do_edit, $access_po_close, $access_po_cancel, $access_reports_all, $access_system_managenews, $access_system_manageusers, $access_system_manageaccess) {
	function insertdata_usergroup($group_pkey, $group_name, $group_description, $group_level, $access_grouppkey, $access_project_edit, $access_project_delete, $access_mbl_view, $access_mbl_edit, $access_mbl_approve, $access_mro_view, $access_mro_edit, $access_mro_approvenormal, $access_mro_recommendvariance, $access_mro_approvevariance, $access_mro_cancel, $access_itq_view, $access_itq_edit, $access_itq_invite, $access_itq_evaluate, $access_itq_review, $access_itq_approve50k, $access_itq_approve100k, $access_itq_approve1m, $access_itq_approveall, $access_itq_cancel,
				      $access_po_view, $access_po_close, $access_po_cancel, $access_do_view, $access_do_edit, $access_invoice_view, $access_invoice_edit, $access_reports_all, $access_reports_mbl, $access_reports_qv, $access_reports_po, $access_reports_sp, $access_reports_bm, $access_reports_pmc, $access_reports_scm, $access_reports_iqa, $access_supplier_view, $access_supplier_edit, $access_supplier_recommend, $access_supplier_approve, $access_supplier_activate, $access_trade_edit, $access_client_view, $access_client_edit, $access_subcon_view, $access_subcon_edit, 
				      $access_system_managenews, $access_system_manageusers, $access_system_manageaccess,$access_itq_review_approved) {

		// clean/convert/add params..
		if ($access_project_edit=="") $access_project_edit="0";
		if ($access_project_delete=="") $access_project_delete="0";
		if ($access_mbl_view=="") $access_mbl_view="0";
		if ($access_mbl_edit=="") $access_mbl_edit="0";
		if ($access_mbl_approve=="") $access_mbl_approve="0";
		if ($access_mro_view=="") $access_mro_view="0";
		if ($access_mro_edit=="") $access_mro_edit="0"; 
		if ($access_mro_approvenormal=="") $access_mro_approvenormal="0"; 
		if ($access_mro_recommendvariance=="") $access_mro_recommendvariance="0"; 
		if ($access_mro_approvevariance=="") $access_mro_approvevariance="0"; 
		if ($access_mro_cancel=="") $access_mro_cancel="0"; 
		if ($access_itq_view=="") $access_itq_view="0"; 
		if ($access_itq_edit=="") $access_itq_edit="0"; 
		if ($access_itq_invite=="") $access_itq_invite="0"; 
		if ($access_itq_evaluate=="") $access_itq_evaluate="0";
		if ($access_itq_review=="") $access_itq_review="0";
		if ($access_itq_approve50k=="") $access_itq_approve50k="0";
		if ($access_itq_approve100k=="") $access_itq_approve100k="0";
		if ($access_itq_approve1m=="") $access_itq_approve1m="0";
		if ($access_itq_approveall=="") $access_itq_approveall="0";
		if ($access_itq_cancel=="") $access_itq_cancel="0"; 
		if ($access_po_view=="") $access_po_view="0"; 
		if ($access_po_close=="") $access_po_close="0"; 
		if ($access_po_cancel=="") $access_po_cancel="0"; 
		if ($access_do_view=="") $access_do_view="0"; 
		if ($access_do_edit=="") $access_do_edit="0"; 
		if ($access_invoice_view=="") $access_invoice_view="0"; 
		if ($access_invoice_edit=="") $access_invoice_edit="0"; 
		if ($access_reports_all=="") $access_reports_all="0"; 
		if ($access_reports_mbl=="") $access_reports_mbl="0"; 
		if ($access_reports_qv=="") $access_reports_qv="0"; 
		if ($access_reports_po=="") $access_reports_po="0"; 
		if ($access_reports_sp=="") $access_reports_sp="0"; 
		if ($access_reports_bm=="") $access_reports_bm="0"; 
		if ($access_reports_pmc=="") $access_reports_pmc="0"; 
		if ($access_reports_scm=="") $access_reports_scm="0"; 
		if ($access_reports_iqa=="") $access_reports_iqa="0"; 
		if ($access_supplier_view=="") $access_supplier_view="0"; 
		if ($access_supplier_edit=="") $access_supplier_edit="0";
		if ($access_supplier_recommend=="") $access_supplier_recommend="0"; 
		if ($access_supplier_approve=="") $access_supplier_approve="0"; 
		if ($access_supplier_activate=="") $access_supplier_activate="0"; 
		if ($access_trade_edit=="") $access_trade_edit="0"; 
		if ($access_client_view=="") $access_client_view="0"; 
		if ($access_client_edit=="") $access_client_edit="0"; 
		if ($access_subcon_view=="") $access_subcon_view="0"; 
		if ($access_subcon_edit=="") $access_subcon_edit="0"; 
		if ($access_system_managenews=="") $access_system_managenews="0"; 
		if ($access_system_manageusers=="") $access_system_manageusers="0"; 
		if ($access_system_manageaccess=="") $access_system_manageaccess="0";
        if ($access_itq_review_approved=="") $access_itq_review_approved="0";
		
		// update..
		$group_pkey=md5(microtime());
		$sa = $this->add_data("User Group [Add]", "general_usergroups", "group_pkey, group_name, group_description, group_level",
			"'".$group_pkey."','".$group_name."','".$group_description."',".$group_level);

		$sa = $this->add_data("Group Access [Add]", "general_usergroupaccess", "access_grouppkey, access_project_edit, access_project_delete, access_mbl_view, access_mbl_edit, access_mbl_approve, access_mro_view, access_mro_edit, access_mro_approvenormal, access_mro_recommendvariance, access_mro_approvevariance, access_mro_cancel, access_itq_view, access_itq_edit, access_itq_invite, access_itq_evaluate, access_itq_review, access_itq_approve50k, access_itq_approve100k, access_itq_approve1m, access_itq_approveall, access_itq_cancel, 
											access_po_view, access_po_close, access_po_cancel, access_do_view, access_do_edit, access_invoice_view, access_invoice_edit, access_reports_all, access_reports_mbl, access_reports_qv, access_reports_po, access_reports_sp, access_reports_bm, access_reports_pmc, access_reports_scm, access_reports_iqa, access_supplier_view, access_supplier_edit, access_supplier_recommend, access_supplier_approve, access_supplier_activate, access_trade_edit, access_client_view, access_client_edit, access_subcon_view, access_subcon_edit, 
											access_system_managenews, access_system_manageusers, access_system_manageaccess, access_itq_approve100k",
			"'".$group_pkey."',".$access_project_edit.",".$access_project_delete.
			",".$access_mbl_view.",".$access_mbl_edit.",".$access_mbl_approve.
			",".$access_mro_view.",".$access_mro_edit.
			",".$access_mro_approvenormal.",".$access_mro_recommendvariance.
			",".$access_mro_approvevariance.",".$access_mro_cancel.
			",".$access_itq_view.",".$access_itq_edit.",".$access_itq_invite.
			",".$access_itq_evaluate.",".$access_itq_review.
			",".$access_itq_approve50k.",".$access_itq_approve100k.
			",".$access_itq_approve1m.",".$access_itq_approveall.
			",".$access_itq_cancel.
			",".$access_po_view.",".$access_po_close.",".$access_po_cancel.
			",".$access_do_view.",".$access_do_edit.
			",".$access_invoice_view.",".$access_invoice_edit.
			",".$access_reports_all.",".$access_reports_mbl.
			",".$access_reports_qv.",".$access_reports_po.
			",".$access_reports_sp.",".$access_reports_bm.
			",".$access_reports_pmc.",".$access_reports_scm.
			",".$access_reports_iqa.
			",".$access_supplier_view.",".$access_supplier_edit.
			",".$access_supplier_recommend.",".$access_supplier_approve.
			",".$access_supplier_activate.
			",".$access_trade_edit.
			",".$access_client_view.",".$access_client_edit.
			",".$access_subcon_view.",".$access_subcon_edit.
			",".$access_system_managenews.",".$access_system_manageusers.
			",".$access_itq_review_approved.
			",".$access_system_manageaccess);

		
		$sa = $this->add_data("Group Access [Add]", "general_usergroupaccess", "access_grouppkey, access_supplier_edit, access_supplier_recommend, access_supplier_approve, access_supplier_activate, access_trade_edit, access_mbl_edit, access_mro_edit, access_mro_approvenormal, access_mro_recommendvariance, access_mro_approvevariance, access_mro_cancel, access_itq_edit, access_itq_invite, access_itq_evaluate, access_itq_review, access_itq_approve50k, access_itq_approve100k, access_itq_approve1m, access_itq_approveall, access_itq_cancel, access_do_edit, access_po_close, access_po_cancel, access_reports_all, access_system_managenews, access_system_manageusers, access_system_manageaccess",
			"'".$group_pkey."',".$access_supplier_edit.",".$access_supplier_recommend.
			",".$access_supplier_approve.",".$access_supplier_activate.
			",".$access_trade_edit.",".$access_mbl_edit.",".$access_mro_edit.
			",".$access_mro_approvenormal.",".$access_mro_recommendvariance.
			",".$access_mro_approvevariance.",".$access_mro_cancel.
			",".$access_itq_edit.",".$access_itq_invite.
			",".$access_itq_evaluate.",".$access_itq_review.
			",".$access_itq_approve50k.",".$access_itq_approve100k.
			",".$access_itq_approve1m.",".$access_itq_approveall.
			",".$access_itq_cancel.",".$access_do_edit.
			",".$access_po_close.",".$access_po_cancel.
			",".$access_reports_all.",".$access_system_managenews.
			",".$access_system_manageusers.",".$access_system_manageaccess);
		

		// return result..
		if ($sa==1) {
			return $group_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Insert/Create a staff profile
	******************************************************************************** */

	function insertdata_staff($staff_pkey, $staff_no, $staff_nricno, $staff_title, $staff_name, $staff_phone, $staff_email, $staff_role, $staff_designation, $staff_category, $staff_userpkey, $user_pkey, $user_grouppkey, $user_type, $user_name, $user_password, $user_role, $user_status) {

		// only if admin and new username specified..
		if ($user_name!="") {

			// clean/convert/add params..
			if ($user_type=="") $user_type="2";
			if ($user_status=="") $user_status="1";
			if ($user_password=="") $user_password=md5(strtolower($user_name));

			// update user table first..
			$user_pkey=md5(microtime());
			$sa = $this->add_data("User Profile [Add]", "general_users", "user_pkey, user_grouppkey, user_type, user_name, user_password, user_role, user_status",
				"'".$user_pkey."','".$user_grouppkey."',".$user_type.
				",'".$user_name."','".$user_password."',".$user_role.
				",".$user_status);

			// return result..
			if ($sa==1) {
				$staff_userpkey=$user_pkey;
			} else {
				return false;
			}
		}

		// clean/convert/add params..
		if ($staff_role=="") $staff_role="1";
		if ($staff_category=="") $staff_category="0";

		// update..
		$staff_pkey=md5(microtime());
		$sa = $this->add_data("Staff Profile [Add]", "staff_profiles", "staff_pkey, staff_no, staff_nricno, staff_title, staff_name, staff_phone, staff_email, staff_role, staff_designation, staff_category, staff_userpkey",
			"'".$staff_pkey."','".$staff_no."','".$staff_nricno."','".$staff_title."','".$staff_name."','".$staff_phone."','".$staff_email."',".$staff_role.",'".$staff_designation."',".$staff_category.",'".$staff_userpkey."'");

		// return result..
		if ($sa==1) {
			return $staff_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Insert/Create a department
	******************************************************************************** */

	function insertdata_department($dept_pkey, $dept_divpkey, $dept_code, $dept_name, $dept_description) {

		// clean/convert/add params..

		// update..
		$dept_pkey=md5(microtime());
		$sa = $this->add_data("Department [Add]", "staff_departments", "dept_pkey, dept_divpkey, dept_code, dept_name, dept_description",
			"'".$dept_pkey."','".$dept_divpkey."','".$dept_code."','".$dept_name."','".$dept_description."'");

		// return result..
		if ($sa==1) {
			return $dept_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Insert/Create a division
	******************************************************************************** */

	function insertdata_division($div_pkey, $div_code, $div_name, $div_description) {

		// clean/convert/add params..

		// update..
		$div_pkey=md5(microtime());
		$sa = $this->add_data("Division [Add]", "staff_divisions", "div_pkey, div_code, div_name, div_description",
			"'".$div_pkey."','".$div_code."','".$div_name."','".$div_description."'");

		// return result..
		if ($sa==1) {
			return $div_pkey;
		} else {
			return false;
		}
	}


	/* FUNCTIONS TO UPDATE RECORDS */


	/* ********************************************************************************
	Update/Override an existing user
	******************************************************************************** */

	function updatedata_user($user_pkey, $user_grouppkey, $user_type, $user_name, $user_password, $user_role, $user_status) {

		// clean/convert/add params..

		// update..
		$sa = $this->update_data("User [Edit]", "general_users", "user_grouppkey='".$user_grouppkey.
			"', user_type=".$user_type.
			", user_name='".$user_name.
			"', user_role=".$user_role.
			", user_status=".$user_status,
			"where user_pkey='".$user_pkey."'");

		// return result..
		if ($sa==1) {
			return $user_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update/Override an existing user group with access levels
	> 
	******************************************************************************** */

	//function updatedata_usergroup($group_pkey, $group_name, $group_description, $group_level, $access_grouppkey, $access_supplier_edit, $access_supplier_recommend, $access_supplier_approve, $access_supplier_activate, $access_trade_edit, $access_mbl_edit, $access_mro_edit, $access_mro_approvenormal, $access_mro_recommendvariance, $access_mro_approvevariance, $access_mro_cancel, $access_itq_edit, $access_itq_invite, $access_itq_evaluate, $access_itq_review, $access_itq_approve50k, $access_itq_approve100k, $access_itq_approve1m, $access_itq_approveall, $access_itq_cancel, $access_do_edit, $access_po_close, $access_po_cancel, $access_reports_all, $access_system_managenews, $access_system_manageusers, $access_system_manageaccess) {
	function updatedata_usergroup($group_pkey, $group_name, $group_description, $group_level, $access_grouppkey, $access_project_edit, $access_project_delete, $access_mbl_view, $access_mbl_edit, $access_mbl_approve, $access_mro_view, $access_mro_edit, $access_mro_approvenormal, $access_mro_recommendvariance, $access_mro_approvevariance, $access_mro_cancel, $access_itq_view, $access_itq_edit, $access_itq_invite, $access_itq_evaluate, $access_itq_review, $access_itq_approve50k, $access_itq_approve100k, $access_itq_approve1m, $access_itq_approveall, $access_itq_cancel,
				      $access_po_view, $access_po_close, $access_po_cancel, $access_do_view, $access_do_edit, $access_invoice_view, $access_invoice_edit, $access_reports_all, $access_reports_mbl, $access_reports_qv, $access_reports_po, $access_reports_sp, $access_reports_bm, $access_reports_pmc, $access_reports_scm, $access_reports_iqa, $access_supplier_view, $access_supplier_edit, $access_supplier_recommend, $access_supplier_approve, $access_supplier_activate, $access_trade_edit, $access_client_view, $access_client_edit, $access_subcon_view, $access_subcon_edit, 
				      $access_system_managenews, $access_system_manageusers, $access_system_manageaccess, $access_itq_review_approved, $itq_edit_new, $itq_edit_recommend, $itq_edit_approved, $itq_edit_approved100k, $access_itq_reject_approve100k) {

		// clean/convert/add params..
		if ($access_project_edit=="") $access_project_edit="0";
		if ($access_project_delete=="") $access_project_delete="0";
		if ($access_mbl_view=="") $access_mbl_view="0";
		if ($access_mbl_edit=="") $access_mbl_edit="0";
		if ($access_mbl_approve=="") $access_mbl_approve="0";
		if ($access_mro_view=="") $access_mro_view="0";
		if ($access_mro_edit=="") $access_mro_edit="0"; 
		if ($access_mro_approvenormal=="") $access_mro_approvenormal="0"; 
		if ($access_mro_recommendvariance=="") $access_mro_recommendvariance="0"; 
		if ($access_mro_approvevariance=="") $access_mro_approvevariance="0"; 
		if ($access_mro_cancel=="") $access_mro_cancel="0"; 
		if ($access_itq_view=="") $access_itq_view="0"; 
		if ($access_itq_edit=="") $access_itq_edit="0"; 
		if ($access_itq_invite=="") $access_itq_invite="0"; 
		if ($access_itq_evaluate=="") $access_itq_evaluate="0";
		if ($access_itq_review=="") $access_itq_review="0";
		if ($access_itq_approve50k=="") $access_itq_approve50k="0";
		if ($access_itq_approve100k=="") $access_itq_approve100k="0";
		if ($access_itq_approve1m=="") $access_itq_approve1m="0";
		if ($access_itq_approveall=="") $access_itq_approveall="0";
		if ($access_itq_cancel=="") $access_itq_cancel="0"; 
		if ($access_po_view=="") $access_po_view="0"; 
		if ($access_po_close=="") $access_po_close="0"; 
		if ($access_po_cancel=="") $access_po_cancel="0"; 
		if ($access_do_view=="") $access_do_view="0"; 
		if ($access_do_edit=="") $access_do_edit="0"; 
		if ($access_invoice_view=="") $access_invoice_view="0"; 
		if ($access_invoice_edit=="") $access_invoice_edit="0"; 
		if ($access_reports_all=="") $access_reports_all="0"; 
		if ($access_reports_mbl=="") $access_reports_mbl="0"; 
		if ($access_reports_qv=="") $access_reports_qv="0"; 
		if ($access_reports_po=="") $access_reports_po="0"; 
		if ($access_reports_sp=="") $access_reports_sp="0"; 
		if ($access_reports_bm=="") $access_reports_bm="0"; 
		if ($access_reports_pmc=="") $access_reports_pmc="0"; 
		if ($access_reports_scm=="") $access_reports_scm="0"; 
		if ($access_reports_iqa=="") $access_reports_iqa="0"; 
		if ($access_supplier_view=="") $access_supplier_view="0"; 
		if ($access_supplier_edit=="") $access_supplier_edit="0";
		if ($access_supplier_recommend=="") $access_supplier_recommend="0"; 
		if ($access_supplier_approve=="") $access_supplier_approve="0"; 
		if ($access_supplier_activate=="") $access_supplier_activate="0"; 
		if ($access_trade_edit=="") $access_trade_edit="0"; 
		if ($access_client_view=="") $access_client_view="0"; 
		if ($access_client_edit=="") $access_client_edit="0"; 
		if ($access_subcon_view=="") $access_subcon_view="0"; 
		if ($access_subcon_edit=="") $access_subcon_edit="0"; 
		if ($access_system_managenews=="") $access_system_managenews="0"; 
		if ($access_system_manageusers=="") $access_system_manageusers="0"; 
		if ($access_system_manageaccess=="") $access_system_manageaccess="0";
       // if ($access_itq_review_approved=="") $access_itq_review_approved="0";
		
		// update..
		$sa = $this->update_data("User Group [Edit]", "general_usergroups", "group_name='".$group_name.
			"', group_description='".$group_description.
			"', group_level=".$group_level,
			"where group_pkey='".$group_pkey."'");

		$sa = $this->update_data("Group Access [Edit]", "general_usergroupaccess", "access_supplier_edit=".$access_supplier_edit.
			", access_project_edit=".$access_project_edit.
			", access_project_delete=".$access_project_delete.
			", access_mbl_view=".$access_mbl_view.
			", access_mbl_edit=".$access_mbl_edit.
			", access_mbl_approve=".$access_mbl_approve.
			", access_mro_view=".$access_mro_view.
			", access_mro_edit=".$access_mro_edit.
			", access_mro_approvenormal=".$access_mro_approvenormal.
			", access_mro_recommendvariance=".$access_mro_recommendvariance.
			", access_mro_approvevariance=".$access_mro_approvevariance.
			", access_mro_cancel=".$access_mro_cancel.
			", access_itq_view=".$access_itq_view.
			", access_itq_edit=".$access_itq_edit.
			", access_itq_invite=".$access_itq_invite.
			", access_itq_evaluate=".$access_itq_evaluate.
			", access_itq_review=".$access_itq_review.
			", access_itq_approve50k=".$access_itq_approve50k.
			", access_itq_approve100k=".$access_itq_approve100k.
			", access_itq_approve1m=".$access_itq_approve1m.
			", access_itq_approveall=".$access_itq_approveall.
			", access_itq_cancel=".$access_itq_cancel.
			", access_po_view=".$access_po_view.
			", access_po_close=".$access_po_close.
			", access_po_cancel=".$access_po_cancel.
			", access_do_view=".$access_do_view.
			", access_do_edit=".$access_do_edit.
			", access_invoice_view=".$access_invoice_view.
			", access_invoice_edit=".$access_invoice_edit.
			", access_reports_all=".$access_reports_all.
			", access_reports_mbl=".$access_reports_mbl.
			", access_reports_qv=".$access_reports_qv.
			", access_reports_po=".$access_reports_po.
			", access_reports_sp=".$access_reports_sp.
			", access_reports_bm=".$access_reports_bm.
			", access_reports_pmc=".$access_reports_pmc.
			", access_reports_scm=".$access_reports_scm.
			", access_reports_iqa=".$access_reports_iqa.
			", access_supplier_view=".$access_supplier_view.
			", access_supplier_edit=".$access_supplier_edit.
			", access_supplier_recommend=".$access_supplier_recommend.
			", access_supplier_approve=".$access_supplier_approve.
			", access_supplier_activate=".$access_supplier_activate.
			", access_trade_edit=".$access_trade_edit.
			", access_client_view=".$access_client_view.
			", access_client_edit=".$access_client_edit.
			", access_subcon_view=".$access_subcon_view.
			", access_subcon_edit=".$access_subcon_edit.
			", access_system_managenews=".$access_system_managenews.
			", access_system_manageusers=".$access_system_manageusers.
			", access_system_manageaccess=".$access_system_manageaccess,
			", access_itq_review_approved=".$access_itq_review_approved. //tambahan
			", itq_edit_new=".$itq_edit_new.
			", itq_edit_recommend=".$itq_edit_recommend.
			", itq_edit_approved=".$itq_edit_approved.
			", itq_edit_approved100k=".$itq_edit_approved100k. //
			", access_itq_reject_approve100k=".$access_itq_reject_approve100k.
			" where access_grouppkey='".$group_pkey."'");

		// return result..
		if ($sa==1) {
			return $group_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update/Override an existing staff profile
	> 
	******************************************************************************** */

	function updatedata_staff($staff_pkey, $staff_no, $staff_nricno, $staff_title, $staff_name, $staff_phone, $staff_email, $staff_role, $staff_designation, $staff_category, $staff_userpkey, $user_pkey, $user_grouppkey, $user_type, $user_name, $user_password, $user_role, $user_status) {

		// only if admin and new username specified..
		if ($user_name!="") {

			// clean/convert/add params..
			if ($user_type=="") $user_type="2";
			if ($user_status=="") $user_status="1";
			if ($user_password=="") $user_password=md5(strtolower($user_name));

			if ($user_pkey=="") {

				// update user table first..
				$user_pkey=md5(microtime());
				$sa = $this->add_data("User Profile [Add]", "general_users", "user_pkey, user_grouppkey, user_type, user_name, user_password, user_role, user_status",
					"'".$user_pkey."','".$user_grouppkey."',".$user_type.
					",'".$user_name."','".$user_password."',".$user_role.
					",".$user_status);
			} else {

				// update..
				$sa = $this->update_data("User Profile [Edit]", "general_users", "user_grouppkey='".$user_grouppkey.
					"', user_type=".$user_type.
					", user_name='".$user_name.
					"', user_role=".$user_role.
					", user_status=".$user_status,
					"where user_pkey='".$user_pkey."'");
			}

			// return result..
			if ($sa==1) {
				$staff_userpkey=$user_pkey;
			} else {
				return false;
			}
		}

		// clean/convert/add params..

		// update..
		$sa = $this->update_data("Staff Profile [Edit]", "staff_profiles", "staff_pkey='".$staff_pkey. 
			"', staff_no='".$staff_no. 
			"', staff_nricno='".$staff_nricno. 
			"', staff_title='".$staff_title. 
			"', staff_name='".$staff_name. 
			"', staff_phone='".$staff_phone. 
			"', staff_email='".$staff_email.
			"', staff_role=".$staff_role. 
			", staff_designation='".$staff_designation.
			"', staff_category=".$staff_category. 
			", staff_userpkey='".$staff_userpkey."'",
			"where staff_pkey='".$staff_pkey."'");

		// return result..
		if ($sa==1) {
			return $staff_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update/Override an existing department
	> 
	******************************************************************************** */

	function updatedata_department($dept_pkey, $dept_divpkey, $dept_code, $dept_name, $dept_description) {

		// clean/convert/add params..

		// update..
		$sa = $this->update_data("Department [Edit]", "staff_departments", "dept_pkey='".$dept_pkey. 
			"', dept_divpkey='".$dept_divpkey. 
			"', dept_code='".$dept_code. 
			"', dept_name='".$dept_name. 
			"', dept_description='".$dept_description."'",
			"where dept_pkey='".$dept_pkey."'");

		// return result..
		if ($sa==1) {
			return $dept_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update/Override an existing division
	> 
	******************************************************************************** */

	function updatedata_division($div_pkey, $div_code, $div_name, $div_description) {

		// clean/convert/add params..

		// update..
		$sa = $this->update_data("Division [Edit]", "staff_divisions", "div_pkey='".$div_pkey. 
			"', div_code='".$div_code. 
			"', div_name='".$div_name. 
			"', div_description='".$div_description."'",
			"where div_pkey='".$div_pkey."'");

		// return result..
		if ($sa==1) {
			return $div_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Change password..
	> 
	******************************************************************************** */

	function changepwd_user($user_pkey, $pwd_current, $pwd_new, $pwd_confirm) {

		if (strlen($pwd_new)<3) {
			$_SESSION['Xerrormessage']="Password must be at least 3 characters long!";
			return false;
		} else if ($pwd_new!=$pwd_confirm) {
			$_SESSION['Xerrormessage']="New Passwords do not match!";
			return false;
		} else {
			$currentpassword=md5(strtolower($pwd_current));		
			$finalpassword=md5(strtolower($pwd_new));
			$user_list = $this->getlist_users("");
			$userfound=0;
			foreach ($user_list as $user) {
				if (($user['user_pkey']==$user_pkey)&&($user['user_password']==$currentpassword)) {
					$userfound++;
				}
			}
			if ($userfound!=0) {
				$updateresult=$this->update_data("User Profile [Change Password]", "general_users","user_password='".$finalpassword."'","where user_pkey='".$user_pkey."'");
				if ($updateresult==1) {
					return $user_pkey;
				} else {
					$_SESSION['Xerrormessage']="Password update operation failed!";
					return false;
				}
			} else {
				$_SESSION['Xerrormessage']="Current Password entered is not valid!";
				return false;
			}
		}
	}


	/* ********************************************************************************
	Reset password..
	> 
	******************************************************************************** */

	function resetpwd_user($user_pkey) {

		$mynewpwd="";
		$user_data = $this->getdata_user($user_pkey);
		$mynewpwd=strtolower($user_data['user_name']);
		$sa = $this->setpwd_user($user_pkey, $mynewpwd);

		// return result..
		if ($sa==1) {
			return $user_pkey;
		} else {
			return false;
		}
	}



	/* ********************************************************************************
	Reset password..
	> 
	******************************************************************************** */

	function setpwd_user($user_pkey, $newpwd) {

		$finalpassword=md5(strtolower($newpwd));
		$updatepwd=$this->update_data("User Profile [Set Password]", "general_users","user_password='".$finalpassword."'","where user_pkey='".$user_pkey."'");

		return $updatepwd;
	}


	/* FUNCTIONS TO DELETE RECORDS */


	/* ********************************************************************************
	Delete an existing user
	******************************************************************************** */

	function deletedata_user($user_pkey) {

		// delete subject..
		$sa = $this->delete_data("User [Delete]", "general_users", "where user_pkey = '".$user_pkey."'");

		// return result..
		if ($sa==1) {
			return $user_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Delete an existing user group with access
	> NOTE: Deletion is automatically CASCADED to table general_usergroupaccess
	******************************************************************************** */

	function deletedata_usergroup($group_pkey) {

		// delete subject..
		$sa = $this->delete_data("User Group [Delete]", "general_usergroups", "where group_pkey = '".$group_pkey."'");

		// return result..
		if ($sa==1) {
			return $group_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Delete an existing staff profile (by userpkey!!)
	******************************************************************************** */

	function deletedata_staff($user_pkey) {

		// TO THINK: can delete related user record but might be a bad idea

		// delete staff..
		$sa = $this->delete_data("Staff Profile [Delete]", "staff_profiles", "where staff_userpkey = '".$user_pkey."'");

		// delete user..
		$sa = $this->delete_data("User Profile [Delete]", "general_users", "where user_pkey = '".$user_pkey."'");

		// return result..
		if ($sa==1) {
			return $user_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Delete an existing department
	******************************************************************************** */

	function deletedata_department($dept_pkey) {

		// delete subject..
		$sa = $this->delete_data("Department [Delete]", "staff_departments", "where dept_pkey = '".$dept_pkey."'");

		// return result..
		if ($sa==1) {
			return $dept_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Delete an existing division
	******************************************************************************** */

	function deletedata_division($div_pkey) {

		// delete subject..
		$sa = $this->delete_data("Division [Delete]", "staff_divisions", "where div_pkey = '".$div_pkey."'");

		// return result..
		if ($sa==1) {
			return $div_pkey;
		} else {
			return false;
		}
	}

}
?>