<?
include_once('baseModelPMS.php');

class tradeModel extends baseModelPMS {


	/* QUERYING FUNCTIONS */


	/* ********************************************************************************
	Select list of trades by level
	******************************************************************************** */

	function getlist_tradesbylevel($tradelevel, $tradedescription="", $sortby="tradedescription", $sortdir="ASC") {

		$listdata=array();

		$sql="Select ST.* from settings_trades ST where ST.tradelevel=".$tradelevel." and ST.tradedescription like '%".$tradedescription."%' and ST.tradestatus=1 order by ST.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of trades by level, filtered
	******************************************************************************** */

	function getlist_tradesbylevelfiltered($tradelevel, $tradeparentfilter="", $tradefilter="", $sortby="tradedescription", $sortdir="ASC") {

		$listdata=array();

		$sql="Select ST.* from settings_trades ST inner join settings_trades ST2 on ST.tradeparentpkey=ST2.tradepkey where ST.tradelevel=".$tradelevel." and (ST.tradedescription like '%".$tradefilter."%' or ST.tradecode like '%".$tradefilter."%') and (ST2.tradedescription like '%".$tradeparentfilter."%' or ST2.tradecode like '%".$tradeparentfilter."%') and ST.tradestatus=1 order by ST.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of trades by parent
	******************************************************************************** */

	function getlist_tradesbyparent($tradeparentpkey, $tradedescription="", $sortby="tradedescription", $sortdir="ASC") {

		$listdata=array();

		$sql="Select ST.* from settings_trades ST where ST.tradeparentpkey='".$tradeparentpkey."' and ST.tradedescription like '%".$tradedescription."%' and ST.tradestatus=1 order by ST.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of trades by top parent (subsubtrade only)
	******************************************************************************** */

	function getlist_subsubtradesbytopparent($tradeparentpkey, $sortby="tradedescription", $sortdir="ASC") {

		$listdata=array();

		$sql="select ST.* from settings_trades ST where ST.tradelevel=4 and ST.tradeparentpkey in (select ST2.tradepkey from settings_trades ST2 where ST2.tradelevel=3 and ST2.tradeparentpkey in (select ST3.tradepkey from settings_trades ST3 where ST3.tradelevel=2 and ST3.tradeparentpkey in (select ST4.tradepkey from settings_trades ST4 where ST4.tradelevel=1 and ST4.tradepkey='".$tradeparentpkey."'))) and ST.tradestatus=1 order by ST.".$sortby." ".$sortdir;
		//$sql="Select ST.* from settings_trades ST where ST.tradeparentpkey='".$tradeparentpkey."' and ST.tradedescription like '%".$tradedescription."%' and ST.tradestatus=1 order by ST.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of trades by top parent (subtrade only)
	******************************************************************************** */

	function getlist_subtradesbytopparent($tradeparentpkey, $sortby="tradedescription", $sortdir="ASC") {

		$listdata=array();

		$sql="select ST.* from settings_trades ST where ST.tradelevel=3 and ST.tradeparentpkey in (select ST2.tradepkey from settings_trades ST2 where ST2.tradelevel=2 and ST2.tradeparentpkey in (select ST3.tradepkey from settings_trades ST3 where ST3.tradelevel=1 and ST3.tradepkey='".$tradeparentpkey."')) and ST.tradestatus=1 order by ST.".$sortby." ".$sortdir;
		//$sql="Select ST.* from settings_trades ST where ST.tradeparentpkey='".$tradeparentpkey."' and ST.tradedescription like '%".$tradedescription."%' and ST.tradestatus=1 order by ST.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of trades by specified pkeys
	******************************************************************************** */

	function getlist_tradesbypkeys($pkeylist, $sortby="tradedescription", $sortdir="ASC") {

		$listdata=array();

		$sql="Select ST.* from settings_trades ST where ST.tradepkey in (".$pkeylist.") order by ST.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of all trades
	******************************************************************************** */

	function getlist_alltrades($sortby="tradedescription", $sortdir="ASC") {

		$listdata=array();

		$sql="Select ST1.tradepkey as tradepkey1, ST1.tradecode as tradecode1, ST1.tradedescription as tradedescription1, ST2.tradepkey as tradepkey2, ST2.tradecode as tradecode2, ST2.tradedescription as tradedescription2, ST3.tradepkey as tradepkey3, ST3.tradecode as tradecode3, ST3.tradedescription as tradedescription3, ST4.tradepkey as tradepkey4, ST4.tradecode as tradecode4, ST4.tradedescription as tradedescription4, ST5.tradepkey as tradepkey5, ST5.tradecode as tradecode5, ST5.tradedescription as tradedescription5 from settings_trades ST1 left join settings_trades ST2 on ST2.tradeparentpkey=ST1.tradepkey left join settings_trades ST3 on ST3.tradeparentpkey=ST2.tradepkey left join settings_trades ST4 on ST4.tradeparentpkey=ST3.tradepkey left join settings_trades ST5 on ST5.tradeparentpkey=ST4.tradepkey where ST1.tradeparentpkey='' order by ST1.".$sortby." ".$sortdir.", ST2.".$sortby." ".$sortdir.", ST3.".$sortby." ".$sortdir.", ST4.".$sortby." ".$sortdir.", ST5.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of all trades (filterable up to 5/8 levels)
	******************************************************************************** */
	/*
	function getlist_alltrades($tradedescription1="", $tradedescription2="", $tradedescription3="", $tradedescription4="", $tradedescription5="", $sortby="tradedescription", $sortdir="ASC") {

		$listdata=array();
		$listdata1=array();
		$listdata2=array();
		$listdata3=array();
		$listdata4=array();
		$listdata5=array();

		$sql1="Select ST.* from settings_trades ST where ST.tradelevel=5 and ST.tradedescription5 like '%".$tradedescription5."%' order by ST.".$sortby." ".$sortdir;
		$listdata5=$this->getextendedrows($sql);
		foreach ($listdata5 as $mydata5) {
		}
		return $listdata;
	}
	*/


	/* ********************************************************************************
	Select a particular trade
	******************************************************************************** */

	function getdata_trade($tradepkey){

		$data=array();

		$sql="Select ST.* from settings_trades ST where ST.tradepkey='".$tradepkey."' and ST.tradestatus=1";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select a particular trade's pkey by code
	******************************************************************************** */

	function getdata_pkeybycode($tradecode){

		$data=array();

		$sql="Select tradepkey from settings_trades where tradecode='".$tradecode."'";
		$data=$this->getextendedrow($sql);
		return $data['tradepkey'];
	}


	/* FUNCTIONS TO INSERT RECORDS */


	/* ********************************************************************************
	Insert/Create a new trade
	Duplicate issue?
	******************************************************************************** */

	function insertdata_trade($p_tradepkey, $p_tradeparentpkey, $p_tradelevel, $p_tradecode, $p_tradedescription, $p_tradetype, $p_tradeunit, $p_tradesubcontype, $p_traderemarks, $p_tradereceivedsetting, $p_tradestatus) {

		// convert params..
		$new_tradepkey=md5(microtime());
		$p_tradesubcontype = "0";
		$p_tradestatus = "1";
		if ($p_tradereceivedsetting=="") $p_tradereceivedsetting="0";

		// update data..
		/*
		$sa = $this->add_data("Trade [Add]", "settings_trades", "tradepkey, tradeparentpkey, tradelevel, tradecode, tradedescription, tradetype, tradeunit, tradesubcontype, traderemarks, tradereceivedsetting, tradestatus",
			"'".$new_tradepkey."','".$p_tradeparentpkey."',".$p_tradelevel.
			",'".$p_tradecode."','".$p_tradedescription."','".$p_tradetype.
			"','".$p_tradeunit."',".$p_tradesubcontype.
			",'".$p_traderemarks."',".$p_tradereceivedsetting.",".$p_tradestatus);
		*/
		$sa = $this->add_data("Trade [Add]", "settings_trades", "tradepkey, tradeparentpkey, tradelevel, tradecode, tradedescription, tradetype, tradeunit, tradesubcontype, traderemarks, tradereceivedsetting, tradestatus",
			"'".$new_tradepkey."','".$p_tradeparentpkey."',".$p_tradelevel.
			",'".$p_tradecode."','".$p_tradedescription."','".$p_tradetype.
			"','".$p_tradeunit."',".$p_tradesubcontype.
			",'".$p_traderemarks."',".$p_tradereceivedsetting.",".$p_tradestatus);

		// return result..
		if ($sa==1) {
			//$m=msg_n_goto("index.php?module=settings&task=trades","trade Added Successfully!");
			//echo $m;
			return $new_tradepkey;
		} else {
			//$e=error_n_goto(-1,"Error: Unable to Add trade!");
			//echo $e;
			return false;
		}
	}


	/* FUNCTIONS TO UPDATE RECORDS */


	/* ********************************************************************************
	Update/Override a trade
	> 
	******************************************************************************** */

	function updatedata_trade($p_tradepkey, $p_tradeparentpkey, $p_tradelevel, $p_tradecode, $p_tradedescription, $p_tradetype, $p_tradeunit, $p_tradesubcontype, $p_traderemarks, $p_tradereceivedsetting, $p_tradestatus) {

		// convert params..
		if ($p_tradereceivedsetting==""){ $p_tradereceivedsetting="0"; } else { $p_tradereceivedsetting="1";}

		// update data..
		/*
		$sa = $this->update_data("Trade [Edit]", "settings_trades", "tradeparentpkey = '".$p_tradeparentpkey.
			"', tradelevel = ".$p_tradelevel.
			", tradecode = '".$p_tradecode.
			"', tradedescription = '".$p_tradedescription.
			"', tradetype = '".$p_tradetype.
			"', tradeunit = '".$p_tradeunit.
			"', tradesubcontype = ".$p_tradesubcontype.
			", traderemarks = '".$p_traderemarks.
			"', tradereceivedsetting = ".$p_tradereceivedsetting.
			", tradestatus = ".$p_tradestatus,
			"where tradepkey = '".$p_tradepkey."'");
		*/

		$sa = $this->update_data("Trade [Edit]", "settings_trades", "tradeparentpkey = '".$p_tradeparentpkey.
			"', tradelevel = ".$p_tradelevel.
			", tradecode = '".$p_tradecode.
			"', tradedescription = '".$p_tradedescription.
			"', tradetype = '".$p_tradetype.
			"', tradeunit = '".$p_tradeunit.
			"', traderemarks = '".$p_traderemarks.
			"', tradereceivedsetting = ".$p_tradereceivedsetting,
			"where tradepkey = '".$p_tradepkey."'");

		// return result..
		if ($sa==1) {
			//$m=msg_n_goto("index.php?module=settings&task=trades","trade Updated Successfully!");
			//echo $m;
			return $p_tradepkey;
		} else {
			//$e=error_n_goto(-1,"Error: Unable to Update trade!");
			//echo $e;
			return false;
		}
	}


	/* FUNCTIONS TO DELETE RECORDS */


	/* ********************************************************************************
	Delete an existing trade
	******************************************************************************** */

	function deletedata_trade($p_tradepkey) {

		// delete subject..
		$sa = $this->delete_data("Trade [Delete]", "settings_trades", "where tradepkey = '".$p_tradepkey."'");

		// return result..
		if ($sa==1) {
			return $p_tradepkey;
		} else {
			return false;
		}
	}

}
?>