<?
include_once('baseModel.php');

class supplierModel extends baseModel {


	/* QUERYING FUNCTIONS */


	/* ********************************************************************************
	Select list of suppliers
	$approvalfilter is usually required (but defaulted to 0 in any case)
	$statusfilter and $nobfilter are optional filters
	******************************************************************************** */

	function getlist_suppliers($sortby="supplier_regid", $sortdir="ASC", $namefilter="", $approvalfilter="", $statusfilter="", $nobfilter="") {

		$listdata=array();

		if ($statusfilter!="") {
			if ($approvalfilter!="") {
				$sql="Select SS.* from settings_suppliers SS where SS.supplier_status=".$statusfilter." and SS.supplier_name like '%".$namefilter."%' and SS.supplier_nob like '%".$nobfilter."%' and SS.supplier_approved=".$approvalfilter." order by SS.".$sortby." ".$sortdir;
			} else {
				$sql="Select SS.* from settings_suppliers SS where SS.supplier_status=".$statusfilter." and SS.supplier_name like '%".$namefilter."%' and SS.supplier_nob like '%".$nobfilter."%' order by SS.".$sortby." ".$sortdir;
			}
		} else {
			if ($approvalfilter!="") {
				$sql="Select SS.* from settings_suppliers SS where SS.supplier_name like '%".$namefilter."%' and SS.supplier_nob like '%".$nobfilter."%' and SS.supplier_approved=".$approvalfilter." order by SS.".$sortby." ".$sortdir;
			} else {
				$sql="Select SS.* from settings_suppliers SS where SS.supplier_name like '%".$namefilter."%' and SS.supplier_nob like '%".$nobfilter."%' order by SS.".$sortby." ".$sortdir;
			}
		}
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select a particular supplier's list of bank guarantees
	******************************************************************************** */

	function getlist_bankguarantees($supplierpkey, $sortby="bg_startdate", $sortdir="ASC") {

		$listdata=array();

		$sql="Select SSBG.* from settings_suppliers_bgs SSBG where SSBG.bg_supplierpkey='".$supplierpkey."' order by SSBG.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select a particular supplier's list of contacts
	******************************************************************************** */

	function getlist_contacts($supplierpkey, $sortby="contact_name", $sortdir="ASC") {

		$listdata=array();

		$sql="Select SSC.* from settings_suppliers_contacts SSC where SSC.contact_supplierpkey='".$supplierpkey."' order by SSC.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select a particular supplier's list of approvals
	Recommendations & Approvals (or rejections) are always inserted cumulatively into
	the settings_suppliers_approvals table for tracking purposes
	******************************************************************************** */

	function getlist_approvals($supplierpkey, $sortby="approval_date", $sortdir="ASC") {

		$listdata=array();

		$sql="Select SSA.* from settings_suppliers_approvals SSA where SSA.approval_supplierpkey='".$supplierpkey."' order by SSA.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select a particular supplier
	******************************************************************************** */

	function getdata_supplier($supplierpkey){

		$data=array();

		$sql="Select SS.* from settings_suppliers SS where SS.supplier_pkey='".$supplierpkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}
	
	


	/* ********************************************************************************
	Select a particular bank guarantee
	******************************************************************************** */

	function getdata_bankguarantee($bgpkey, $supplierpkey){

		$data=array();

		$sql="Select SSBG.* from settings_suppliers_bgs SSBG where SSBG.bg_pkey='".$bgpkey."' and SSBG.bg_supplierpkey='".$supplierpkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select a particular supplier's latest approval
	******************************************************************************** */

	function getdata_lastapproval($supplierpkey) {

		$data=array();

		$sql="Select SSA.* from settings_suppliers_approvals SSA where SSA.approval_supplierpkey='".$supplierpkey."' order by SSA.approval_date DESC limit 0,1";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	NOT USED: Select a particular supplier's aggregated bank guarantee
	******************************************************************************** */

	function getdata_bankguarantee_totals($supplierpkey){

		$data=array();

		$sql="Select sum(SSBG.bg_bankamount) as bg_bankamount from settings_suppliers_bgs SSBG inner join settings_suppliers SS on SSBG.bg_supplierpkey=SS.supplier_pkey where SSBG.bg_supplierpkey='".$supplierpkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Get last supplier id
	******************************************************************************** */

	function getdata_lastsupplierid(){

		$data=array();

		$sql="Select max(SS.supplier_regid) as lastid from settings_suppliers SS";
		$data=$this->getextendedrow($sql);
		return $data['lastid'];
	}


	/* FUNCTIONS TO INSERT RECORDS */


	/* ********************************************************************************
	Insert/Create a new supplier
	Duplicate issue?
	******************************************************************************** */

	function insertdata_supplier($p_supplier_pkey, $p_supplier_regid, $p_supplier_regno, $p_supplier_name, $p_supplier_address, $p_supplier_phone, $p_supplier_fax, $p_supplier_email, $p_supplier_pic, $p_supplier_picphone, $p_supplier_ct, $p_supplier_nob, $p_supplier_products, $p_supplier_bgratio, $p_supplier_personalamount, $p_supplier_regdate, $p_supplier_approved, $p_supplier_status) {

		// clean/convert/add params..
		//if ($p_supplier_regdate=="") $p_supplier_regdate=gettimestamp();
		$p_supplier_regdate = converttounix($p_supplier_regdate);
		if ($p_supplier_approved=="") $p_supplier_approved="0";
		if ($p_supplier_status=="") $p_supplier_status="0";
		if ($p_supplier_bgratio=="") $p_supplier_bgratio="0";
		$p_supplier_personalamount=str_replace(",","",$p_supplier_personalamount);

		//$lastid=$this->getdata_lastsupplierid();
		//$lastid++;

		// update..
		$new_supplier_pkey=md5(microtime());

		$sa = $this->add_data("Supplier [Add]", "settings_suppliers", "supplier_pkey, supplier_regid, supplier_regno, supplier_name, supplier_address, supplier_phone, supplier_fax, supplier_email, supplier_pic, supplier_picphone, supplier_ct, supplier_nob, supplier_products, supplier_bgratio, supplier_personalamount, supplier_regdate, supplier_approved, supplier_status",
			"'".$new_supplier_pkey."',"."0".",'".$p_supplier_regno.
			"','".$p_supplier_name."','".$p_supplier_address. 
			"','".$p_supplier_phone."','".$p_supplier_fax."','".$p_supplier_email.
			"','".$p_supplier_pic."','".$p_supplier_picphone."','".$p_supplier_ct. 
			"','".$p_supplier_nob."','".$p_supplier_products."',".$p_supplier_bgratio.
			",".$p_supplier_personalamount.
			",'".$p_supplier_regdate."',".$p_supplier_approved.",".$p_supplier_status);

		// return result..
		if ($sa==1) {
			return $new_supplier_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Insert/Create a new supplier (full version)
	Duplicate issue?
	******************************************************************************** */

	function insertdata_supplierfull($p_supplier_pkey, $p_supplier_regid, $p_supplier_regno, $p_supplier_name, $p_supplier_address, $p_supplier_phone, $p_supplier_fax, $p_supplier_email, $p_supplier_directors, $p_supplier_pic, $p_supplier_picphone, $p_supplier_ct, $p_supplier_nob, $p_supplier_products, $p_supplier_bgratio, $p_supplier_personalamount, $p_supplier_regdate, $p_supplier_approved, $p_supplier_status,
					 $p_contact_pkey1, $p_contact_supplierpkey1, $p_contact_name1, $p_contact_designation1, $p_contact_phone1, $p_contact_email1, $p_contact_pkey2, $p_contact_supplierpkey2, $p_contact_name2, $p_contact_designation2, $p_contact_phone2, $p_contact_email2, $p_contact_pkey3, $p_contact_supplierpkey3, $p_contact_name3, $p_contact_designation3, $p_contact_phone3, $p_contact_email3, $p_contact_main, 
					 $p_bg_pkey1, $p_bg_supplierpkey1, $p_bg_bankamount1, $p_bg_projectname1, $p_bg_startdate1, $p_bg_enddate1, $p_bg_bankname1, $p_bg_pkey2, $p_bg_supplierpkey2, $p_bg_bankamount2, $p_bg_projectname2, $p_bg_startdate2, $p_bg_enddate2, $p_bg_bankname2, $p_bg_pkey3, $p_bg_supplierpkey3, $p_bg_bankamount3, $p_bg_projectname3, $p_bg_startdate3, $p_bg_enddate3, $p_bg_bankname3, $p_bg_pkey4, $p_bg_supplierpkey4, $p_bg_bankamount4, $p_bg_projectname4, $p_bg_startdate4, $p_bg_enddate4, $p_bg_bankname4, $p_bg_pkey5, $p_bg_supplierpkey5, $p_bg_bankamount5, $p_bg_projectname5, $p_bg_startdate5, $p_bg_enddate5, $p_bg_bankname5) {

		// clean/convert/add params..
		//if ($p_supplier_regdate=="") $p_supplier_regdate=gettimestamp();
		$p_supplier_regdate = converttounix($p_supplier_regdate);
		if ($p_supplier_approved=="") $p_supplier_approved="0";
		if ($p_supplier_status=="") $p_supplier_status="0";
		if ($p_supplier_bgratio=="") $p_supplier_bgratio="0";
		$p_supplier_personalamount=str_replace(",","",$p_supplier_personalamount);
		$main[1]="0";
		$main[2]="0";
		$main[3]="0";
		if ($p_contact_main=="1") { $main[1]="1"; $p_supplier_pic=$p_contact_name1; $p_supplier_picphone=$p_contact_phone1; }
		if ($p_contact_main=="2") { $main[2]="1"; $p_supplier_pic=$p_contact_name2; $p_supplier_picphone=$p_contact_phone2; }
		if ($p_contact_main=="3") { $main[3]="1"; $p_supplier_pic=$p_contact_name3; $p_supplier_picphone=$p_contact_phone3; }

		//$lastid=$this->getdata_lastsupplierid();
		//$lastid++;

		// update..
		$new_supplier_pkey=md5(microtime());

		$sa = $this->add_data("Supplier [Add]", "settings_suppliers", "supplier_pkey, supplier_regid, supplier_regno, supplier_name, supplier_address, supplier_phone, supplier_fax, supplier_email, supplier_directors, supplier_pic, supplier_picphone, supplier_ct, supplier_nob, supplier_products, supplier_bgratio, supplier_personalamount, supplier_regdate, supplier_approved, supplier_status",
			"'".$new_supplier_pkey."',"."0".",'".$p_supplier_regno.
			"','".$p_supplier_name."','".$p_supplier_address. 
			"','".$p_supplier_phone."','".$p_supplier_fax."','".$p_supplier_email.
			"','".$p_supplier_directors.
			"','".$p_supplier_pic."','".$p_supplier_picphone."','".$p_supplier_ct. 
			"','".$p_supplier_nob."','".$p_supplier_products."',".$p_supplier_bgratio.
			",".$p_supplier_personalamount.
			",'".$p_supplier_regdate."',".$p_supplier_approved.",".$p_supplier_status);

		// add contacts
		if ($p_contact_name1!="") { $sa2 = $this->insertdata_contact($p_contact_pkey1, $new_supplier_pkey, $p_contact_name1, $p_contact_designation1, $p_contact_phone1, $p_contact_email1, $main[1]); }
		if ($p_contact_name2!="") { $sa2 = $this->insertdata_contact($p_contact_pkey2, $new_supplier_pkey, $p_contact_name2, $p_contact_designation2, $p_contact_phone2, $p_contact_email2, $main[2]); }
		if ($p_contact_name3!="") { $sa2 = $this->insertdata_contact($p_contact_pkey3, $new_supplier_pkey, $p_contact_name3, $p_contact_designation3, $p_contact_phone3, $p_contact_email3, $main[3]); }

		// add bgs
		if ($p_bg_projectname1!="") { $sa3 = $this->insertdata_bankguarantee($p_bg_pkey1, $new_supplier_pkey, $p_bg_bankamount1, $p_bg_projectname1, $p_bg_startdate1, $p_bg_enddate1, $p_bg_bankname1); }
		if ($p_bg_projectname2!="") { $sa3 = $this->insertdata_bankguarantee($p_bg_pkey2, $new_supplier_pkey, $p_bg_bankamount2, $p_bg_projectname2, $p_bg_startdate2, $p_bg_enddate2, $p_bg_bankname2); }
		if ($p_bg_projectname3!="") { $sa3 = $this->insertdata_bankguarantee($p_bg_pkey3, $new_supplier_pkey, $p_bg_bankamount3, $p_bg_projectname3, $p_bg_startdate3, $p_bg_enddate3, $p_bg_bankname3); }
		if ($p_bg_projectname4!="") { $sa3 = $this->insertdata_bankguarantee($p_bg_pkey4, $new_supplier_pkey, $p_bg_bankamount4, $p_bg_projectname4, $p_bg_startdate4, $p_bg_enddate4, $p_bg_bankname4); }
		if ($p_bg_projectname5!="") { $sa3 = $this->insertdata_bankguarantee($p_bg_pkey5, $new_supplier_pkey, $p_bg_bankamount5, $p_bg_projectname5, $p_bg_startdate5, $p_bg_enddate5, $p_bg_bankname5); }

		// return result..
		if ($sa==1) {
			return $new_supplier_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Insert/Create a new supplier bank guarantee
	Duplicate issue?
	******************************************************************************** */

	function insertdata_bankguarantee($p_bg_pkey, $p_bg_supplierpkey, $p_bg_bankamount, $p_bg_projectname, $p_bg_startdate, $p_bg_enddate, $p_bg_bankname) {

		// clean/convert/add params..
		$p_bg_bankamount=str_replace(",","",$p_bg_bankamount);
		$p_bg_startdate=converttounix($p_bg_startdate);
		$p_bg_enddate=converttounix($p_bg_enddate);

		// update..
		$new_bg_pkey=md5(microtime());

		$sa = $this->add_data("Supplier -> Bank Guarantee [Add]", "settings_suppliers_bgs", "bg_pkey, bg_supplierpkey, bg_bankamount, bg_projectname, bg_startdate, bg_enddate, bg_bankname",
			"'".$new_bg_pkey."','".$p_bg_supplierpkey."',".$p_bg_bankamount.
			",'".$p_bg_projectname."','".$p_bg_startdate.
			"','".$p_bg_enddate."','".$p_bg_bankname."'");

		// return result..
		if ($sa==1) {
			return $new_bg_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Insert/Create a new supplier contact
	Duplicate issue?
	******************************************************************************** */

	function insertdata_contact($p_contact_pkey, $p_contact_supplierpkey, $p_contact_name, $p_contact_designation, $p_contact_phone, $p_contact_email, $p_contact_main) {

		// clean/convert/add params..
		if ($p_contact_main=="") $p_contact_main=0;

		// update..
		$new_contact_pkey=md5(microtime());

		$sa = $this->add_data("Supplier -> Contact [Add]", "settings_suppliers_contacts", "contact_pkey, contact_supplierpkey, contact_name, contact_designation, contact_phone, contact_email, contact_main",
			"'".$new_contact_pkey."','".$p_contact_supplierpkey."','".$p_contact_name.
			"','".$p_contact_designation."','".$p_contact_phone.
			"','".$p_contact_email."',".$p_contact_main);

		// return result..
		if ($sa==1) {
			return $new_contact_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Insert/Create a new supplier approval (cumulative)
	Type: 1 = Recommendation, 2 = Approval
	Status: 0 = Unprocessed/Unknown, 1 = Recommended/Approved, 2 = Rejected
	NOTE: At the same, must update status field in table settings_suppliers!
	******************************************************************************** */

	function insertdata_approval($p_approval_pkey, $p_approval_supplierpkey, $p_approval_type, $p_approval_userpkey, $p_approval_officername, $p_approval_date, $p_approval_status, $p_approval_remarks) {

		// clean/convert/add params..
		//$p_approval_date=converttounixfull($p_approval_date);	// use convertfull coz timestamp;
		$p_approval_date=gettimestamp();

		$p_supplier_approved="0";
		if (($p_approval_type=="2")&&($p_approval_status=="1")) $p_supplier_approved="1";

		// update..
		$new_approval_pkey=md5(microtime());

		$sa = $this->add_data("Supplier -> Approval [Add]", "settings_suppliers_approvals", "approval_pkey, approval_supplierpkey, approval_type, approval_userpkey, approval_officername, approval_date, approval_status, approval_remarks",
			"'".$new_approval_pkey."','".$p_approval_supplierpkey."',".$p_approval_type.
			",'".$p_approval_userpkey."','".$p_approval_officername."','".$p_approval_date.
			"',".$p_approval_status.",'".$p_approval_remarks."'");

		if (($p_approval_type=="2")&&($p_approval_status=="1")) {

			$mysupplier=$this->getdata_supplier($p_approval_supplierpkey);

			if ($mysupplier['supplier_regid']=="0") {
				$lastid=$this->getdata_lastsupplierid();
				$lastid++;

				$sa2 = $this->update_data("Supplier [Edit]", "settings_suppliers", "supplier_regid=".$lastid.
					", supplier_status=1",
					"where supplier_pkey='".$p_approval_supplierpkey."'");
			}
		}

		$sa2 = $this->update_data("Supplier [Edit]", "settings_suppliers", "supplier_approved=".$p_supplier_approved,
			"where supplier_pkey='".$p_approval_supplierpkey."'");

		// return result..
		if ($sa==1) {
			return $new_approval_pkey;
		} else {
			return false;
		}
	}


	/* FUNCTIONS TO UPDATE RECORDS */


	/* ********************************************************************************
	Update/Override an existing supplier
	> 
	******************************************************************************** */

	function updatedata_supplier($p_supplier_pkey, $p_supplier_regid, $p_supplier_regno, $p_supplier_name, $p_supplier_address, $p_supplier_phone, $p_supplier_fax, $p_supplier_email, $p_supplier_pic, $p_supplier_picphone, $p_supplier_ct, $p_supplier_nob, $p_supplier_products, $p_supplier_bgratio, $p_supplier_personalamount, $p_supplier_regdate, $p_supplier_approved, $p_supplier_status) {

		// clean/convert/add params..
		//if ($p_supplier_regdate=="") $p_supplier_regdate=gettimestamp();
		$p_supplier_regdate = converttounix($p_supplier_regdate);
		if ($p_supplier_approved=="") $p_supplier_approved="0";
		if ($p_supplier_status=="") $p_supplier_status="0";
		$p_supplier_personalamount=str_replace(",","",$p_supplier_personalamount);

		// update..
		$sa = $this->update_data("Supplier [Edit]", "settings_suppliers", "supplier_regno = '".$p_supplier_regno.
			"', supplier_name = '".$p_supplier_name.
			"', supplier_address = '".$p_supplier_address.
			"', supplier_phone = '".$p_supplier_phone.
			"', supplier_fax = '".$p_supplier_fax.
			"', supplier_email = '".$p_supplier_email.
			"', supplier_pic = '".$p_supplier_pic.
			"', supplier_picphone = '".$p_supplier_picphone.
			"', supplier_ct = '".$p_supplier_ct.
			"', supplier_nob = '".$p_supplier_nob.
			"', supplier_products = '".$p_supplier_products.
			"', supplier_bgratio = ".$p_supplier_bgratio.
			", supplier_personalamount = ".$p_supplier_personalamount.
			", supplier_regdate = '".$p_supplier_regdate.
			"', supplier_approved = ".$p_supplier_approved.
			", supplier_status = ".$p_supplier_status,
			"where supplier_pkey = '".$p_supplier_pkey."'");

		// return result..
		if ($sa==1) {
			return $p_supplier_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update/Override an existing supplier (full version)
	> 
	******************************************************************************** */

	function updatedata_supplierfull($p_supplier_pkey, $p_supplier_regid, $p_supplier_regno, $p_supplier_name, $p_supplier_address, $p_supplier_phone, $p_supplier_fax, $p_supplier_email, $p_supplier_directors, $p_supplier_pic, $p_supplier_picphone, $p_supplier_ct, $p_supplier_nob, $p_supplier_products, $p_supplier_bgratio, $p_supplier_personalamount, $p_supplier_regdate, $p_supplier_approved, $p_supplier_status,
					 $p_contact_pkey1, $p_contact_supplierpkey1, $p_contact_name1, $p_contact_designation1, $p_contact_phone1, $p_contact_email1, $p_contact_pkey2, $p_contact_supplierpkey2, $p_contact_name2, $p_contact_designation2, $p_contact_phone2, $p_contact_email2, $p_contact_pkey3, $p_contact_supplierpkey3, $p_contact_name3, $p_contact_designation3, $p_contact_phone3, $p_contact_email3, $p_contact_main, 
					 $p_bg_pkey1, $p_bg_supplierpkey1, $p_bg_bankamount1, $p_bg_projectname1, $p_bg_startdate1, $p_bg_enddate1, $p_bg_bankname1, $p_bg_pkey2, $p_bg_supplierpkey2, $p_bg_bankamount2, $p_bg_projectname2, $p_bg_startdate2, $p_bg_enddate2, $p_bg_bankname2, $p_bg_pkey3, $p_bg_supplierpkey3, $p_bg_bankamount3, $p_bg_projectname3, $p_bg_startdate3, $p_bg_enddate3, $p_bg_bankname3, $p_bg_pkey4, $p_bg_supplierpkey4, $p_bg_bankamount4, $p_bg_projectname4, $p_bg_startdate4, $p_bg_enddate4, $p_bg_bankname4, $p_bg_pkey5, $p_bg_supplierpkey5, $p_bg_bankamount5, $p_bg_projectname5, $p_bg_startdate5, $p_bg_enddate5, $p_bg_bankname5) {

		// clean/convert/add params..
		//if ($p_supplier_regdate=="") $p_supplier_regdate=gettimestamp();
		$p_supplier_regdate = converttounix($p_supplier_regdate);
		if ($p_supplier_approved=="") $p_supplier_approved="0";
		if ($p_supplier_status=="") $p_supplier_status="0";
		$p_supplier_personalamount=str_replace(",","",$p_supplier_personalamount);

		$main[1]="0";
		$main[2]="0";
		$main[3]="0";
		if ($p_contact_main=="1") { $main[1]="1"; $p_supplier_pic=$p_contact_name1; $p_supplier_picphone=$p_contact_phone1; }
		if ($p_contact_main=="2") { $main[2]="1"; $p_supplier_pic=$p_contact_name2; $p_supplier_picphone=$p_contact_phone2; }
		if ($p_contact_main=="3") { $main[3]="1"; $p_supplier_pic=$p_contact_name3; $p_supplier_picphone=$p_contact_phone3; }

		// update..
		$sa = $this->update_data("Supplier [Edit]", "settings_suppliers", "supplier_regno = '".$p_supplier_regno.
			"', supplier_name = '".$p_supplier_name.
			"', supplier_address = '".$p_supplier_address.
			"', supplier_phone = '".$p_supplier_phone.
			"', supplier_fax = '".$p_supplier_fax.
			"', supplier_email = '".$p_supplier_email.
			"', supplier_directors = '".$p_supplier_directors.
			"', supplier_pic = '".$p_supplier_pic.
			"', supplier_picphone = '".$p_supplier_picphone.
			"', supplier_ct = '".$p_supplier_ct.
			"', supplier_nob = '".$p_supplier_nob.
			"', supplier_products = '".$p_supplier_products.
			"', supplier_bgratio = ".$p_supplier_bgratio.
			", supplier_personalamount = ".$p_supplier_personalamount.
			", supplier_regdate = '".$p_supplier_regdate.
			"', supplier_approved = ".$p_supplier_approved.
			", supplier_status = ".$p_supplier_status,
			"where supplier_pkey = '".$p_supplier_pkey."'");

		// contacts

		if ($p_contact_pkey1!="") { 
			if ($p_contact_name1!="") {
				$sa2 = $this->updatedata_contact($p_contact_pkey1, $p_supplier_pkey, $p_contact_name1, $p_contact_designation1, $p_contact_phone1, $p_contact_email1, $main[1]);
			} else {
				$sa2 = $this->deletedata_contact($p_contact_pkey1, $p_supplier_pkey);
			}
		} else {
			if ($p_contact_name1!="") $sa2 = $this->insertdata_contact($p_contact_pkey1, $p_supplier_pkey, $p_contact_name1, $p_contact_designation1, $p_contact_phone1, $p_contact_email1, $main[1]);
		}

		if ($p_contact_pkey2!="") { 
			if ($p_contact_name2!="") {
				$sa2 = $this->updatedata_contact($p_contact_pkey2, $p_supplier_pkey, $p_contact_name2, $p_contact_designation2, $p_contact_phone2, $p_contact_email2, $main[2]);
			} else {
				$sa2 = $this->deletedata_contact($p_contact_pkey2, $p_supplier_pkey);
			}
		} else {
			if ($p_contact_name2!="") $sa2 = $this->insertdata_contact($p_contact_pkey2, $p_supplier_pkey, $p_contact_name2, $p_contact_designation2, $p_contact_phone2, $p_contact_email2, $main[2]);
		}

		if ($p_contact_pkey3!="") { 
			if ($p_contact_name3!="") {
				$sa2 = $this->updatedata_contact($p_contact_pkey3, $p_supplier_pkey, $p_contact_name3, $p_contact_designation3, $p_contact_phone3, $p_contact_email3, $main[3]);
			} else {
				$sa2 = $this->deletedata_contact($p_contact_pkey3, $p_supplier_pkey);
			}
		} else {
			if ($p_contact_name3!="") $sa2 = $this->insertdata_contact($p_contact_pkey3, $p_supplier_pkey, $p_contact_name3, $p_contact_designation3, $p_contact_phone3, $p_contact_email3, $main[3]);
		}

		// bank guarantees

		if ($p_bg_pkey1!="") { 
			if ($p_bg_projectname1!="") {
				$sa3 = $this->updatedata_bankguarantee($p_bg_pkey1, $p_supplier_pkey, $p_bg_bankamount1, $p_bg_projectname1, $p_bg_startdate1, $p_bg_enddate1, $p_bg_bankname1);
			} else {
				$sa3 = $this->deletedata_bankguarantee($p_bg_pkey1, $p_supplier_pkey);
			}
		} else {
			if ($p_bg_projectname1!="") $sa3 = $this->insertdata_bankguarantee($p_bg_pkey1, $p_supplier_pkey, $p_bg_bankamount1, $p_bg_projectname1, $p_bg_startdate1, $p_bg_enddate1, $p_bg_bankname1);
		}

		if ($p_bg_pkey2!="") { 
			if ($p_bg_projectname2!="") {
				$sa3 = $this->updatedata_bankguarantee($p_bg_pkey2, $p_supplier_pkey, $p_bg_bankamount2, $p_bg_projectname2, $p_bg_startdate2, $p_bg_enddate2, $p_bg_bankname2);
			} else {
				$sa3 = $this->deletedata_bankguarantee($p_bg_pkey2, $p_supplier_pkey);
			}
		} else {
			if ($p_bg_projectname2!="") $sa3 = $this->insertdata_bankguarantee($p_bg_pkey2, $p_supplier_pkey, $p_bg_bankamount2, $p_bg_projectname2, $p_bg_startdate2, $p_bg_enddate2, $p_bg_bankname2);
		}

		if ($p_bg_pkey3!="") { 
			if ($p_bg_projectname3!="") {
				$sa3 = $this->updatedata_bankguarantee($p_bg_pkey3, $p_supplier_pkey, $p_bg_bankamount3, $p_bg_projectname3, $p_bg_startdate3, $p_bg_enddate3, $p_bg_bankname3);
			} else {
				$sa3 = $this->deletedata_bankguarantee($p_bg_pkey3, $p_supplier_pkey);
			}
		} else {
			if ($p_bg_projectname3!="") $sa3 = $this->insertdata_bankguarantee($p_bg_pkey3, $p_supplier_pkey, $p_bg_bankamount3, $p_bg_projectname3, $p_bg_startdate3, $p_bg_enddate3, $p_bg_bankname3);
		}

		if ($p_bg_pkey4!="") { 
			if ($p_bg_projectname4!="") {
				$sa3 = $this->updatedata_bankguarantee($p_bg_pkey4, $p_supplier_pkey, $p_bg_bankamount4, $p_bg_projectname4, $p_bg_startdate4, $p_bg_enddate4, $p_bg_bankname4);
			} else {
				$sa3 = $this->deletedata_bankguarantee($p_bg_pkey4, $p_supplier_pkey);
			}
		} else {
			if ($p_bg_projectname4!="") $sa3 = $this->insertdata_bankguarantee($p_bg_pkey4, $p_supplier_pkey, $p_bg_bankamount4, $p_bg_projectname4, $p_bg_startdate4, $p_bg_enddate4, $p_bg_bankname4);
		}

		if ($p_bg_pkey5!="") { 
			if ($p_bg_projectname5!="") {
				$sa3 = $this->updatedata_bankguarantee($p_bg_pkey5, $p_supplier_pkey, $p_bg_bankamount5, $p_bg_projectname5, $p_bg_startdate5, $p_bg_enddate5, $p_bg_bankname5);
			} else {
				$sa3 = $this->deletedata_bankguarantee($p_bg_pkey5, $p_supplier_pkey);
			}
		} else {
			if ($p_bg_projectname5!="") $sa3 = $this->insertdata_bankguarantee($p_bg_pkey5, $p_supplier_pkey, $p_bg_bankamount5, $p_bg_projectname5, $p_bg_startdate5, $p_bg_enddate5, $p_bg_bankname5);
		}

		// return result..
		if ($sa==1) {
			return $p_supplier_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update/Override an existing bank guarantee
	> 
	******************************************************************************** */

	function updatedata_bankguarantee($p_bg_pkey, $p_bg_supplierpkey, $p_bg_bankamount, $p_bg_projectname, $p_bg_startdate, $p_bg_enddate, $p_bg_bankname) {

		// clean/convert/add params..
		$p_bg_bankamount=str_replace(",","",$p_bg_bankamount);
		$p_bg_startdate=converttounix($p_bg_startdate);
		$p_bg_enddate=converttounix($p_bg_enddate);

		// update..
		$sa = $this->update_data("Supplier -> Bank Guarantee [Edit]", "settings_suppliers_bgs", "bg_supplierpkey = '".$p_bg_supplierpkey.
			"', bg_bankamount = ".$p_bg_bankamount.
			", bg_projectname = '".$p_bg_projectname.
			"', bg_startdate = '".$p_bg_startdate.
			"', bg_enddate = '".$p_bg_enddate.
			"', bg_bankname = '".$p_bg_bankname."'",
			"where bg_pkey = '".$p_bg_pkey."'");

		// return result..
		if ($sa==1) {
			return $p_bg_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update/Override an existing contact
	> 
	******************************************************************************** */

	function updatedata_contact($p_contact_pkey, $p_contact_supplierpkey, $p_contact_name, $p_contact_designation, $p_contact_phone, $p_contact_email, $p_contact_main) {

		// clean/convert/add params..
		if ($p_contact_main=="") $p_contact_main=0;

		// update..
		$sa = $this->update_data("Supplier -> Contact [Edit]", "settings_suppliers_contacts", "contact_supplierpkey = '".$p_contact_supplierpkey.
			"', contact_name = '".$p_contact_name.
			"', contact_designation = '".$p_contact_designation.
			"', contact_phone = '".$p_contact_phone.
			"', contact_email = '".$p_contact_email.
			"', contact_main = ".$p_contact_main,
			"where contact_pkey = '".$p_contact_pkey."'");

		// return result..
		if ($sa==1) {
			return $p_contact_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Change supplier status (active/inactive)
	> 
	******************************************************************************** */

	function updatedata_status($p_supplier_pkey, $p_supplier_status) {

		// clean/convert/add params..

		// update..
		$sa = $this->update_data("Supplier -> Status [Edit]", "settings_suppliers", "supplier_status=".$p_supplier_status,
			"where supplier_pkey='".$p_supplier_pkey."'");

		// return result..
		if ($sa==1) {
			return $p_supplier_pkey;
		} else {
			return false;
		}
	}


	/* FUNCTIONS TO DELETE RECORDS */


	/* ********************************************************************************
	Delete an existing supplier record
	> NOTE: forbid delete if record is used in any transaction!!
	> (forbid before we even reach here)
        > THIS IS IMPORTANT!!!
	******************************************************************************** */

	function deletedata_supplier($p_supplier_pkey) {

		// delete subject..
		$sa = $this->delete_data("Supplier -> Bank Guarantee [Delete]", "settings_suppliers_bgs", "where bg_supplierpkey = '".$p_supplier_pkey."'");
		$sa = $this->delete_data("Supplier -> Contact [Delete]", "settings_suppliers_contacts", "where contact_supplierpkey = '".$p_supplier_pkey."'");
		$sa = $this->delete_data("Supplier [Delete]", "settings_suppliers", "where supplier_pkey = '".$p_supplier_pkey."'");

		// return result..
		if ($sa==1) {
			return $p_supplier_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Delete an existing contact
	> 
	******************************************************************************** */

	function deletedata_contact($p_contact_pkey, $p_contact_supplierpkey) {

		// delete subject..
		$sa = $this->delete_data("Supplier -> Contact [Delete]", "settings_suppliers_contacts", "where contact_pkey = '".$p_contact_pkey."' and contact_supplierpkey = '".$p_contact_supplierpkey."'");

		// return result..
		if ($sa==1) {
			return $p_contact_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Delete an existing bank guarantee
	> 
	******************************************************************************** */

	function deletedata_bankguarantee($p_bg_pkey, $p_bg_supplierpkey) {

		// delete subject..
		$sa = $this->delete_data("Supplier -> Bank Guarantee [Delete]", "settings_suppliers_bgs", "where bg_pkey = '".$p_bg_pkey."' and bg_supplierpkey = '".$p_bg_supplierpkey."'");

		// return result..
		if ($sa==1) {
			return $p_bg_pkey;
		} else {
			return false;
		}
	}

}
?>