<?
include_once('baseModel.php');
include_once('baseModelPMS.php');

class projectModel extends baseModel {


	/* QUERYING FUNCTIONS */


	/* ********************************************************************************
	Select list of projects (get from CMS!)
	******************************************************************************** */

	function getlist_projects($sortby="projectid", $sortdir="ASC") {

		$listdata=array();

		$sql="Select PD.* from project_details PD order by PD.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of consultants
	******************************************************************************** */

	function getlist_consultants($projectpkey) {

		$listdata=array();

		$sql="Select PC.*, SC.* from project_consultants PC inner join settings_consultants SC on PC.consultantmasterpkey=SC.consultantpkey where PC.consultantprojectpkey='".$projectpkey."' order by SC.consultantname ASC";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select a particular project (include client/qs/pm names and phone numbers)
	******************************************************************************** */

	function getdata_project($projectpkey){

		$data=array();

		$sql="SELECT PD.*, SC.*, GU1.userfullname AS projectqsname, GU1.userphone AS projectqsphone, GU1.usermobile1 as projectqsmobile, GU2.userfullname AS projectpmname, GU2.userphone AS projectpmphone, GU2.usermobile1 AS projectpmmobile FROM project_details PD left join settings_clients SC on PD.projectclientpkey=SC.clientpkey left join general_users_cms GU1 on PD.projectqspkey=GU1.userpkey left join general_users_cms GU2 on PD.projectpmpkey=GU2.userpkey where PD.projectpkey='".$projectpkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select a particular project in full
	******************************************************************************** */

	function extract_project($projectpkey){

		$data=array();

		$sql="Select PD.* from project_details PD where PD.projectpkey='".$projectpkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}

}


class projectModelPMS extends baseModelPMS {


	/* QUERYING FUNCTIONS */


	/* ********************************************************************************
	Select list of projects
	******************************************************************************** */

	function getlist_projects($projectpkey="", $sortby="projectid", $sortdir="ASC") {

		$listdata=array();

		$sql="Select PD.* from project_details PD where PD.projectpkey like '%".$projectpkey."%' order by PD.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of project personnel
	******************************************************************************** */

	function getlist_personnel($projectpkey, $sortby="personnelname", $sortdir="ASC") {

		$listdata=array();

		$sql="Select PP.* from project_personnel PP where PP.personnelprojectpkey = '".$projectpkey."' order by PP.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of accessible projects by user
	******************************************************************************** */

	function getlist_useraccess($userpkey, $sortby="projectid", $sortdir="ASC") {

		$listdata=array();

		$sql="Select PUA.*, PD.projectid, PD.projectname from project_useraccess PUA inner join project_details PD on PUA.projectpkey=PD.projectpkey where PUA.user_pkey = '".$userpkey."' order by PD.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select a particular project
	******************************************************************************** */

	function getdata_project($projectpkey){

		$data=array();

		$sql="Select PD.* from project_details PD where PD.projectpkey='".$projectpkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select a particular personnel
	******************************************************************************** */

	function getdata_personnel($personnelpkey){

		$data=array();

		$sql="Select PP.* from project_personnel PP where PP.personnelpkey='".$personnelpkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Check if project already imported
	******************************************************************************** */

	function getstatus_projectimported($projectpkey){

		$data=array();

		$sql="Select count(PD.projectpkey) as projectcount from project_details PD where PD.projectpkey='".$projectpkey."'";
		$data=$this->getextendedrow($sql);
		if ($data['projectcount']!='0') {
			return true;
		} else {
			return false;
		}
	}


	/* FUNCTIONS TO INSERT RECORDS */


	/* ********************************************************************************
	Import a project (called directly from projectController)
	******************************************************************************** */

	function insertdata_project($p_projectpkey, $p_projectid, $p_projectname, $p_projectdescription, $p_projectclientname, $p_projectclientphone, $p_projectvalue, $p_projectcommencementdate, $p_projectcompletiondate, $p_projectqsname, $p_projectqsphone, $p_projectpmname, $p_projectpmphone, $p_projectinhouse, $p_projectco) {

		// convert params..
		//$new_projectpkey=md5(microtime());

		if ($this->getstatus_projectimported($p_projectpkey)) {
			return $this->updatedata_project($p_projectpkey, $p_projectid, $p_projectname, $p_projectdescription, $p_projectclientname, $p_projectclientphone, $p_projectvalue, $p_projectcommencementdate, $p_projectcompletiondate, $p_projectqsname, $p_projectqsphone, $p_projectpmname, $p_projectpmphone, $p_projectinhouse, $p_projectco);
		}

		// update data..
		$sa = $this->add_data("Project [Import]", "project_details", "projectpkey, projectid, projectname, projectdescription, projectclientname, projectclientphone, projectvalue, projectcommencementdate, projectcompletiondate, projectqsname, projectqsphone, projectpmname, projectpmphone, projectinhouse, projectco",
			"'".$p_projectpkey."','".$p_projectid."','".$p_projectname.
			"','".$p_projectdescription."','".$p_projectclientname."','".$p_projectclientphone."','".$p_projectvalue.
			"','".$p_projectcommencementdate."','".$p_projectcompletiondate.
			"','".$p_projectqsname."','".$p_projectqsphone.
			"','".$p_projectpmname."','".$p_projectpmphone.
			"',".$p_projectinhouse.",'".$p_projectco."'");

		// return result..
		if ($sa==1) {
			return $p_projectpkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Insert a project manually
	******************************************************************************** */

	function insertdata_projectfull($p_projectpkey, $p_projectid, $p_projectname, $p_projectdescription, $p_projectclientname, $p_projectclientphone, $p_projectvalue, $p_projectcommencementdate, $p_projectcompletiondate, $p_projectqsname, $p_projectqsphone, $p_projectpmname, $p_projectpmphone, $p_projectinhouse, $p_projectco, $p_projectmanual,
					$p_personnelpkey1, $p_personnelname1, $p_personnelphone1, $p_personnelpkey2, $p_personnelname2, $p_personnelphone2, $p_personnelpkey3, $p_personnelname3, $p_personnelphone3, $p_personnelpkey4, $p_personnelname4, $p_personnelphone4, $p_personnelpkey5, $p_personnelname5, $p_personnelphone5, $p_personnelpkey6, $p_personnelname6, $p_personnelphone6, $p_personnelpkey7, $p_personnelname7, $p_personnelphone7, $p_personnelpkey8, $p_personnelname8, $p_personnelphone8, $p_personnelpkey9, $p_personnelname9, $p_personnelphone9, $p_personnelpkey10, $p_personnelname10, $p_personnelphone10) {

		// convert params..
		$new_projectpkey=md5(microtime());

		// update data..
		$sa = $this->add_data("Project [Import]", "project_details", "projectpkey, projectid, projectname, projectdescription, projectclientname, projectclientphone, projectvalue, projectcommencementdate, projectcompletiondate, projectqsname, projectqsphone, projectpmname, projectpmphone, projectinhouse, projectco, projectmanual",
			"'".$new_projectpkey."','".$p_projectid."','".$p_projectname.
			"','".$p_projectdescription."','".$p_projectclientname."','".$p_projectclientphone."','".$p_projectvalue.
			"','".$p_projectcommencementdate."','".$p_projectcompletiondate.
			"','".$p_projectqsname."','".$p_projectqsphone.
			"','".$p_projectpmname."','".$p_projectpmphone.
			"',".$p_projectinhouse.",'".$p_projectco."',".$p_projectmanual);

		if ($p_personnelname1!="") { $sa2 = $this->insertdata_personnel($p_personnelpkey1, $new_projectpkey, $p_personnelname1, $p_personnelphone1); }
		if ($p_personnelname2!="") { $sa2 = $this->insertdata_personnel($p_personnelpkey2, $new_projectpkey, $p_personnelname2, $p_personnelphone2); }
		if ($p_personnelname3!="") { $sa2 = $this->insertdata_personnel($p_personnelpkey3, $new_projectpkey, $p_personnelname3, $p_personnelphone3); }
		if ($p_personnelname4!="") { $sa2 = $this->insertdata_personnel($p_personnelpkey4, $new_projectpkey, $p_personnelname4, $p_personnelphone4); }
		if ($p_personnelname5!="") { $sa2 = $this->insertdata_personnel($p_personnelpkey5, $new_projectpkey, $p_personnelname5, $p_personnelphone5); }
		if ($p_personnelname6!="") { $sa2 = $this->insertdata_personnel($p_personnelpkey6, $new_projectpkey, $p_personnelname6, $p_personnelphone6); }
		if ($p_personnelname7!="") { $sa2 = $this->insertdata_personnel($p_personnelpkey7, $new_projectpkey, $p_personnelname7, $p_personnelphone7); }
		if ($p_personnelname8!="") { $sa2 = $this->insertdata_personnel($p_personnelpkey8, $new_projectpkey, $p_personnelname8, $p_personnelphone8); }
		if ($p_personnelname9!="") { $sa2 = $this->insertdata_personnel($p_personnelpkey9, $new_projectpkey, $p_personnelname9, $p_personnelphone9); }
		if ($p_personnelname10!="") { $sa2 = $this->insertdata_personnel($p_personnelpkey10, $new_projectpkey, $p_personnelname10, $p_personnelphone10); }

		// return result..
		if ($sa==1) {
			return $new_projectpkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Add new project personnel
	******************************************************************************** */

	function insertdata_personnel($p_personnelpkey, $p_personnelprojectpkey, $p_personnelname, $p_personnelphone) {

		// convert params..
		$new_personnelpkey=md5(microtime());

		// update data..
		$sa = $this->add_data("Project Personnel [Add]", "project_personnel", "personnelpkey, personnelprojectpkey, personnelname, personnelphone",
			"'".$new_personnelpkey."','".$p_personnelprojectpkey.
			"','".$p_personnelname."','".$p_personnelphone."'");

		// return result..
		if ($sa==1) {
			return $new_personnelpkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Add/Override project user access
	******************************************************************************** */

	function insertdata_useraccess($p_user_pkey, $p_all_projectpkeys) {

		// convert params..
		$p_projectpkeys=split(";",$p_all_projectpkeys);

		// clear table first..
		$sa = $this->deletedata_useraccess($p_user_pkey);

		foreach ($p_projectpkeys as $projectpkey) {

			// update data..
			$sa = $this->add_data("Project Access [Add]", "project_useraccess", "projectpkey, user_pkey",
				"'".$projectpkey."','".$p_user_pkey."'");
		}

		// return result..
		if ($sa==1) {
			return $p_user_pkey;
		} else {
			return false;
		}
	}


	/* FUNCTIONS TO UPDATE RECORDS */


	/* ********************************************************************************
	Update/Override an imported project (called directly from projectController)
	> 
	******************************************************************************** */

	function updatedata_project($p_projectpkey, $p_projectid, $p_projectname, $p_projectdescription, $p_projectclientname, $p_projectclientphone, $p_projectvalue, $p_projectcommencementdate, $p_projectcompletiondate, $p_projectqsname, $p_projectqsphone, $p_projectpmname, $p_projectpmphone, $p_projectinhouse, $p_projectco) {

		// convert params..

		// update data..
		$sa = $this->update_data("Project [Reload]", "project_details", "projectpkey = '".$p_projectpkey.
			"', projectid = '".$p_projectid.
			"', projectname = '".$p_projectname.
			"', projectdecsription = '".$p_projectdescription.
			"', projectclientname = '".$p_projectclientname.
			"', projectclientphone = '".$p_projectclientphone.
			"', projectvalue = '".$p_projectvalue.
			"', projectcommencementdate = '".$p_projectcommencementdate.
			"', projectcompletiondate = '".$p_projectcompletiondate.
			"', projectqsname = '".$p_projectqsname.
			"', projectqsphone = '".$p_projectqsphone.
			"', projectpmname = '".$p_projectpmname.
			"', projectpmphone = '".$p_projectpmphone.
			"', projectinhouse = ".$p_projectinhouse.
			", projectco = '".$p_projectco."'",
			"where projectpkey = '".$p_projectpkey."'");

		// return result..
		if ($sa==1) {
			return $p_projectpkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update/Override a keyed in project manually
	> 
	******************************************************************************** */

	function updatedata_projectfull($p_projectpkey, $p_projectid, $p_projectname, $p_projectdescription, $p_projectclientname, $p_projectclientphone, $p_projectvalue, $p_projectcommencementdate, $p_projectcompletiondate, $p_projectqsname, $p_projectqsphone, $p_projectpmname, $p_projectpmphone, $p_projectinhouse, $p_projectco, $p_projectmanual,
					$p_personnelpkey1, $p_personnelname1, $p_personnelphone1, $p_personnelpkey2, $p_personnelname2, $p_personnelphone2, $p_personnelpkey3, $p_personnelname3, $p_personnelphone3, $p_personnelpkey4, $p_personnelname4, $p_personnelphone4, $p_personnelpkey5, $p_personnelname5, $p_personnelphone5, $p_personnelpkey6, $p_personnelname6, $p_personnelphone6, $p_personnelpkey7, $p_personnelname7, $p_personnelphone7, $p_personnelpkey8, $p_personnelname8, $p_personnelphone8, $p_personnelpkey9, $p_personnelname9, $p_personnelphone9, $p_personnelpkey10, $p_personnelname10, $p_personnelphone10) {

		// convert params..

		// update data..
		$sa = $this->update_data("Project [Reload]", "project_details", "projectpkey = '".$p_projectpkey.
			"', projectid = '".$p_projectid.
			"', projectname = '".$p_projectname.
			"', projectdescription = '".$p_projectdescription.
			"', projectclientname = '".$p_projectclientname.
			"', projectclientphone = '".$p_projectclientphone.
			"', projectvalue = '".$p_projectvalue.
			"', projectcommencementdate = '".$p_projectcommencementdate.
			"', projectcompletiondate = '".$p_projectcompletiondate.
			"', projectqsname = '".$p_projectqsname.
			"', projectqsphone = '".$p_projectqsphone.
			"', projectpmname = '".$p_projectpmname.
			"', projectpmphone = '".$p_projectpmphone.
			"', projectinhouse = ".$p_projectinhouse.
			", projectco = '".$p_projectco.
			"', projectmanual = ".$p_projectmanual,
			"where projectpkey = '".$p_projectpkey."'");

		if ($p_personnelpkey1!="") { 
			if ($p_personnelname1!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey1, $p_projectpkey, $p_personnelname1, $p_personnelphone1);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey1);
			}
		} else {
			if ($p_personnelname1!="") $sa2 = $this->insertdata_personnel($p_personnelpkey1, $p_projectpkey, $p_personnelname1, $p_personnelphone1);
		}

		if ($p_personnelpkey2!="") { 
			if ($p_personnelname2!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey2, $p_projectpkey, $p_personnelname2, $p_personnelphone2);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey2);
			}
		} else {
			if ($p_personnelname2!="") $sa2 = $this->insertdata_personnel($p_personnelpkey2, $p_projectpkey, $p_personnelname2, $p_personnelphone2);
		}

		if ($p_personnelpkey3!="") { 
			if ($p_personnelname3!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey3, $p_projectpkey, $p_personnelname3, $p_personnelphone3);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey3);
			}
		} else {
			if ($p_personnelname3!="") $sa2 = $this->insertdata_personnel($p_personnelpkey3, $p_projectpkey, $p_personnelname3, $p_personnelphone3);
		}

		if ($p_personnelpkey4!="") { 
			if ($p_personnelname4!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey4, $p_projectpkey, $p_personnelname4, $p_personnelphone4);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey4);
			}
		} else {
			if ($p_personnelname4!="") $sa2 = $this->insertdata_personnel($p_personnelpkey4, $p_projectpkey, $p_personnelname4, $p_personnelphone4);
		}

		if ($p_personnelpkey5!="") { 
			if ($p_personnelname5!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey5, $p_projectpkey, $p_personnelname5, $p_personnelphone5);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey5);
			}
		} else {
			if ($p_personnelname5!="") $sa2 = $this->insertdata_personnel($p_personnelpkey5, $p_projectpkey, $p_personnelname5, $p_personnelphone5);
		}

		if ($p_personnelpkey6!="") { 
			if ($p_personnelname6!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey6, $p_projectpkey, $p_personnelname6, $p_personnelphone6);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey6);
			}
		} else {
			if ($p_personnelname6!="") $sa2 = $this->insertdata_personnel($p_personnelpkey6, $p_projectpkey, $p_personnelname6, $p_personnelphone6);
		}

		if ($p_personnelpkey7!="") { 
			if ($p_personnelname7!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey7, $p_projectpkey, $p_personnelname7, $p_personnelphone7);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey7);
			}
		} else {
			if ($p_personnelname7!="") $sa2 = $this->insertdata_personnel($p_personnelpkey7, $p_projectpkey, $p_personnelname7, $p_personnelphone7);
		}

		if ($p_personnelpkey8!="") { 
			if ($p_personnelname8!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey8, $p_projectpkey, $p_personnelname8, $p_personnelphone8);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey8);
			}
		} else {
			if ($p_personnelname8!="") $sa2 = $this->insertdata_personnel($p_personnelpkey8, $p_projectpkey, $p_personnelname8, $p_personnelphone8);
		}

		if ($p_personnelpkey9!="") { 
			if ($p_personnelname9!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey9, $p_projectpkey, $p_personnelname9, $p_personnelphone9);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey9);
			}
		} else {
			if ($p_personnelname9!="") $sa2 = $this->insertdata_personnel($p_personnelpkey9, $p_projectpkey, $p_personnelname9, $p_personnelphone9);
		}

		if ($p_personnelpkey10!="") { 
			if ($p_personnelname10!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey10, $p_projectpkey, $p_personnelname10, $p_personnelphone10);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey10);
			}
		} else {
			if ($p_personnelname10!="") $sa2 = $this->insertdata_personnel($p_personnelpkey10, $p_projectpkey, $p_personnelname10, $p_personnelphone10);
		}

		// return result..
		if ($sa==1) {
			return $p_projectpkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update/Override a project's inhouse/co fields
	> 
	******************************************************************************** */

	function updatedata_projectinhouse($p_projectpkey, $p_projectinhouse, $p_projectco,
					   $p_personnelpkey1, $p_personnelname1, $p_personnelphone1, $p_personnelpkey2, $p_personnelname2, $p_personnelphone2, $p_personnelpkey3, $p_personnelname3, $p_personnelphone3, $p_personnelpkey4, $p_personnelname4, $p_personnelphone4, $p_personnelpkey5, $p_personnelname5, $p_personnelphone5, $p_personnelpkey6, $p_personnelname6, $p_personnelphone6, $p_personnelpkey7, $p_personnelname7, $p_personnelphone7, $p_personnelpkey8, $p_personnelname8, $p_personnelphone8, $p_personnelpkey9, $p_personnelname9, $p_personnelphone9, $p_personnelpkey10, $p_personnelname10, $p_personnelphone10) {

		// convert params..

		// update data..
		$sa = $this->update_data("Project [Edit]", "project_details", "projectinhouse = ".$p_projectinhouse.
			", projectco = '".$p_projectco."'",
			"where projectpkey = '".$p_projectpkey."'");

		if ($p_personnelpkey1!="") { 
			if ($p_personnelname1!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey1, $p_projectpkey, $p_personnelname1, $p_personnelphone1);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey1);
			}
		} else {
			if ($p_personnelname1!="") $sa2 = $this->insertdata_personnel($p_personnelpkey1, $p_projectpkey, $p_personnelname1, $p_personnelphone1);
		}

		if ($p_personnelpkey2!="") { 
			if ($p_personnelname2!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey2, $p_projectpkey, $p_personnelname2, $p_personnelphone2);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey2);
			}
		} else {
			if ($p_personnelname2!="") $sa2 = $this->insertdata_personnel($p_personnelpkey2, $p_projectpkey, $p_personnelname2, $p_personnelphone2);
		}

		if ($p_personnelpkey3!="") { 
			if ($p_personnelname3!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey3, $p_projectpkey, $p_personnelname3, $p_personnelphone3);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey3);
			}
		} else {
			if ($p_personnelname3!="") $sa2 = $this->insertdata_personnel($p_personnelpkey3, $p_projectpkey, $p_personnelname3, $p_personnelphone3);
		}

		if ($p_personnelpkey4!="") { 
			if ($p_personnelname4!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey4, $p_projectpkey, $p_personnelname4, $p_personnelphone4);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey4);
			}
		} else {
			if ($p_personnelname4!="") $sa2 = $this->insertdata_personnel($p_personnelpkey4, $p_projectpkey, $p_personnelname4, $p_personnelphone4);
		}

		if ($p_personnelpkey5!="") { 
			if ($p_personnelname5!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey5, $p_projectpkey, $p_personnelname5, $p_personnelphone5);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey5);
			}
		} else {
			if ($p_personnelname5!="") $sa2 = $this->insertdata_personnel($p_personnelpkey5, $p_projectpkey, $p_personnelname5, $p_personnelphone5);
		}

		if ($p_personnelpkey6!="") { 
			if ($p_personnelname6!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey6, $p_projectpkey, $p_personnelname6, $p_personnelphone6);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey6);
			}
		} else {
			if ($p_personnelname6!="") $sa2 = $this->insertdata_personnel($p_personnelpkey6, $p_projectpkey, $p_personnelname6, $p_personnelphone6);
		}

		if ($p_personnelpkey7!="") { 
			if ($p_personnelname7!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey7, $p_projectpkey, $p_personnelname7, $p_personnelphone7);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey7);
			}
		} else {
			if ($p_personnelname7!="") $sa2 = $this->insertdata_personnel($p_personnelpkey7, $p_projectpkey, $p_personnelname7, $p_personnelphone7);
		}

		if ($p_personnelpkey8!="") { 
			if ($p_personnelname8!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey8, $p_projectpkey, $p_personnelname8, $p_personnelphone8);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey8);
			}
		} else {
			if ($p_personnelname8!="") $sa2 = $this->insertdata_personnel($p_personnelpkey8, $p_projectpkey, $p_personnelname8, $p_personnelphone8);
		}

		if ($p_personnelpkey9!="") { 
			if ($p_personnelname9!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey9, $p_projectpkey, $p_personnelname9, $p_personnelphone9);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey9);
			}
		} else {
			if ($p_personnelname9!="") $sa2 = $this->insertdata_personnel($p_personnelpkey9, $p_projectpkey, $p_personnelname9, $p_personnelphone9);
		}

		if ($p_personnelpkey10!="") { 
			if ($p_personnelname10!="") {
				$sa2 = $this->updatedata_personnel($p_personnelpkey10, $p_projectpkey, $p_personnelname10, $p_personnelphone10);
			} else {
				$sa2 = $this->deletedata_personnel($p_personnelpkey10);
			}
		} else {
			if ($p_personnelname10!="") $sa2 = $this->insertdata_personnel($p_personnelpkey10, $p_projectpkey, $p_personnelname10, $p_personnelphone10);
		}

		// return result..
		if ($sa==1) {
			return $p_projectpkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update/Override an existing project personnel
	> 
	******************************************************************************** */

	function updatedata_personnel($p_personnelpkey, $p_personnelprojectpkey, $p_personnelname, $p_personnelphone) {

		// convert params..

		// update data..
		$sa = $this->update_data("Project Personnel [Edit]", "project_personnel", "personnelprojectpkey = '".$p_personnelprojectpkey.
			"', personnelname = '".$p_personnelname.
			"', personnelphone = '".$p_personnelphone."'",
			"where personnelpkey = '".$p_personnelpkey."'");

		// return result..
		if ($sa==1) {
			return $p_personnelpkey;
		} else {
			return false;
		}
	}


	/* FUNCTIONS TO DELETE RECORDS */


	/* ********************************************************************************
	Delete an existing project (from PMS only) (can use on both CMS or manual project)
	******************************************************************************** */

	function deletedata_project($p_projectpkey) {

		// delete personnel then project..
		$sa = $this->delete_data("Project Personnel [Delete]", "project_personnel", "where personnelprojectpkey = '".$p_projectpkey."'");
		$sa = $this->delete_data("Project [Delete]", "project_details", "where projectpkey = '".$p_projectpkey."'");

		// return result..
		if ($sa==1) {
			return $p_projectpkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Delete an existing project personnel
	******************************************************************************** */

	function deletedata_personnel($p_personnelpkey) {

		// delete subject..
		$sa = $this->delete_data("Project Personnel [Delete]", "project_personnel", "where personnelpkey = '".$p_personnelpkey."'");

		// return result..
		if ($sa==1) {
			return $p_personnelpkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Delete an existing project user access
	******************************************************************************** */

	function deletedata_useraccess($p_user_pkey) {

		// delete subject..
		$sa = $this->delete_data("Project Access [Delete]", "project_useraccess", "where user_pkey = '".$p_user_pkey."'");

		// return result..
		if ($sa==1) {
			return $p_user_pkey;
		} else {
			return false;
		}
	}

}
?>
