<?
include_once('baseModelPMS.php');

class poModel extends baseModelPMS {


	/* QUERYING FUNCTIONS */


	/* ********************************************************************************
	Select list of pos by itq
	******************************************************************************** */

	function getlist_pobyitq($itqpkey, $sortby="po_no", $sortdir="ASC") {

		$listdata=array();

		$sql="Select PO.* from po_details PO where PO.po_itqpkey = '".$itqpkey."' order by PO.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of pos by mro
	******************************************************************************** */

	function getlist_pobymro($mropkey, $sortby="po_no", $sortdir="ASC") {

		$listdata=array();

		$sql="Select PO.* from po_details PO where PO.po_mropkey = '".$mropkey."' order by PO.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of pos by project
	******************************************************************************** */

	function getlist_pobyproject($projectpkey, $minstatus="", $maxstatus="", $pono="", $podate="", $vendorname="", $sortby="po_no", $sortdir="DESC") {

		$listdata=array();

		if ($podate!="") { $podate=converttounix($podate); }

		if ($minstatus=="") {
			$sql="Select PO.* from po_details PO where PO.po_projectpkey = '".$projectpkey."' and (PO.po_no like '%".$pono."%' and PO.po_date like '%".$podate."%' and PO.po_supplierpkey like '%".$vendorname."%') order by PO.".$sortby." ".$sortdir;
		} else {
			$sql="Select PO.* from po_details PO where PO.po_projectpkey = '".$projectpkey."' and (PO.po_no like '%".$pono."%' and PO.po_date like '%".$podate."%' and PO.po_supplierpkey like '%".$vendorname."%') and PO.po_status >= ".$minstatus." and PO.po_status <= ".$maxstatus." order by PO.".$sortby." ".$sortdir;
		}
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}
	
	// for serach
		function getlist_pobyproject_yusrul($projectpkey, $minstatus="", $maxstatus="", $pono="", $podate="", $vendorname="", $sortby="po_no", $sortdir="DESC") {

		$listdata=array();

		if ($podate!="") { $podate=converttounix($podate); }
		if ($minstatus=="") {
			$sql="Select PO.* from po_details PO where PO.po_projectpkey = '".$projectpkey."' and (PO.po_no like '%".$pono."%' and PO.po_date like '%".$podate."%' and PO.po_supplierpkey like '%".$vendorname."%') order by PO.".$sortby." ".$sortdir;
		} else {
			$sql="Select PO.* from po_details PO where PO.po_projectpkey = '".$projectpkey."' and (PO.po_no like '%".$pono."%' and PO.po_date like '%".$podate."%' and PO.po_supplierpkey like '%".$vendorname."%') and PO.po_status >= ".$minstatus." and PO.po_status <= ".$maxstatus." order by PO.".$sortby." ".$sortdir;
		}
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}

	/**
	yus po model new get list
	**/
	function getlist_pobyproject_y($projectpkey, $minstatus="", $maxstatus="", $pono="", $podate="", $vendorname="", $sortby="po_no", $sortdir="DESC") {

		$listdata=array();

		if ($podate!="") { $podate=converttounix($podate); }

		if ($minstatus=="") {
			$sql="Select PO.* from po_details PO where PO.po_projectpkey = '".$projectpkey."' and (PO.po_no like '%".$pono."%' and PO.po_date like '%".$podate."%' and PO.po_supplierpkey like '%".$vendorname."%') and po_cancel = '0' order by PO.".$sortby." ".$sortdir;
		} else {
			$sql="Select PO.* from po_details PO where PO.po_projectpkey = '".$projectpkey."' and (PO.po_no like '%".$pono."%' and PO.po_date like '%".$podate."%' and PO.po_supplierpkey like '%".$vendorname."%') and PO.po_status >= ".$minstatus." and PO.po_status <= ".$maxstatus." and po_cancel = '0' order by PO.".$sortby." ".$sortdir;
		}
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}

	/* ********************************************************************************
	Select list of po items
	******************************************************************************** */

	function getlist_poitems($popkey, $sortby="item_no", $sortdir="ASC") {

		$listdata=array();

		$sql="Select POI.* from po_items POI where POI.item_popkey = '".$popkey."' order by POI.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of po items by mro, supplier, subsub
	******************************************************************************** */

	function getlist_previouspoitems($mropkey, $supplierpkey, $subsubtradepkey) {

		$listdata=array();

		$sql="Select PO.*, POI.* from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_mropkey = '".$mropkey."' and PO.po_supplierpkey = '".$supplierpkey."' and POI.item_subsubtradepkey = '".$subsubtradepkey."'";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of po items by subtrade and/or subsub(?), date range
	(TODO: subtrade filter!!)
	******************************************************************************** */

	function getlist_poitems_mblreport($projectpkey, $subtradepkey, $subsubtradepkey, $datefrom, $dateto, $mropkey = '') {

		$listdata=array();

		if (($datefrom!="")&&($dateto!="")) {
			$sql="Select PO.*, POI.* from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_projectpkey = '".$projectpkey."' and POI.item_subsubtradepkey = '".$subsubtradepkey."' and PO.po_date >= '".$datefrom."' and PO.po_date <= '".$dateto."' ";
		} else {
			$sql="Select PO.*, POI.* from po_details PO 
			inner join po_items POI on PO.po_pkey=POI.item_popkey 
			where 
				PO.po_projectpkey = '".$projectpkey."' 
				and POI.item_subsubtradepkey = '".$subsubtradepkey."'";
		}
		
		// Kai: join Mro, filter out related items only, and filter out canceled items too
		if (!empty($mropkey))
		{
			$sql .=  " and PO.po_cancel = 0 and PO.po_mropkey = '".$mropkey."'";
		}
		
		$sql .= " order by POI.item_description, PO.po_no";
		
		//echo '<br /><br />'.$sql;
		
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}
	
	function getlist_poitems_mblreport_budgeted($projectpkey, $subtradepkey, $subsubtradepkey, $datefrom, $dateto, $mropkey = '') {

		$listdata=array();
		
		$sql="
		Select 
			PO.*, POI.* 
		from 
		po_details PO inner join po_items POI 
			on PO.po_pkey=POI.item_popkey 
		where 
			PO.po_projectpkey = '".$projectpkey."' 
			and POI.item_subsubtradepkey = '".$subsubtradepkey."'";
		
		if (($datefrom!="")&&($dateto!="")) {
			$sql .= " and PO.po_date >= '".$datefrom."' and PO.po_date <= '".$dateto."' ";
		}
		
		// Kai: join Mro, filter out related items only
		if (!empty($mropkey))
		{
			//$sql .=  " and PO.po_mropkey = '".$mropkey."'";
			$sql .=  " and PO.po_cancel = 0 and PO.po_mropkey = '".$mropkey."'";
		}
		
		//$sql .= " order by POI.item_description, PO.po_no";
		//echo '<br /><br />'.$sql;
		
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of po items by supplier, po no, subtrade, subsub, and date range
	(TODO: subtrade filter!!)
	******************************************************************************** */

	function getlist_poitems_poreport($projectpkey, $supplierpkey, $pono, $subtradepkey, $subsubtradepkey, $datefrom, $dateto) {

		$listdata=array();

		if (($datefrom!="")&&($dateto!="")) {
			$sql="Select PO.*, POI.* from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_projectpkey = '".$projectpkey."' and PO.po_supplierpkey like '".$supplierpkey."%' and PO.po_no like '%".$pono."' and POI.item_subsubtradepkey like '".$subsubtradepkey."%' and PO.po_date >= '".$datefrom."' and PO.po_date <= '".$dateto."' order by POI.item_no, PO.po_date";
		} else {
			$sql="Select PO.*, POI.* from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_projectpkey = '".$projectpkey."' and PO.po_supplierpkey like '".$supplierpkey."%' and PO.po_no like '%".$pono."' and POI.item_subsubtradepkey like '".$subsubtradepkey."%' order by POI.item_no, PO.po_date";
		}
		//echo $sql;exit;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}

/* ********************************************************************************
	Select list of po items by supplier, po no, subtrade, subsub, and date range
	(TODO: subtrade filter!!) -- arie add 23/06/2011
	******************************************************************************** */

	function getlist_poitems_poreport_arie($projectpkey, $supplierpkey, $pono, $subtradepkey, $subsubtradepkey, $datefrom, $dateto) {

		$listdata=array();

		if ($pono =="" and $subtradepkey == "")
		{
			if (($datefrom!="")&&($dateto!="")) {			
				$sql="Select PO.*, POI.* from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_projectpkey = '".$projectpkey."' and PO.po_supplierpkey like '".$supplierpkey."%' and PO.po_no like '%".$pono."' and POI.item_subsubtradepkey like '".$subsubtradepkey."%' and PO.po_date >= '".$datefrom."' and PO.po_date <= '".$dateto."' order by PO.po_no,POI.item_no, PO.po_date";
			} 		
			
			else
			 {
				$sql="Select PO.*, POI.* from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_projectpkey = '".$projectpkey."' and PO.po_supplierpkey like '".$supplierpkey."%' and PO.po_no like '%".$pono."' and POI.item_subsubtradepkey like '".$subsubtradepkey."%' order by PO.po_no,POI.item_no, PO.po_date";
			}
		}

		elseif ($subtradepkey != "")
		{
			//klu semua isi
			if (($datefrom!="")&&($dateto!="")&& ($pono !="")) {			
				$sql="select PO.*, POI.* from po_details PO,po_items POI,settings_trades setTrade where setTrade.tradeparentpkey =  '".$subtradepkey."'
				and POI.item_subsubtradepkey = setTrade.tradepkey 
				and PO.po_projectpkey =   '".$projectpkey."'
				and PO.po_pkey=POI.item_popkey
				and PO.po_supplierpkey like '".$supplierpkey."%'
				and PO.po_no = '".$pono."'
				and PO.po_date >= '".$datefrom."' and PO.po_date <= '".$dateto."'
				order by PO.po_no,POI.item_no, PO.po_date";	
				} 		
			//ada date tp po kosong
			elseif (($datefrom!="")&&($dateto!="")) {			
				$sql="select PO.*, POI.* from po_details PO,po_items POI,settings_trades setTrade where setTrade.tradeparentpkey =  '".$subtradepkey."'
				and POI.item_subsubtradepkey = setTrade.tradepkey 
				and PO.po_projectpkey =   '".$projectpkey."'
				and PO.po_pkey=POI.item_popkey
				and PO.po_supplierpkey like '".$supplierpkey."%'				
				and PO.po_date >= '".$datefrom."' and PO.po_date <= '".$dateto."'
				order by PO.po_no,POI.item_no, PO.po_date";	
				} 
			//ada po tp date sosong
			elseif (($datefrom!="")&&($dateto!="")) {			
				$sql="select PO.*, POI.* from po_details PO,po_items POI,settings_trades setTrade where setTrade.tradeparentpkey =  '".$subtradepkey."'
				and POI.item_subsubtradepkey = setTrade.tradepkey 
				and PO.po_projectpkey =   '".$projectpkey."'
				and PO.po_pkey=POI.item_popkey
				and PO.po_supplierpkey like '".$supplierpkey."%'				
				and PO.po_no = '".$pono."'
				order by PO.po_no,POI.item_no, PO.po_date";	
				} 		
			else
			 {
				$sql="select PO.*, POI.* from po_details PO,po_items POI,settings_trades setTrade where setTrade.tradeparentpkey =  '".$subtradepkey."'
						and POI.item_subsubtradepkey = setTrade.tradepkey 
						and PO.po_projectpkey =   '".$projectpkey."'
						and PO.po_pkey=POI.item_popkey
						and PO.po_supplierpkey like '".$supplierpkey."%'
						order by PO.po_no,POI.item_no, PO.po_date";
			}
		}

		else
		{
			if (($datefrom!="")&&($dateto!="")) {			
				$sql="Select PO.*, POI.* from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_projectpkey = '".$projectpkey."' and PO.po_supplierpkey like '".$supplierpkey."%' and PO.po_no = '".$pono."' and POI.item_subsubtradepkey like '".$subsubtradepkey."%' and PO.po_date >= '".$datefrom."' and PO.po_date <= '".$dateto."' order by PO.po_no,POI.item_no, PO.po_date";
			} 		
			
			else
			 {
				$sql="Select PO.*, POI.* from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_projectpkey = '".$projectpkey."' and PO.po_supplierpkey like '".$supplierpkey."%' and PO.po_no = '".$pono."' and POI.item_subsubtradepkey like '".$subsubtradepkey."%' order by PO.po_no,POI.item_no, PO.po_date";
			}
		}
		//print $sql;exit;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}

	/* *******************
	
	yus po filter cancel 
	
	********************* */
	function getlist_poitems_poreport_yus($projectpkey, $supplierpkey, $pono, $subtradepkey, $subsubtradepkey, $datefrom, $dateto) {

		$listdata=array();

		if ($pono =="" and $subtradepkey == "")
		{
			if (($datefrom!="")&&($dateto!="")) {			
				$sql="Select PO.*, POI.* from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_projectpkey = '".$projectpkey."' and PO.po_supplierpkey like '".$supplierpkey."%' and PO.po_no like '%".$pono."' and POI.item_subsubtradepkey like '".$subsubtradepkey."%' and PO.po_date >= '".$datefrom."' and PO.po_date <= '".$dateto."' and PO.po_cancel != 1 order by PO.po_no,POI.item_no, PO.po_date";
			} 		
			
			else
			 {
				$sql="Select PO.*, POI.* from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_projectpkey = '".$projectpkey."' and PO.po_supplierpkey like '".$supplierpkey."%' and PO.po_no like '%".$pono."' and POI.item_subsubtradepkey like '".$subsubtradepkey."%' and PO.po_cancel != 1 order by PO.po_no,POI.item_no, PO.po_date";
			}
		}

		elseif ($subtradepkey != "")
		{
			//klu semua isi
			if (($datefrom!="")&&($dateto!="")&& ($pono !="")) {			
				$sql="select PO.*, POI.* from po_details PO,po_items POI,settings_trades setTrade where setTrade.tradeparentpkey =  '".$subtradepkey."'
				and POI.item_subsubtradepkey = setTrade.tradepkey 
				and PO.po_projectpkey =   '".$projectpkey."'
				and PO.po_pkey=POI.item_popkey
				and PO.po_supplierpkey like '".$supplierpkey."%'
				and PO.po_no = '".$pono."'
				and PO.po_date >= '".$datefrom."' and PO.po_date <= '".$dateto."'
				and PO.po_cancel != 1
				order by PO.po_no,POI.item_no, PO.po_date";	
				} 		
			//ada date tp po kosong
			elseif (($datefrom!="")&&($dateto!="")) {			
				$sql="select PO.*, POI.* from po_details PO,po_items POI,settings_trades setTrade where setTrade.tradeparentpkey =  '".$subtradepkey."'
				and POI.item_subsubtradepkey = setTrade.tradepkey 
				and PO.po_projectpkey =   '".$projectpkey."'
				and PO.po_pkey=POI.item_popkey
				and PO.po_supplierpkey like '".$supplierpkey."%'				
				and PO.po_date >= '".$datefrom."' and PO.po_date <= '".$dateto."'
				and PO.po_cancel != 1
				order by PO.po_no,POI.item_no, PO.po_date";	
				} 
			//ada po tp date sosong
			elseif (($datefrom!="")&&($dateto!="")) {			
				$sql="select PO.*, POI.* from po_details PO,po_items POI,settings_trades setTrade where setTrade.tradeparentpkey =  '".$subtradepkey."'
				and POI.item_subsubtradepkey = setTrade.tradepkey 
				and PO.po_projectpkey =   '".$projectpkey."'
				and PO.po_pkey=POI.item_popkey
				and PO.po_supplierpkey like '".$supplierpkey."%'				
				and PO.po_no = '".$pono."'
				and PO.po_cancel != 1
				order by PO.po_no,POI.item_no, PO.po_date";	
				} 		
			else
			 {
				$sql="select PO.*, POI.* from po_details PO,po_items POI,settings_trades setTrade where setTrade.tradeparentpkey =  '".$subtradepkey."'
						and POI.item_subsubtradepkey = setTrade.tradepkey 
						and PO.po_projectpkey =   '".$projectpkey."'
						and PO.po_pkey=POI.item_popkey
						and PO.po_supplierpkey like '".$supplierpkey."%'
						and PO.po_cancel != 1
						order by PO.po_no,POI.item_no, PO.po_date";
			}
		}

		else
		{
			if (($datefrom!="")&&($dateto!="")) {			
				$sql="Select PO.*, POI.* from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_projectpkey = '".$projectpkey."' and PO.po_supplierpkey like '".$supplierpkey."%' and PO.po_no = '".$pono."' and POI.item_subsubtradepkey like '".$subsubtradepkey."%' and PO.po_date >= '".$datefrom."' and PO.po_date <= '".$dateto."' and PO.po_cancel != 1 order by PO.po_no,POI.item_no, PO.po_date";
			} 		
			
			else
			 {
				$sql="Select PO.*, POI.* from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_projectpkey = '".$projectpkey."' and PO.po_supplierpkey like '".$supplierpkey."%' and PO.po_no = '".$pono."' and POI.item_subsubtradepkey like '".$subsubtradepkey."%' and PO.po_cancel != 1 order by PO.po_no,POI.item_no, PO.po_date";
			}
		}
		//print $sql;exit;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}
	
	
	
	/* ********************************************************************************
	Select list of po items by supplier and date range
	******************************************************************************** */

	function getlist_poitems_spsreport($projectpkey, $supplierpkey, $datefrom, $dateto) {

		$listdata=array();

		if (($datefrom!="")&&($dateto!="")) {
			$sql="Select PO.*, POI.*, MRO.mro_deliverydate from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey inner join mro_details MRO on PO.po_mropkey=MRO.mro_pkey where PO.po_projectpkey = '".$projectpkey."' and PO.po_supplierpkey like '".$supplierpkey."%' and PO.po_date >= '".$datefrom."' and PO.po_date <= '".$dateto."' order by PO.po_no";	// POI.item_description, PO.po_date";
		} else {
			$sql="Select PO.*, POI.*, MRO.mro_deliverydate from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey inner join mro_details MRO on PO.po_mropkey=MRO.mro_pkey where PO.po_projectpkey = '".$projectpkey."' and PO.po_supplierpkey like '".$supplierpkey."%' order by PO.po_no";	//POI.item_description, PO.po_date";
		}
		//echo $sql;
		//exit;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of po items by po no and/or date range
	******************************************************************************** */

	function getlist_poitems_pmcreport($projectpkey, $pono, $datefrom, $dateto) {

		$listdata=array();

		if (($datefrom!="")&&($dateto!="")) {
			$sql="Select PO.*, POI.* from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_projectpkey = '".$projectpkey."' and PO.po_no like '%".$pono."' and PO.po_date >= '".$datefrom."' and PO.po_date <= '".$dateto."' order by POI.item_description, PO.po_date";
		} else {
			$sql="Select PO.*, POI.* from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_projectpkey = '".$projectpkey."' and PO.po_no like '%".$pono."' order by POI.item_description, PO.po_date";
		}
		//echo $sql;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of pos by subcon and date range
	subcon amik dr mana? link kt mro subcon la ni kan?
	pastu xleh nak sort by supplier pasal lain2 database :(
	******************************************************************************** */

	function getlist_po_scmreport($projectpkey, $subconpkey, $datefrom, $dateto) {

		$listdata=array();

		if (($datefrom!="")&&($dateto!="")) {
			$sql="Select PO.* from po_details PO inner join mro_details MRO on PO.po_mropkey=MRO.mro_pkey where PO.po_projectpkey = '".$projectpkey."' and MRO.mro_subcons like '%".$subconpkey."%' and PO.po_date >= '".$datefrom."' and PO.po_date <= '".$dateto."' order by PO.po_no";
		} else {
			$sql="Select PO.* from po_details PO inner join mro_details MRO on PO.po_mropkey=MRO.mro_pkey where PO.po_projectpkey = '".$projectpkey."' and MRO.mro_subcons like '%".$subconpkey."%' order by PO.po_no";
		}
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}
	
	# myapit - for report sub con
	function getlist_po_scmreport2($projectpkey, $subconpkey, $datefrom, $dateto) {

		$listdata=array();
    if($subconpkey != ''){
     $subcon_ext = " and MRO.mro_subcons like '%".$subconpkey."%' ";
    }else{
       $subcon_ext = "";
    }
    
		if (($datefrom!="")&&($dateto!="")) {
			$sql="Select PO.* from po_details PO inner join mro_details MRO on PO.po_mropkey=MRO.mro_pkey where PO.po_projectpkey = '".$projectpkey."' ". $subcon_ext ." and PO.po_date >= '".$datefrom."' and PO.po_date <= '".$dateto."' order by PO.po_no";
		} else {
			$sql="Select PO.* from po_details PO inner join mro_details MRO on PO.po_mropkey=MRO.mro_pkey where PO.po_projectpkey = '".$projectpkey."'  ". $subcon_ext ." order by PO.po_no";
		}
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select total quantity of po items by mro, supplier, subsub
	******************************************************************************** */

	function getquantity_previouspoitems($mropkey, $supplierpkey, $subsubtradepkey) {

		$data=array();

		$sql="Select POI.item_quantity from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_mropkey = '".$mropkey."' and PO.po_supplierpkey = '".$supplierpkey."' and POI.item_subsubtradepkey = '".$subsubtradepkey."'";
		$data=$this->getextendedrow($sql);
		return $data['item_quantity'];
	}


	/* ********************************************************************************
	Select total quantity of po items (all items)
	******************************************************************************** */

	function getquantity_poitems($popkey) {

		$data=array();

		$sql="Select sum(POI.item_quantity) as po_quantity from po_items POI where POI.item_popkey = '".$popkey."'";
		$data=$this->getextendedrow($sql);
		return $data['po_quantity'];
	}


	/* ********************************************************************************
	Select total amount of po items by item
	******************************************************************************** */

	function getamount_poitems($popkey) {

		$listdata=array();
		$poamount = 0;

		$sql="Select POI.item_quantity, POI.item_rate from po_items POI where POI.item_popkey = '".$popkey."'";
		$listdata=$this->getextendedrows($sql);
		foreach ($listdata as $mydata) {
			$poamount += ($mydata['item_quantity'] * $mydata['item_rate']);
		}
		return $poamount;
	}


	/* ********************************************************************************
	Select a particular po
	******************************************************************************** */

	function getdata_po($popkey){

		$data=array();

		$sql="Select PO.* from po_details PO where PO.po_pkey='".$popkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select a particular po item
	******************************************************************************** */

	function getdata_poitem($itempkey){

		$data=array();

		$sql="Select POI.* from po_items POI where POI.item_pkey='".$itempkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select total max quantity of items ordered by subsubtrade
	******************************************************************************** */

	function getmaximum_poitemsbysubsubtrade($projectpkey, $subsubtradepkey) {

		$data=array();

		$sql="Select sum(POI.item_quantity) as max_quantity from po_items POI inner join po_details PO on POI.item_popkey=PO.po_pkey where PO.po_projectpkey = '".$projectpkey."' and POI.item_subsubtradepkey = '".$subsubtradepkey."'";
		$data=$this->getextendedrow($sql);
		return $data['max_quantity'];
	}


	/* ********************************************************************************
	Select total quantity of items ordered by subsubtrade (approved po only)
	******************************************************************************** */

	function getquantity_poitemsbysubsubtrade($projectpkey, $subsubtradepkey, $postatus="3") {

		$data=array();

		$sql="Select sum(POI.item_quantity) as po_quantity from po_items POI inner join po_details PO on POI.item_popkey=PO.po_pkey where PO.po_projectpkey = '".$projectpkey."' and POI.item_subsubtradepkey = '".$subsubtradepkey."' and PO.po_status=".$postatus;
		$data=$this->getextendedrow($sql);
		if ($data['po_quantity']==null) {
			return 0;
		} else {
			return $data['po_quantity'];
		}
	}

        /* ********************************************************************************
	arie add 06/06/2011 -- Select total quantity of items ordered by subsubtrade (approved po only)
	******************************************************************************** */

	function getquantity_poitemsbysubsubtrade_arie($projectpkey, $subsubtradepkey, $postatus="3") {

		$data=array();

		$sql="Select sum(POI.item_quantity) as po_quantity from po_items POI inner join po_details PO on POI.item_popkey=PO.po_pkey where PO.po_projectpkey = '".$projectpkey."' and POI.item_subsubtradepkey = '".$subsubtradepkey."' and POI.item_quantity<>0";

		$data=$this->getextendedrow($sql);
		if ($data['po_quantity']==null) {
			return 0;
		} else {
			return $data['po_quantity'];
		}
	}

	/* ********************************************************************************
	Get list of POs and associated item's quantities by item subsubtrade
	******************************************************************************** */

	function getlist_posets($projectpkey, $subsubtradepkey) {

		$listdata=array();

		$sql="Select PO.*, POI.* from po_details PO inner join po_items POI on PO.po_pkey=POI.item_popkey where PO.po_projectpkey='".$projectpkey."' and POI.item_subsubtradepkey='".$subsubtradepkey."' order by PO.po_date ASC";
		$listdata=$this->getextendedrows($sql);
		return $listdata;

	}


	/* ********************************************************************************
	Returns po data if a particular PO exists
	******************************************************************************** */

	function getstatus_poexists($projectpkey, $mropkey, $itqpkey, $supplierpkey){

		$data=array();

		$sql="Select PO.* from po_details PO where PO.po_projectpkey='".$projectpkey."' and PO.po_mropkey='".$mropkey."' and PO.po_itqpkey='".$itqpkey."' and PO.po_supplierpkey='".$supplierpkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Returns po pkey if a particular PO exists (by itq and supplier)
	******************************************************************************** */

	function getdata_popkeybysupplier($itqpkey, $supplierpkey){

		$data=array();

		$sql="Select PO.po_pkey from po_details PO where PO.po_itqpkey='".$itqpkey."' and PO.po_supplierpkey='".$supplierpkey."'";
		$data=$this->getextendedrow($sql);
		return $data['po_pkey'];
	}


	/* ********************************************************************************
	Returns po pkey if a particular PO was already issued (by itq and supplier)
	(cancel status!=1 only, i.e. accepted po or cancelled item only, not cancelled PO)
	******************************************************************************** */

	function getdata_popkeyissued($itqpkey, $supplierpkey){

		$data=array();

		//$sql="Select PO.po_pkey from po_details PO where PO.po_itqpkey='".$itqpkey."' and PO.po_supplierpkey='".$supplierpkey."' and //PO.po_cancel<>1";
		// tambahan 20-01-2012
		$sql="Select PO.po_pkey from po_details PO where PO.po_itqpkey='".$itqpkey."' and PO.po_cancel<>1";
		$data=$this->getextendedrow($sql);
		return $data['po_pkey'];
	}


	/* ********************************************************************************
	Get last po id
	******************************************************************************** */

	function getdata_lastpoid(){

		$data=array();

		$sql="Select max(PO.po_no) as lastid from po_details PO where PO.po_cancel=0";
		$data=$this->getextendedrow($sql);
		return $data['lastid'];
	}


	/* ********************************************************************************
	Get last po rev no
	******************************************************************************** */

	function getdata_revno($popkey){

		$data=array();

		$sql="Select PO.po_revno as revno from po_details PO where PO.po_pkey='".$popkey."'";	// PO.po_cancel=0";
		$data=$this->getextendedrow($sql);
		return $data['revno'];
	}


	/* FUNCTIONS TO INSERT RECORDS */


	/* ********************************************************************************
	Insert/Create a new po
	Auto-insert PO items based on ITQ (BUT only items not in previous POs!!)
	******************************************************************************** */

	function insertdata_po($p_po_pkey, $p_po_projectpkey, $p_po_mropkey, $p_po_itqpkey, $p_po_supplierpkey, $p_po_no, $p_po_date, $p_po_top, $p_po_attn, $p_po_literaltotal, $p_po_co, $p_po_personnelpkey, $p_po_contactperson, $p_po_contactnumber, $p_po_requestor, $p_po_approver) {

		// clean/convert/add params..
		$p_po_date=converttounix($p_po_date);

		// check if po for the itq and supplier was already issued but item rejected..
		$popkey = $this->getdata_popkeyissued($p_po_itqpkey, $p_po_supplierpkey);

		if ($popkey!="") {

			// in this version po revno is already up during rejection :P
			// NO!! we up the rev no here coz during reject we dunno which other pos to increment
			// here, whenever an existing supplier is re-awarded items, we increment the rev no

			$myrev = $this->getdata_revno($popkey);
			$myrev++;

			// update..
			$sa = $this->update_data("PO [Edit]", "po_details", "po_revno = ".$myrev.
				", po_date = '".$p_po_date.
				"', po_top = ".$p_po_top.
				", po_attn = '".$p_po_attn.
				"', po_literaltotal = '".$p_po_literaltotal.
				"', po_co = '".$p_po_co.
				"', po_personnelpkey = '".$p_po_personnelpkey.
				"', po_contactperson = '".$p_po_contactperson.
				"', po_contactnumber = '".$p_po_contactnumber.
				"', po_requestor = '".$p_po_requestor.
				"', po_approver = '".$p_po_approver.
				"', po_status = "."1".
				", po_supplierpkey = '".$p_po_supplierpkey. // tambahan 20-01-2012
				"', po_cancel = "."0",
				"where po_pkey = '".$popkey."'");

			// also we need to delete old items under this po before inserting new ones below..
			$sa2 = $this->delete_data("PO Item [Delete]", "po_items", "where item_popkey = '".$popkey."'");

			$new_po_pkey = $popkey;

		} else {

			// update..
			$new_po_pkey=md5(microtime());

			$lastid=$this->getdata_lastpoid();
			$lastid++;

			$sa = $this->add_data("PO [Add]", "po_details", "po_pkey, po_projectpkey, po_mropkey, po_itqpkey, po_supplierpkey, po_no, po_date, po_top, po_attn, po_literaltotal, po_co, po_personnelpkey, po_contactperson, po_contactnumber, po_requestor, po_approver, po_status",
				"'".$new_po_pkey."','".$p_po_projectpkey."','".$p_po_mropkey.
				"','".$p_po_itqpkey."','".$p_po_supplierpkey."',".$lastid.
				",'".$p_po_date."',".$p_po_top.",'".$p_po_attn.
				"','".$p_po_literaltotal."','".$p_po_co."','".$p_po_personnelpkey.
				"','".$p_po_contactperson."','".$p_po_contacnumber.
				"','".$p_po_requestor.
				"','".$p_po_approver."',1");

		}

		// add po (mro) items..

		include_once('mroModel.php');
		include_once('itqModel.php');
		$mymroModel=new mroModel;
		$myitqModel=new itqModel;

		//$approval_data = $myitqModel->getlist_itqevaluationbyapproval($p_po_itqpkey, $p_po_supplierpkey);

		$ncount=0;
		$mro_items = $mymroModel->getlist_mroitems($p_po_mropkey);
		foreach ($mro_items as $mymro) {
			// proceed only if quotation accepted
			$approval_data = $myitqModel->getdata_lastapprovalbysupplier($p_po_itqpkey,$mymro['item_pkey'],$p_po_supplierpkey);
			if ($approval_data['approval_pkey']!="") {
				if ($approval_data['approval_quantity']>0) {
					$ncount++;
					// check prev po and get totals already poed to this supplier
					//$prevquantity = $this->getquantity_previouspoitems($p_po_mropkey, $p_po_supplierpkey, $mymro['item_subsubtradepkey']);
					//$newquantity = $mymro['item_quantity']-$prevquantity;
					// get supplier rate
					$supplierrate = $myitqModel->getdata_itemratebysupplier($mymro['item_pkey'], $p_po_supplierpkey);
					// insert
					//$sa2 = $this->insertdata_poitem("", $new_po_pkey, "".$ncount."", $mymro['item_subsubtradepkey'], $mymro['item_code'], $mymro['item_description'], $mymro['item_unit'], "".$newquantity."", $supplierrate, $mymro['item_remarks']);
					$sa2 = $this->insertdata_poitem("", $new_po_pkey, "".$ncount."", $mymro['item_subsubtradepkey'], $mymro['item_code'], $mymro['item_description'], $mymro['item_unit'], "".$approval_data['approval_quantity']."", $supplierrate, $mymro['item_remarks']);
				}
			}
			reset($approval_data);
		}

		// return result..
		if ($sa==1) {
			return $new_po_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Insert/Create a new po approval (cumulative)
	Type: 1 = Submission, 2 = Recommendation, 3 = Approval
	Status: 0 = Unprocessed/Unknown, 1 = Recommended/Approved, 2 = Cancelled, 3 = Rejected
	NOTE: At the same, must update status field in table po_details!
	******************************************************************************** */

	function insertdata_approval($p_approval_pkey, $p_approval_popkey, $p_approval_type, $p_approval_userpkey, $p_approval_officername, $p_approval_date, $p_approval_status, $p_approval_remarks) {

		// clean/convert/add params..
		$p_approval_date=converttounixfull($p_approval_date);	// use convertfull coz timestamp;
		//$p_approval_date=gettimestamp();

		$p_po_approved="0";
		$p_po_cancel="0";
		if ($p_approval_status=="1") $p_po_approved = $p_approval_type;

		// update..
		$new_approval_pkey=md5(microtime());

		$sa = $this->add_data("PO -> Approval [Add]", "po_approvals", "approval_pkey, approval_popkey, approval_type, approval_userpkey, approval_officername, approval_date, approval_status, approval_remarks",
			"'".$new_approval_pkey."','".$p_approval_popkey."',".$p_approval_type.
			",'".$p_approval_userpkey."','".$p_approval_officername."','".$p_approval_date.
			"',".$p_approval_status.",'".$p_approval_remarks."'");

		if ($p_po_approved=="3") {

			// if approval (3) and approved, update po with status and approver info 
			// (and request date) - also set cancel to 0 (in case rejected earlier)..

			$myusername = $_SESSION['Xstaffname'];

			$sa2 = $this->update_data("PO [Edit]", "po_details", "po_status=".$p_po_approved.
				", po_cancel=0".
				", po_approver='".$myusername."'",
				"where po_pkey='".$p_approval_popkey."'");
		} else {

			if ($p_approval_status=="1") {

				// if submission or recommendation (accepted), update po status..

				$sa2 = $this->update_data("PO [Edit]", "po_details", "po_status=".$p_po_approved,
					"where po_pkey='".$p_approval_popkey."'");

			} else if ($p_approval_status=="2") {

				// if cancelled, update cancel status but not po status (cannot do anything)..

				$sa2 = $this->update_data("PO [Edit]", "po_details", "po_cancel=1",
					"where po_pkey='".$p_approval_popkey."'");
				
				//yusr
				// seek for mro_pkey
				$sqly1 = mysql_query("select po_mropkey from po_details where po_pkey='$p_approval_popkey'");
				$datay1 = mysql_fetch_assoc($sqly1);
				$y_mro_key = $datay1['po_mropkey'];
				// insert cancel to mro
			    $sqly2 = mysql_query("update mro_details set mro_cancel = '1' where mro_pkey='$y_mro_key'");
				//insert value 0 to mro_items
				$sqly3 = mysql_query("update mro_items set item_quantity = '0' where item_mropkey='$y_mro_key'");
				// insert cancel to itq
				$sqly4 = mysql_query("update itq_details set itq_cancel = '1' where itq_mropkey='$y_mro_key'");

			} else if ($p_approval_status=="3") { // reject item akan cancel item on PO

				// if rejected, update cancel status and set po status to 0 (new)..
				// and increment rev no
				// NO!! for po we increment only during creation!! because we deal with >1 po

				//$myrev = $this->getdata_revno($p_approval_popkey);
				//$myrev++;

				//$sa2 = $this->update_data("PO [Edit]", "po_details", "po_cancel=2".
				//	", po_revno=".$myrev.
				//	", po_status=0",
				//	"where po_pkey='".$p_approval_popkey."'");

				$sa2 = $this->update_data("PO [Edit]", "po_details", "po_cancel=2".
					", po_status=1",
					"where po_pkey='".$p_approval_popkey."'");
				// show reject on itq : yusrs quick edit 13-7-2011
				$sa3 = mysql_query("select * from po_details where po_pkey='".$p_approval_popkey."'");
				$sa3data = mysql_fetch_assoc($sa3);
				$sa3_po_mropkey = $sa3data['po_mropkey'];
				$sa3_po_itqpkey = $sa3data['po_itqpkey'];
				$sa3_po_popkey = $sa3data['po_pkey'];
				
				$sa4 = mysql_query("update itq_details set itq_cancel='2' where itq_mropkey='".$sa3_po_mropkey."'");
				
				$sa5 = mysql_query("update mro_details set mro_status='4' where mro_pkey = '".$sa3_po_mropkey."'");
				
				// delete all in itq_approvals
				//$sa2 = $this->delete_data("PO Item [Delete]", "po_items", "where item_popkey = '".$popkey."'");
                $del_a = mysql_query("DELETE from itq_approvals where approval_itqpkey ='$sa3_po_itqpkey'");
				// 20-01-2012
				$del_b = mysql_query("DELETE from itq_evaluation where eval_itqpkey ='$sa3_po_itqpkey'");
				$del_c = mysql_query("DELETE from itq_suppliers where itq_pkey ='$sa3_po_itqpkey'");
				// 20-01-2012 
				$del_d = mysql_query("DELETE from po_approvals where approval_popkey ='$sa3_po_popkey'");
				$del_e = mysql_query("DELETE from po_items where item_popkey ='$sa3_po_popkey'");
			}

			// either cancelled or rejected, we have to do stuff on the rfq..


			if (($p_approval_status=="2")||($p_approval_status=="3")) {

				include_once('itqModel.php');
				$myitqModel=new itqModel;

				$mypo = $this->getdata_po($p_approval_popkey);

				$myrev = $myitqModel->getdata_revno($mypo['po_itqpkey']);
				$myrev++;

				// po cancellation acts like rfq rejection.. hmm..
                //yusr
				//$sa3 = $myitqModel->update_data("ITQ [Edit]", "itq_details", "itq_cancel=1".
				//	", itq_revno=".$myrev.
				//	", itq_evalstatus=0",
				//	"where itq_pkey='".$mypo['po_itqpkey']."'");

			}

		}

		// return result..
		if ($sa==1) {
			return $new_approval_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Insert/Create a new po item
	******************************************************************************** */

	function insertdata_poitem($p_item_pkey, $p_item_popkey, $p_item_no, $p_item_subsubtradepkey, $p_item_code, $p_item_description, $p_item_unit, $p_item_quantity, $p_item_rate, $p_item_remarks) {

		// clean/convert/add params..
		$p_item_quantity=str_replace(",","",$p_item_quantity);
		$p_item_rate=str_replace(",","",$p_item_rate);

		// update..
		$new_item_pkey=md5(microtime());

		$sa = $this->add_data("PO Item [Add]", "po_items", "item_pkey, item_popkey, item_no, item_subsubtradepkey, item_code, item_description, item_unit, item_quantity, item_rate, item_remarks",
			"'".$new_item_pkey."','".$p_item_popkey."',".$p_item_no.
			",'".$p_item_subsubtradepkey."','".$p_item_code."','".$p_item_description.
			"','".$p_item_unit."',".$p_item_quantity.",".$p_item_rate.
			",'".$p_item_remarks."'");

		// return result..
		if ($sa==1) {
			return $new_item_pkey;
		} else {
			return false;
		}
	}


	/* FUNCTIONS TO UPDATE RECORDS */


	/* ********************************************************************************
	Update/Override a po
	> Only the editable items :P (to check about requestor)
	******************************************************************************** */

	function updatedata_po($p_po_pkey, $p_po_projectpkey, $p_po_mropkey, $p_po_itqpkey, $p_po_supplierpkey, $p_po_no, $p_po_date, $p_po_top, $p_po_attn, $p_po_literaltotal, $p_po_co, $p_po_personnelpkey, $p_po_contactperson, $p_po_contactnumber, $p_po_requestor, $p_po_approver) {

		// clean/convert/add params..
		$p_po_date=converttounix($p_po_date);

		// update..
		$sa = $this->update_data("PO [Edit]", "po_details", "po_date = '".$p_po_date.
			"', po_top = ".$p_po_top.
			", po_attn = '".$p_po_attn.
			"', po_literaltotal = '".$p_po_literaltotal.
			"', po_co = '".$p_po_co.
			"', po_personnelpkey = '".$p_po_personnelpkey.
			"', po_contactperson = '".$p_po_contactperson.
			"', po_contactnumber = '".$p_po_contactnumber."'",
			"where po_pkey = '".$p_po_pkey."'");

		// return result..
		if ($sa==1) {
			return $p_po_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update/Override po status
	******************************************************************************** */

	function updatestatus_po($p_po_pkey, $p_po_status) {

		// clean/convert/add params..

		// update..
		$sa = $this->update_data("PO [Edit]", "po_details", "po_status = ".$p_po_status,
			"where po_pkey = '".$p_po_pkey."'");
        //count do_items yusr
		
		$y0207a = mysql_query("select po_mropkey from po_details where po_pkey='$p_po_pkey'");
		$y7data = mysql_fetch_assoc($y0207a);
		$dydy = $y7data['po_mropkey'];
		
		// reset all item  
		$resetysa2 =  mysql_query("update po_items set item_quantity='0' where item_popkey='$p_po_pkey'");
		$resetyq1 = mysql_query("update mro_items set item_quantity='0' where item_mropkey ='$dydy'");
		 
		 
		$ysa1 = mysql_query("select SUM(item_quantity),item_subsubtradepkey, item_quantity from do_items where item_popkey ='".$p_po_pkey."' GROUP BY item_subsubtradepkey");
		while($data1 = mysql_fetch_array($ysa1)){
		$Yitem_quantity = $data1['SUM(item_quantity)'];
		$itemhoho  = $data['item_quantity'];
		$Ygroup = $data1['item_subsubtradepkey'];
		
		//insert into po_items yusr(should put into loop
		$ysa2 =  mysql_query("update po_items set item_quantity='".$Yitem_quantity."' where item_popkey='$p_po_pkey' AND item_subsubtradepkey='$Ygroup'");
		//insert into mro
		 $yq1 = mysql_query("update mro_items set item_quantity='$Yitem_quantity' where item_mropkey ='$dydy' AND item_subsubtradepkey='$Ygroup'");
		}
		
		// return result..
		if ($sa==1) {
			return $p_po_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Cancel po (either 1 item or all items for 1 supplier or all suppliers)
	(Does it really matter? Hmm..)
	******************************************************************************** */

	function cancel_po($p_po_pkey) {

		// clean/convert/add params..

		// update..
		// we set cancel to 1 (cancelled, i.e. id unusable), but we might actually
		// use the id again later during next rfq round IF same supplier is invited
		// again!

		$sa = $this->update_data("PO [Edit]", "po_details", "po_cancel = 1",
			"where po_pkey = '".$p_po_pkey."'");

		// do all kinds of stuff on rfq!

		include_once('itqModel.php');
		$myitqModel=new itqModel;

		$mypo = $this->getdata_po($p_po_pkey);

		$myrev = $myitqModel->getdata_revno($mypo['po_itqpkey']);
		$myrev++;

		// po cancellation acts like rfq rejection.. hmm..

		$sa2 = $myitqModel->update_data("ITQ [Edit]", "itq_details", "itq_cancel=2".
			", itq_revno=".$myrev.
			", itq_evalstatus=0",
			"where itq_pkey='".$mypo['po_itqpkey']."'");

		// return result..
		if ($sa==1) {
			return $p_po_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Reject po
	Note: PO has no rejection since PO does not require approval, so..
	BUT also, rejection of po is handled by cancel_po above, since rejection is really
	cancellation. Ouch, my brain!!
	******************************************************************************** */

	function reject_po($p_po_pkey) {

		// clean/convert/add params..

		// update..
		$sa = $this->update_data("PO [Edit]", "po_details", "po_cancel = 2",
			"where po_pkey = '".$p_po_pkey."'");
			
        //$sa2 = $this->delete_data("PO Item [Delete]", "po_items", "where item_popkey = '".$popkey."'");
		// return result..
		if ($sa==1) {
			return $p_po_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update/Override an existing po item
	******************************************************************************** */

	function updatedata_poitem($p_item_pkey, $p_item_popkey, $p_item_no, $p_item_subsubtradepkey, $p_item_code, $p_item_description, $p_item_unit, $p_item_quantity, $p_item_rate, $p_item_remarks) {

		// clean/convert/add params..
		$p_item_quantity=str_replace(",","",$p_item_quantity);
		$p_item_rate=str_replace(",","",$p_item_rate);

		// update..
		$sa = $this->update_data("PO Item [Edit]", "po_items", "item_popkey = '".$p_item_popkey.
			"', item_no = ".$p_item_no.
			", item_subsubtradepkey = '".$p_item_subsubtradepkey.
			"', item_code = '".$p_item_code.
			"', item_description = '".$p_item_description.
			"', item_unit = '".$p_item_unit.
			"', item_quantity = ".$p_item_quantity.
			", item_rate = ".$p_item_rate.
			", item_remarks = '".$p_item_remarks."'",
			"where item_pkey = '".$p_item_pkey."'");

		// return result..
		if ($sa==1) {
			return $p_item_pkey;
		} else {
			return false;
		}
	}


	/* FUNCTIONS TO DELETE RECORDS */


	/* ********************************************************************************
	Delete an existing po
	******************************************************************************** */

	function deletedata_po($p_po_pkey) {

		// delete subject..
		$sa = $this->delete_data("PO Item [Delete]", "po_items", "where item_popkey = '".$p_po_pkey."'");
		$sa = $this->delete_data("PO [Delete]", "po_details", "where po_pkey = '".$p_po_pkey."'");

		// return result..
		if ($sa==1) {
			return $p_po_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Delete an existing po item
	******************************************************************************** */

	function deletedata_poitem($p_item_pkey, $p_item_popkey) {

		// delete subject..
		$sa = $this->delete_data("PO Item [Delete]", "po_items", "where item_pkey = '".$p_item_pkey."' and item_popkey = '".$p_item_popkey."'");

		// return result..
		if ($sa==1) {
			return $p_item_pkey;
		} else {
			return false;
		}
	}
}
?>