<?
include_once('baseModelPMS.php');

class itqModel extends baseModelPMS {


	/* QUERYING FUNCTIONS */


	/* ********************************************************************************
	Select list of itqs
	Note: exclude cancelled MROs?
	******************************************************************************** */

	function getlist_itq($mropkey, $sortby="itq_date", $sortdir="ASC") {

		$listdata=array();

		//$sql="Select ITQ.* from itq_details ITQ inner join mro_details MRO on ITQ.itq_mropkey=MRO.mro_pkey where ITQ.itq_mropkey = '".$mropkey."' and MRO.mro_status!=4 order by ITQ.".$sortby." ".$sortdir;
		$sql="Select ITQ.* from itq_details ITQ where ITQ.itq_mropkey = '".$mropkey."' order by ITQ.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of itqs by project
	New version is not based on MRO!
	******************************************************************************** */

	function getlist_itqbyproject($projectpkey, $rfqno="", $mrono="", $vendorname="", $sortby="itq_rfqno", $sortdir="DESC") {

		$listdata=array();

		//$sql="Select MRO.*, ITQ.* from mro_details MRO left join itq_details ITQ on MRO.mro_pkey=ITQ.itq_mropkey where MRO.mro_projectpkey = '".$projectpkey."' and MRO.mro_status=3 order by ITQ.".$sortby." ".$sortdir;

		//$sql="Select ITQ.*, MRO.* from itq_details ITQ left join mro_details MRO on ITQ.itq_mropkey=MRO.mro_pkey where MRO.mro_projectpkey = '".$projectpkey."' order by ITQ.".$sortby." ".$sortdir;
		//$sql="Select ITQ.*, MRO.*, ITS.itq_supplierpkey from itq_details ITQ left join mro_details MRO on ITQ.itq_mropkey=MRO.mro_pkey left join itq_suppliers ITS on ITQ.itq_pkey=ITS.itq_pkey where MRO.mro_projectpkey = '".$projectpkey."' and (ITQ.itq_rfqno like '%".$rfqno."%' and MRO.mro_id like '%".$mrono."%' and ITS.itq_supplierpkey like '%".$vendorname."%') order by ITQ.".$sortby." ".$sortdir;
		//$sql="Select ITQ.*, MRO.*, ITS.itq_supplierpkey from itq_details ITQ left join mro_details MRO on ITQ.itq_mropkey=MRO.mro_pkey left join itq_suppliers ITS on ITQ.itq_pkey=ITS.itq_pkey where MRO.mro_projectpkey = '".$projectpkey."' and (ITQ.itq_rfqno like '%".$rfqno."%' and MRO.mro_id like '%".$mrono."%' and ITS.itq_supplierpkey like '%".$vendorname."%') and ITQ.itq_evalstatus<>9 order by ITQ.".$sortby." ".$sortdir;
		// lagi baru, yg dah PO xnak tunjuk kt itq list
		$sql="Select ITQ.*, MRO.*, ITS.itq_supplierpkey from itq_details ITQ left join mro_details MRO on ITQ.itq_mropkey=MRO.mro_pkey left join itq_suppliers ITS on ITQ.itq_pkey=ITS.itq_pkey where MRO.mro_projectpkey = '".$projectpkey."' and (ITQ.itq_rfqno like '%".$rfqno."%' and MRO.mro_id like '%".$mrono."%' and ITS.itq_supplierpkey like '%".$vendorname."%') and ITQ.itq_evalstatus<>9 and ITQ.itq_evalstatus<>3 order by ITQ.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of itqs by project
	New version is not based on MRO!
	******************************************************************************** */

	//function getlist_itqhistory($projectpkey, $rfqno="", $mrono="", $vendorname="", $sortby="itq_rfqno", $sortdir="DESC") {
	function getlist_itqhistory($projectpkey, $sortby="itq_rfqno", $sortdir="DESC") {

		$listdata=array();

		//$sql="Select ITQ.*, MRO.*, ITS.itq_supplierpkey from itq_details ITQ left join mro_details MRO on ITQ.itq_mropkey=MRO.mro_pkey left join itq_suppliers ITS on ITQ.itq_pkey=ITS.itq_pkey where MRO.mro_projectpkey = '".$projectpkey."' and (ITQ.itq_rfqno like '%".$rfqno."%' and MRO.mro_id like '%".$mrono."%' and ITS.itq_supplierpkey like '%".$vendorname."%') and (ITQ_.itq_evalstatus=9 or ITQ.itq_cancel=1) order by ITQ.".$sortby." ".$sortdir;
		//$sql="Select ITQ.*, MRO.*, ITS.itq_supplierpkey from itq_details ITQ left join mro_details MRO on ITQ.itq_mropkey=MRO.mro_pkey left join itq_suppliers ITS on ITQ.itq_pkey=ITS.itq_pkey where MRO.mro_projectpkey = '".$projectpkey."' and (ITQ.itq_evalstatus=9 or ITQ.itq_cancel=1) order by ITQ.".$sortby." ".$sortdir;
		// lagi baru, yg dah PO nak tunjuk kt sini
		$sql="Select ITQ.*, MRO.*, ITS.itq_supplierpkey from itq_details ITQ left join mro_details MRO on ITQ.itq_mropkey=MRO.mro_pkey left join itq_suppliers ITS on ITQ.itq_pkey=ITS.itq_pkey where MRO.mro_projectpkey = '".$projectpkey."' and (ITQ.itq_evalstatus=3 or ITQ.itq_evalstatus=9 or ITQ.itq_cancel=1) order by ITQ.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}
	
	/*
	new rfq history
	*/
	function getlist_itqhistory_yusrul($projectpkey, $rfqno1="", $mrono1="", $vendorname1="", $sortby="itq_rfqno", $sortdir="DESC") {
	//function getlist_itqhistory($projectpkey, $sortby="itq_rfqno", $sortdir="DESC") {

		$listdata=array();
        if($rfqno1!="" or $mrono1 != "" or $vendorname1 != ""){
		$sql="Select ITQ.*, MRO.*, ITS.itq_supplierpkey from itq_details ITQ left join mro_details MRO on ITQ.itq_mropkey=MRO.mro_pkey left join itq_suppliers ITS on ITQ.itq_pkey=ITS.itq_pkey where MRO.mro_projectpkey = '".$projectpkey."' and (ITQ.itq_rfqno like '%".$rfqno1."%' and MRO.mro_id like '%".$mrono1."%' and ITS.itq_supplierpkey like '%".$vendorname1."%') and (ITQ.itq_evalstatus=3 or ITQ.itq_evalstatus=9 or ITQ.itq_cancel=1) order by ITQ.".$sortby." ".$sortdir;
		
		//$sql="Select ITQ.*, MRO.*, ITS.itq_supplierpkey from itq_details ITQ left join mro_details MRO on ITQ.itq_mropkey=MRO.mro_pkey left join itq_suppliers ITS on ITQ.itq_pkey=ITS.itq_pkey where MRO.mro_projectpkey = '".$projectpkey."' and (ITQ.itq_rfqno like '%".$rfqno."%' and MRO.mro_id like '%".$mrono."%' and ITS.itq_supplierpkey like '%".$vendorname."%') and (ITQ_.itq_evalstatus=9 or ITQ.itq_cancel=1) order by ITQ.".$sortby." ".$sortdir;
		//$sql="Select ITQ.*, MRO.*, ITS.itq_supplierpkey from itq_details ITQ left join mro_details MRO on ITQ.itq_mropkey=MRO.mro_pkey left join itq_suppliers ITS on ITQ.itq_pkey=ITS.itq_pkey where MRO.mro_projectpkey = '".$projectpkey."' and (ITQ.itq_evalstatus=9 or ITQ.itq_cancel=1) order by ITQ.".$sortby." ".$sortdir;
		}else{
		// lagi baru, yg dah PO nak tunjuk kt sini
		$sql="Select ITQ.*, MRO.*, ITS.itq_supplierpkey from itq_details ITQ left join mro_details MRO on ITQ.itq_mropkey=MRO.mro_pkey left join itq_suppliers ITS on ITQ.itq_pkey=ITS.itq_pkey where MRO.mro_projectpkey = '".$projectpkey."' and (ITQ.itq_evalstatus=3 or ITQ.itq_evalstatus=9 or ITQ.itq_cancel=1) order by ITQ.".$sortby." ".$sortdir;
		}
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}



	/* ********************************************************************************
	Select list of itqs by project by status
	******************************************************************************** */

	function getlist_itqbystatus($projectpkey, $itqstatus, $sortby="itq_date", $sortdir="ASC") {

		$listdata=array();

		$sql="Select MRO.*, ITQ.* from mro_details MRO inner join itq_details ITQ on MRO.mro_pkey=ITQ.itq_mropkey where MRO.mro_projectpkey = '".$projectpkey."' and ITQ.itq_status=".$itqstatus." order by ITQ.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}

/* ********************************************************************************
	arie add 06/07/2011  Select list of itqs by project by status
	******************************************************************************** */

	function getlist_itqbystatus_arie($projectpkey, $itqstatus, $sortby="itq_date", $sortdir="ASC") {

		$listdata=array();

		$sql="Select MRO.*, ITQ.* from mro_details MRO inner join itq_details ITQ on MRO.mro_pkey=ITQ.itq_mropkey where MRO.mro_projectpkey = '".$projectpkey."' and ITQ.itq_status=".$itqstatus." and ITQ.itq_cancel = 0  order by ITQ.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}




	/* ********************************************************************************
	Select list of itqs by project by eval status
	******************************************************************************** */

	function getlist_itqbyevalstatus($projectpkey, $evalstatus, $sortby="itq_date", $sortdir="ASC") {

		$listdata=array();

		$sql="Select MRO.*, ITQ.* from mro_details MRO inner join itq_details ITQ on MRO.mro_pkey=ITQ.itq_mropkey where MRO.mro_projectpkey = '".$projectpkey."' and ITQ.itq_evalstatus=".$evalstatus." order by ITQ.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}

/* ********************************************************************************
	06/07/2011 Select list of itqs by project by eval status
	******************************************************************************** */

	function getlist_itqbyevalstatus_arie($projectpkey, $evalstatus, $sortby="itq_date", $sortdir="ASC") {

		$listdata=array();

		$sql="Select MRO.*, ITQ.* from mro_details MRO inner join itq_details ITQ on MRO.mro_pkey=ITQ.itq_mropkey where MRO.mro_projectpkey = '".$projectpkey."' and ITQ.itq_evalstatus=".$evalstatus." and ITQ.itq_cancel = 0 order by ITQ.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}




	/* ********************************************************************************
	Select a particular itq
	******************************************************************************** */

	function getdata_itq($itqpkey){

		$data=array();

		$sql="Select ITQ.* from itq_details ITQ where ITQ.itq_pkey='".$itqpkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select a particular itq by mro
	******************************************************************************** */

	function getdata_itqbymro($mropkey){

		$data=array();

		$sql="Select ITQ.* from itq_details ITQ where ITQ.itq_mropkey='".$mropkey."'";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select a particular supplier's rate
	******************************************************************************** */

	function getdata_itemratebysupplier($itempkey, $supplierpkey){

		$data=array();

		$sql="Select ITE.eval_supplierrate from itq_evaluation ITE where ITE.eval_itempkey='".$itempkey."' and ITE.eval_supplierpkey='".$supplierpkey."'";
		$data=$this->getextendedrow($sql);
		return $data['eval_supplierrate'];
	}


	/* ********************************************************************************
	Select list of itq suppliers (for general use list)
	******************************************************************************** */

	function getlist_suppliers($itqpkey) {

		$listdata=array();

		$sql="Select ITQ.* from itq_suppliers ITQ where ITQ.itq_pkey = '".$itqpkey."'";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of itq evaluation (for general use list)
	******************************************************************************** */

	function getlist_evaluations($itqpkey) {

		$listdata=array();

		$sql="Select ITQ.* from itq_evaluation ITQ where ITQ.eval_itqpkey = '".$itqpkey."'";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of itq suppliers
	******************************************************************************** */

	function getlist_itqsuppliers($itqpkey, $sortby="itq_supplierpkey", $sortdir="ASC") {

		$listdata=array();

		$sql="Select ITQ.* from itq_suppliers ITQ where ITQ.itq_pkey = '".$itqpkey."' order by ITQ.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of itq suppliers (distinct) by project
	******************************************************************************** */

	function getlist_itqsuppliersbyproject($projectpkey, $sortby="itq_supplierpkey", $sortdir="ASC") {

		$listdata=array();

		$sql="Select distinct ITQ.itq_supplierpkey from itq_suppliers ITQ inner join itq_details ITD on ITQ.itq_pkey=ITD.itq_pkey inner join mro_details MRO on ITD.itq_mropkey=MRO.mro_pkey where MRO.mro_projectpkey = '".$projectpkey."' order by ITQ.".$sortby." ".$sortdir;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of itq evaluation items
	******************************************************************************** */

	function getlist_itqitems($mropkey, $sortby="item_no", $sortdir="ASC") {

		$listdata=array();

		$sql="Select ITQE.*, MROI.* from mro_items MROI left join itq_evaluation ITQE on MROI.item_pkey=ITQE.eval_itempkey where MROI.item_mropkey = '".$mropkey."' order by MROI.".$sortby." ".$sortdir.", eval_supplierpkey ASC";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
		//d3ee50108ffce989b8e1dc73d3c180af
	}


	/* ********************************************************************************
	Select list of itq evaluation by item
	******************************************************************************** */

	function getlist_itqevaluationbyitem($mropkey, $itempkey) {

		$listdata=array();

		$sql="Select ITQE.* from itq_evaluation ITQE where ITQE.eval_mropkey = '".$mropkey."' and ITQE.eval_itempkey = '".$itempkey."' order by eval_supplierpkey ASC";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of itq evaluation by approval
	(NOT USED, SEE FOLLOWING FUNCTION) (EH, USED WHEN CREATING PO LAA) (NO!)
	******************************************************************************** */

	function getlist_itqevaluationbyapproval($itqpkey, $supplierpkey) {

		$listdata=array();
		//$sql="Select distinct ITQA.approval_itempkey from itq_approvals ITQA where ITQA.approval_itqpkey = '".$itqpkey."' and ITQA.approval_supplierpkey = '".$supplierpkey."' order by ITQA.approval_itempkey ASC";
		$sql="Select ITQA.* from itq_approvals ITQA where ITQA.approval_itqpkey = '".$itqpkey."' and ITQA.approval_supplierpkey = '".$supplierpkey."' order by ITQA.approval_itempkey ASC";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of itq evaluation approval by supplier
	This function does not restrict by po/itq/etc. So any item approved for the supplier
	at any stage can be selected..
	******************************************************************************** */

	function getlist_itqevaluationapprovalbysupplier($projectpkey, $supplierpkey) {

		$listdata=array();
		$sql="Select distinct ITQA.approval_itempkey from itq_approvals ITQA inner join mro_items MRI on ITQA.approval_itempkey=MRI.item_pkey inner join mro_details MRO on MRI.item_mropkey=MRO.mro_pkey where MRO.mro_projectpkey = '".$projectpkey."' and ITQA.approval_supplierpkey = '".$supplierpkey."' order by ITQA.approval_itempkey ASC";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of latest itq approvals by supplier
	******************************************************************************** */

	function getdata_lastitqapprovalsbysupplier($itqpkey,$itempkey,$supplierpkey) {

		$data=array();
		$sql="Select ITQA.* from itq_approvals ITQA where ITQA.approval_itqpkey = '".$itqpkey."' and ITQA.approval_itempkey = '".$itempkey."' and ITQA.approval_supplierpkey = '".$supplierpkey."' order by ITQA.approval_date DESC limit 0,1";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select list of itq approvals
	******************************************************************************** */

	function getlist_itqapprovals($itqpkey) {

		$listdata=array();
		$sql="Select ITQA.* from itq_approvals ITQA where ITQA.approval_itqpkey = '".$itqpkey."' order by ITQA.approval_supplierpkey";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of itq approvals (saved)
	******************************************************************************** */

	function getlist_itqapprovalssaved($itqpkey) {

		$listdata=array();
		$sql="Select ITQA.* from itq_approvals ITQA where ITQA.approval_itqpkey = '".$itqpkey."' and ITQA.approval_type=0 order by ITQA.approval_supplierpkey";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of itq awarded suppliers
	previously uses evaluation table, now uses approval table!!
	TODO: Bug: How to select just the latest set of approvals???
	******************************************************************************** */

	function getlist_itqawardedsuppliers($itqpkey) {

		$listdata=array();

		//$sql="Select distinct ITQE.eval_supplierpkey from itq_evaluation ITQE where ITQE.eval_itqpkey = '".$itqpkey."'";
		$sql="Select distinct ITQA.approval_supplierpkey from itq_approvals ITQA where ITQA.approval_itqpkey = '".$itqpkey."' and ITQA.approval_quantity>0 and ITQA.approval_type=3 and ITQA.approval_status=1";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}
	
	function getlist_itqawardedsuppliers_yus($itqpkey) {

		$listdata=array();

		//$sql="Select distinct ITQE.eval_supplierpkey from itq_evaluation ITQE where ITQE.eval_itqpkey = '".$itqpkey."'";
		$sql="Select distinct ITQA.approval_supplierpkey from itq_approvals ITQA where ITQA.approval_itqpkey = '".$itqpkey."' and ITQA.approval_quantity>0 and ITQA.approval_type=3 and ITQA.approval_status=1 ORDER BY approval_date DESC";
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select list of rfq for budget monitoring report
	TODO: check whether to use ALL RFQs (minus rejected/cancelled) or just approved RFQs??
	******************************************************************************** */

	function getlist_itq_bmreport($projectpkey, $datefrom, $dateto) {

		$listdata=array();

		if (($datefrom!="")&&($dateto!="")) {
			$sql="Select ITQ.*, MRO.*, ST.* from itq_details ITQ inner join mro_details MRO on ITQ.itq_mropkey = MRO.mro_pkey inner join settings_trades ST on ITQ.itq_subtradepkey = ST.tradepkey where MRO.mro_projectpkey = '".$projectpkey."' and ITQ.itq_cancel=0 and ITQ.itq_date >= '".$datefrom."' and ITQ.itq_date <= '".$dateto."' order by ST.tradedescription, ITQ.itq_rfqno";
		} else {
			$sql="Select ITQ.*, MRO.*, ST.* from itq_details ITQ inner join mro_details MRO on ITQ.itq_mropkey = MRO.mro_pkey inner join settings_trades ST on ITQ.itq_subtradepkey = ST.tradepkey where MRO.mro_projectpkey = '".$projectpkey."' and ITQ.itq_cancel=0 order by ST.tradedescription, ITQ.itq_rfqno";
		}
		//echo $sql;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	arie add 29/12/2011
	Select list of rfq for budget monitoring report
	TODO: check whether to use ALL RFQs (minus rejected/cancelled) or just approved RFQs??
	******************************************************************************** */

	function getlist_itq_bmreport_arie($projectpkey, $datefrom, $dateto) {

		$listdata=array();

		if (($datefrom!="")&&($dateto!="")) {
			$sql="Select ITQ.*, MRO.*, ST.* from itq_details ITQ inner join mro_details MRO on ITQ.itq_mropkey = MRO.mro_pkey inner join settings_trades ST on ITQ.itq_subtradepkey = ST.tradepkey where MRO.mro_projectpkey = '".$projectpkey."' and ITQ.itq_cancel=0 and MRO.mro_subcons = '' and ITQ.itq_date >= '".$datefrom."' and ITQ.itq_date <= '".$dateto."' order by ST.tradedescription, ITQ.itq_rfqno";
		} else {
			$sql="Select ITQ.*, MRO.*, ST.* from itq_details ITQ inner join mro_details MRO on ITQ.itq_mropkey = MRO.mro_pkey inner join settings_trades ST on ITQ.itq_subtradepkey = ST.tradepkey where MRO.mro_projectpkey = '".$projectpkey."' and ITQ.itq_cancel=0 and MRO.mro_subcons = '' order by ST.tradedescription, ITQ.itq_rfqno";
		}
		//echo $sql;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}



	/* ********************************************************************************
	Select list of rfq items for budget monitoring report
	******************************************************************************** */

	function getlist_itqitems_bmreport($itqpkey, $itempkey) {

		$listdata=array();

		$sql="Select ITQA.*, ITQE.* from itq_approvals ITQA inner join itq_evaluation ITQE on ITQA.approval_itqpkey = ITQE.eval_itqpkey and ITQA.approval_supplierpkey = ITQE.eval_supplierpkey and ITQA.approval_itempkey = ITQE.eval_itempkey where ITQA.approval_itqpkey = '".$itqpkey."' and ITQA.approval_itempkey = '".$itempkey."' and ITQA.approval_type=3 and ITQA.approval_status=1 and ITQA.approval_quantity>0 order by ITQA.approval_supplierpkey";
		//$sql="Select distinct ITQA.approval_itempkey, ITQA.approval_quantity, ITQE.eval_supplierrate from itq_approvals ITQA inner join itq_evaluation ITQE on ITQA.approval_itqpkey = ITQE.eval_itqpkey and ITQA.approval_supplierpkey = ITQE.eval_supplierpkey and ITQA.approval_itempkey = ITQE.eval_itempkey where ITQA.approval_itqpkey = '".$itqpkey."' and ITQA.approval_itempkey = '".$itempkey."' and ITQA.approval_type=3 and ITQA.approval_status=1 and ITQA.approval_quantity>0 order by ITQA.approval_supplierpkey";
		//echo $sql;
		$listdata=$this->getextendedrows($sql);
		return $listdata;
	}


	/* ********************************************************************************
	Select data of itq evaluation by item by supplier
	******************************************************************************** */

	function getdata_itqevaluationbysupplier($mropkey, $itempkey, $supplierpkey) {

		$data=array();

		$sql="Select ITQE.* from itq_evaluation ITQE where ITQE.eval_mropkey = '".$mropkey."' and ITQE.eval_itempkey = '".$itempkey."' and ITQE.eval_supplierpkey='".$supplierpkey."' order by eval_supplierpkey ASC";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select a particular itq's latest approval by approval type
	******************************************************************************** */

	function getdata_lastapprovalbytype($itqpkey,$approvaltype) {

		$data=array();

		$sql="Select ITQ.* from itq_approvals ITQ where ITQ.approval_itqpkey='".$itqpkey."' and ITQ.approval_type=".$approvaltype." order by ITQ.approval_date DESC limit 0,1";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select a particular itq's latest approval
	******************************************************************************** */

	function getdata_lastapproval($itqpkey,$itempkey) {

		$data=array();

		$sql="Select ITQ.* from itq_approvals ITQ where ITQ.approval_itqpkey='".$itqpkey."' and ITQ.approval_itempkey='".$itempkey."' order by ITQ.approval_date DESC limit 0,1";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Select a particular itq's latest approval by supplier
	******************************************************************************** */

	function getdata_lastapprovalbysupplier($itqpkey,$itempkey,$supplierpkey) {

		$data=array();

		$sql="Select ITQ.* from itq_approvals ITQ where ITQ.approval_itqpkey='".$itqpkey."' and ITQ.approval_itempkey='".$itempkey."' and ITQ.approval_supplierpkey='".$supplierpkey."' order by ITQ.approval_date DESC limit 0,1";
		$data=$this->getextendedrow($sql);
		return $data;
	}


	/* ********************************************************************************
	Get last itq id, i.e. rfq no (ignore cancelled itq/rfqs)
	******************************************************************************** */

	function getdata_lastitqid(){

		$data=array();

		$sql="Select max(ITQ.itq_rfqno) as lastid from itq_details ITQ";	// where ITQ.itq_cancel=0";
		$data=$this->getextendedrow($sql);
		return $data['lastid'];
	}


	/* ********************************************************************************
	Get last itq revision no
	******************************************************************************** */

	function getdata_revno($itqpkey){

		$data=array();

		$sql="Select ITQ.itq_revno as revno from itq_details ITQ where ITQ.itq_pkey='".$itqpkey."'";
		$data=$this->getextendedrow($sql);
		return $data['revno'];
	}


	/* FUNCTIONS TO INSERT RECORDS */


	/* ********************************************************************************
	Insert/Create a new itq
	******************************************************************************** */

	function insertdata_itq($p_itq_pkey, $p_itq_mropkey, $p_itq_subtradepkey, $p_itq_date, $p_itq_from, $p_itq_type, $p_itq_returndate, $p_itq_suppliers, $p_alert) {

		include_once('supplierModel.php');
		$mysupplierModel=new supplierModel;

		// clean/convert/add params..
		$p_itq_date=converttounix($p_itq_date);
		$p_itq_returndate=converttounix($p_itq_returndate);
		$p_itq_supplierpkeys=explode(";",$p_itq_suppliers);
		$myusername = $_SESSION['Xstaffname'];

		// Note: any time a new itq is created/updated (and same/other suppliers invited), system
		// shall override old data
		// NO!!
		// New: update revision number but maintain existing itq record :P

		if ($p_itq_pkey!="") {

			//$myitq = $this->getdata_itq($p_itq_pkey);

			// skang ni delete je la sumer.. eval, suppliers, itq.. approval xyah kot? buat je la.. XYAHH!! (history)
			$da1 = $this->deletedata_itqevaluation($p_itq_pkey);
			$da2 = $this->deletedata_itqsuppliers($p_itq_pkey);
			//$da3 = $this->deletedata_itqapprovals($p_itq_pkey);
			//$da4 = $this->deletedata_itqbyitq($p_itq_pkey);
			// Note: itq itself not deleted, too

			//if (($da1!=1)||($da2!=1)||($da3!=1)||($da4!=1)) {
			//	return false;
			//}

		}

		if ($p_itq_pkey!="") {

			// re-create itq with new rev no and initial status
			// NO!! rev no is only incremented upon reject rfq or cancel po!!!

			//$myrevno = $this->getdata_revno($p_itq_pkey);
			//$myrevno++;

			// update..
			$sa = $this->update_data("ITQ [Edit]", "itq_details", "itq_date = '".$p_itq_date.
				"', itq_from = '".$p_itq_from.
				"', itq_type = ".$p_itq_type.
				", itq_returndate = '".$p_itq_returndate.
				"', itq_requestor = '".$myusername.
				"', itq_status = "."1".
				", itq_evalstatus = "."0".
				", itq_cancel = "."0",
				"where itq_pkey = '".$p_itq_pkey."'");

			$new_itq_pkey=$p_itq_pkey;

		} else {

			// update..
			$new_itq_pkey=md5(microtime());

			$lastid=$this->getdata_lastitqid();
			$lastid++;

			$sa = $this->add_data("ITQ [Add]", "itq_details", "itq_pkey, itq_mropkey, itq_subtradepkey, itq_rfqno, itq_date, itq_from, itq_type, itq_returndate, itq_requestor, itq_status",
				"'".$new_itq_pkey."','".$p_itq_mropkey."','".$p_itq_subtradepkey.
				"',".$lastid.
				",'".$p_itq_date."','".$p_itq_from."',".$p_itq_type.
				",'".$p_itq_returndate."','".$myusername."',1");

		}

		foreach($p_itq_supplierpkeys as $p_itq_supplierpkey) {

			$supplier_data = $mysupplierModel->getdata_supplier($p_itq_supplierpkey);
			$p_itq_attn=$supplier_data['supplier_pic'];

			$sa2 = $this->add_data("ITQ Supplier [Add]", "itq_suppliers", "itq_pkey, itq_supplierpkey, itq_attn",
				"'".$new_itq_pkey."','".$p_itq_supplierpkey."','".$p_itq_attn."'");

			if ($supplier_data['supplier_approved']=="0") {
				$sa3 = $mysupplierModel->insertdata_approval("", $p_itq_supplierpkey, "2", $_SESSION['Xuserpkey'], $myusername, "", "1", "Approved at ITQ");
			}

		}

		// update mro status!
		include_once('mroModel.php');
		$mymroModel=new mroModel;

		$sa3 = $mymroModel->updatestatus_mro($p_itq_mropkey,"4");

		// return result..
		if ($sa==1) {
			//return $p_itq_mropkey;
			return $new_itq_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Insert/Create a new itq evaluation item
	(no update function)
	******************************************************************************** */

	function insertdata_itqevaluation($p_eval_itqpkey, $p_eval_mropkey, $p_eval_itempkeys, $p_eval_supplierpkeys, $p_eval_supplierrates, $p_eval_awardedquantities, $p_eval_supplierremarks, $p_eval_supplierselected, $p_eval_zikayrates, $p_eval_transportrates, $p_approval_type) {

		// clean/convert/add params..
		$p_eval_supplierrates=str_replace(",","",$p_eval_supplierrates);
		$p_eval_transportrates=str_replace(",","",$p_eval_transportrates);

		$p_eval_itempkey=explode(";",$p_eval_itempkeys);
		$p_eval_supplierpkey=explode(";",$p_eval_supplierpkeys);
		$p_eval_supplierrate=explode(";",$p_eval_supplierrates);
		$p_eval_awardedquantities=explode(";",$p_eval_awardedquantities);
		$p_eval_supplierremark=explode("|",$p_eval_supplierremarks);
		$p_eval_selected=explode(";",$p_eval_supplierselected);
		$p_eval_zikayrate=explode(";",$p_eval_zikayrates);
		$p_eval_transportrate=explode(";",$p_eval_transportrates);

		include_once('mroModel.php');
		$mymroModel=new mroModel;

		// clear evaluation table
		$sa = $this->deletedata_itqevaluation($p_eval_itqpkey);

		// itempkey=3
		// supppkey=10
		// rate=3,6,00000000,4,7

		$ratecount=0;
		$itemcount=0;

		foreach ($p_eval_itempkey as $itempkey) {

			foreach ($p_eval_supplierpkey as $supplierpkey) {

				// update..
				$sa = $this->add_data("ITQ Evaluation [Add]", "itq_evaluation", "eval_itqpkey, eval_mropkey, eval_itempkey, eval_supplierpkey, eval_supplierrate",
					"'".$p_eval_itqpkey."','".$p_eval_mropkey.
					"','".$itempkey."','".$supplierpkey.
					"','".$p_eval_supplierrate[$ratecount]."'");

				$ratecount++;
			}

			// update mro with item rate :P
			$sa2 = $mymroModel->updaterate_mroitem($itempkey, $p_eval_mropkey, $p_eval_zikayrate[$itemcount]);

			reset($p_eval_supplierpkey);

			$itemcount++;
		}

		$pcount=0;

		reset($p_eval_supplierpkey);
		foreach ($p_eval_supplierpkey as $supplierpkey) {
			if ($supplierpkey!="") {
				// update..
				$sa1 = $this->update_data("ITQ Evaluation Remarks [Edit]", "itq_suppliers", "itq_remarks = '".$p_eval_supplierremark[$pcount].
					"', itq_transportrate = ".$p_eval_transportrate[$pcount],
					"where itq_pkey = '".$p_eval_itqpkey."' and itq_supplierpkey = '".$supplierpkey."'");
			}
			$pcount++;
		}

		$qtycount=0;
		$itemcount=0;

		// for rfq, approval is special table since it also signifies submit

		// delete previous approvals if any
		$sa3 = $this->deletedata_itqapproval($p_eval_itqpkey, $p_approval_type);

		reset($p_eval_itempkey);
		foreach ($p_eval_itempkey as $itempkey) {

			reset($p_eval_supplierpkey);
			foreach ($p_eval_supplierpkey as $supplierpkey) {

				$sa4 = $this->insertdata_approval("", $p_eval_itqpkey, $itempkey, $supplierpkey, $p_eval_awardedquantities[$qtycount], $p_approval_type, $_SESSION['Xuserpkey'], $_SESSION['Xstaffname'], "", "1", "");

				$qtycount++;

			}
			$itemcount++;			
		}

		// if dealing with a previously rejected rfq (due to reject rfq or po), reset itq status

		$myitq =  $this->getdata_itq($p_eval_itqpkey);

		if ($myitq['itq_cancel']=="2") {

			// update..
			$sa = $this->update_data("ITQ [Edit]", "itq_details", "itq_evalstatus = "."0".
				", itq_cancel = "."0",
				"where itq_pkey = '".$p_eval_itqpkey."'");

		}

		// if approval, update mro status

		// NOTE: NO LONGER HAPPENS HERE!! HAPPENS IN FUNCTION updatedata_approval()!!
		// (since approval no longer goes through this function!!)

		/*
		if ($p_approval_type=="3") {

			// update mro status!
			include_once('mroModel.php');
			include_once('poModel.php');
			include_once('supplierModel.php');
			$mymroModel=new mroModel;
			$mypoModel=new poModel;
			$mysupplierModel=new supplierModel;

			$sa4 = $mymroModel->updatestatus_mro($p_eval_mropkey,"5");

			// create POs automatically!!

			$myitq = $this->getdata_itq($p_eval_itqpkey);
			$myusername = $_SESSION['Xstaffname'];

			reset($p_eval_selected);
			reset($p_eval_itempkey);
			
			$icount = 0;

			foreach ($p_eval_selected as $selectedpkey) {

				$myitempkey = $p_eval_itempkey[$icount];

				// get supplier data
				$mysupplier = $mysupplierModel->getdata_supplier($selectedpkey);

				// careful not to create more than 1 PO per supplier!
				if ($mypoModel->getstatus_poexists($_SESSION['Xprojectpkey'], $p_eval_mropkey, $p_eval_itqpkey, $selectedpkey)=="0") {

					// get last po id..
					$lastid=$mypoModel->getdata_lastpoid();
					$lastid++;

					$sa5 = $this->generate_po($_SESSION['Xprojectpkey'], $p_eval_mropkey, $p_eval_itqpkey, $selectedpkey, $lastid, unconverttounix(gettimestamp()), 30, $mysupplier['supplier_pic']." ".$mysupplier['supplier_picphone'], "", "", $_SESSION['Xuserpkey'], "", "", $myitq['itq_requestor'], $myusername);
					$icount++;
				}
			}
		}
		*/

		// return result..
		if ($sa==1) {
			return $p_eval_itqpkey;
		} else {
			return false;
		}
	}
	
// edit itq 22-12-2011 yusrul
function insertdata_itqevaluation_hantu_yus($p_eval_itqpkey, $p_eval_mropkey, $p_eval_itempkeys, $p_eval_supplierpkeys, $p_eval_supplierrates, $p_eval_awardedquantities, $p_eval_supplierremarks, $p_eval_supplierselected, $p_eval_zikayrates, $p_eval_transportrates, $p_approval_type) {

		// clean/convert/add params..
		$p_eval_supplierrates=str_replace(",","",$p_eval_supplierrates);
		$p_eval_transportrates=str_replace(",","",$p_eval_transportrates);

		$p_eval_itempkey=explode(";",$p_eval_itempkeys);
		$p_eval_supplierpkey=explode(";",$p_eval_supplierpkeys);
		$p_eval_supplierrate=explode(";",$p_eval_supplierrates);
		$p_eval_awardedquantities=explode(";",$p_eval_awardedquantities);
		$p_eval_supplierremark=explode("|",$p_eval_supplierremarks);
		$p_eval_selected=explode(";",$p_eval_supplierselected);
		$p_eval_zikayrate=explode(";",$p_eval_zikayrates);
		$p_eval_transportrate=explode(";",$p_eval_transportrates);
		
		include_once('mroModel.php');
		$mymroModel=new mroModel;

		$sa = $this->deletedata_itqevaluation($p_eval_itqpkey);

		$ratecount=0;
		$itemcount=0;

		foreach ($p_eval_itempkey as $itempkey) {

			foreach ($p_eval_supplierpkey as $supplierpkey) {

				// update..
				$sa = $this->add_data("ITQ Evaluation [Add]", "itq_evaluation", "eval_itqpkey, eval_mropkey, eval_itempkey, eval_supplierpkey, eval_supplierrate",
					"'".$p_eval_itqpkey."','".$p_eval_mropkey.
					"','".$itempkey."','".$supplierpkey.
					"','".$p_eval_supplierrate[$ratecount]."'");

				$ratecount++;
			} }
			
			
		$pcount=0;

        reset($p_eval_supplierpkey);
		foreach ($p_eval_supplierpkey as $supplierpkey) {
			if ($supplierpkey!="") {
				// update..
				$sa1 = $this->update_data("ITQ Evaluation Remarks [Edit]", "itq_suppliers", "itq_remarks = '".$p_eval_supplierremark[$pcount].
					"', itq_transportrate = ".$p_eval_transportrate[$pcount],
					"where itq_pkey = '".$p_eval_itqpkey."' and itq_supplierpkey = '".$supplierpkey."'");
					
			
					
			}
			$pcount++;
			
		}
		
		    $qtycount=0;
		    $itemcount=0;
		    $sa3 = $this->deletedata_itqapproval($p_eval_itqpkey, $p_approval_type);
			reset($p_eval_supplierpkey);
			foreach ($p_eval_supplierpkey as $supplierpkey) {

				$sa4 = $this->insertdata_approval("", $p_eval_itqpkey, $itempkey, $supplierpkey, $p_eval_awardedquantities[$qtycount], $p_approval_type, $_SESSION['Xuserpkey'], $_SESSION['Xstaffname'], "", "1", "");

				$qtycount++;
                $itemcount++;
			}
					
		
	   
	
		
		// return result..
		if ($sa1==1) {
			return $p_eval_itqpkey;
		} else {
			return false;
		}


		
}		
	
//edit IQT ################################
function insertdata_itqevaluation_hantu($p_eval_itqpkey, $p_eval_mropkey, $p_eval_itempkeys, $p_eval_supplierpkeys, $p_eval_supplierrates, $p_eval_awardedquantities, $p_eval_supplierremarks, $p_eval_supplierselected, $p_eval_zikayrates, $p_eval_transportrates, $p_approval_type) {

		// clean/convert/add params..
		$p_eval_supplierrates=str_replace(",","",$p_eval_supplierrates);
		$p_eval_transportrates=str_replace(",","",$p_eval_transportrates);

		$p_eval_itempkey=explode(";",$p_eval_itempkeys);
		$p_eval_supplierpkey=explode(";",$p_eval_supplierpkeys);
		$p_eval_supplierrate=explode(";",$p_eval_supplierrates);
		$p_eval_awardedquantities=explode(";",$p_eval_awardedquantities);
		$p_eval_supplierremark=explode("|",$p_eval_supplierremarks);
		$p_eval_selected=explode(";",$p_eval_supplierselected);
		$p_eval_zikayrate=explode(";",$p_eval_zikayrates);
		$p_eval_transportrate=explode(";",$p_eval_transportrates);

		include_once('mroModel.php');
		$mymroModel=new mroModel;

		// clear evaluation table
		$sa = $this->deletedata_itqevaluation($p_eval_itqpkey);

		// itempkey=3
		// supppkey=10
		// rate=3,6,00000000,4,7

		$ratecount=0;
		$itemcount=0;

		foreach ($p_eval_itempkey as $itempkey) {

			foreach ($p_eval_supplierpkey as $supplierpkey) {

				// update..
				$sa = $this->add_data("ITQ Evaluation [Add]", "itq_evaluation", "eval_itqpkey, eval_mropkey, eval_itempkey, eval_supplierpkey, eval_supplierrate",
					"'".$p_eval_itqpkey."','".$p_eval_mropkey.
					"','".$itempkey."','".$supplierpkey.
					"','".$p_eval_supplierrate[$ratecount]."'");

				$ratecount++;
			}

			// update mro with item rate :P
			$sa2 = $mymroModel->updaterate_mroitem($itempkey, $p_eval_mropkey, $p_eval_zikayrate[$itemcount]);

			reset($p_eval_supplierpkey);

			$itemcount++;
		}

		$pcount=0;

		reset($p_eval_supplierpkey);
		foreach ($p_eval_supplierpkey as $supplierpkey) {
			if ($supplierpkey!="") {
				// update..
				$sa1 = $this->update_data("ITQ Evaluation Remarks [Edit]", "itq_suppliers", "itq_remarks = '".$p_eval_supplierremark[$pcount].
					"', itq_transportrate = ".$p_eval_transportrate[$pcount],
					"where itq_pkey = '".$p_eval_itqpkey."' and itq_supplierpkey = '".$supplierpkey."'");
			}
			$pcount++;
		}

		$qtycount=0;
		$itemcount=0;

		// for rfq, approval is special table since it also signifies submit

		// delete previous approvals if any
		$sa3 = $this->deletedata_itqapproval($p_eval_itqpkey, $p_approval_type);

		reset($p_eval_itempkey);
		foreach ($p_eval_itempkey as $itempkey) {

			reset($p_eval_supplierpkey);
			foreach ($p_eval_supplierpkey as $supplierpkey) {

				$sa4 = $this->insertdata_approval("", $p_eval_itqpkey, $itempkey, $supplierpkey, $p_eval_awardedquantities[$qtycount], $p_approval_type, $_SESSION['Xuserpkey'], $_SESSION['Xstaffname'], "", "1", "");

				$qtycount++;

			}
			$itemcount++;			
		}

		// if dealing with a previously rejected rfq (due to reject rfq or po), reset itq status

		$myitq =  $this->getdata_itq($p_eval_itqpkey);

		if ($myitq['itq_cancel']=="2") {

			// update..
			$sa = $this->update_data("ITQ [Edit]", "itq_details", "itq_evalstatus = "."1".
				", itq_cancel = "."0",
				"where itq_pkey = '".$p_eval_itqpkey."'");

		}

		// if approval, update mro status

		// NOTE: NO LONGER HAPPENS HERE!! HAPPENS IN FUNCTION updatedata_approval()!!
		// (since approval no longer goes through this function!!)

		/*
		if ($p_approval_type=="3") {

			// update mro status!
			include_once('mroModel.php');
			include_once('poModel.php');
			include_once('supplierModel.php');
			$mymroModel=new mroModel;
			$mypoModel=new poModel;
			$mysupplierModel=new supplierModel;

			$sa4 = $mymroModel->updatestatus_mro($p_eval_mropkey,"5");

			// create POs automatically!!

			$myitq = $this->getdata_itq($p_eval_itqpkey);
			$myusername = $_SESSION['Xstaffname'];

			reset($p_eval_selected);
			reset($p_eval_itempkey);
			
			$icount = 0;

			foreach ($p_eval_selected as $selectedpkey) {

				$myitempkey = $p_eval_itempkey[$icount];

				// get supplier data
				$mysupplier = $mysupplierModel->getdata_supplier($selectedpkey);

				// careful not to create more than 1 PO per supplier!
				if ($mypoModel->getstatus_poexists($_SESSION['Xprojectpkey'], $p_eval_mropkey, $p_eval_itqpkey, $selectedpkey)=="0") {

					// get last po id..
					$lastid=$mypoModel->getdata_lastpoid();
					$lastid++;

					$sa5 = $this->generate_po($_SESSION['Xprojectpkey'], $p_eval_mropkey, $p_eval_itqpkey, $selectedpkey, $lastid, unconverttounix(gettimestamp()), 30, $mysupplier['supplier_pic']." ".$mysupplier['supplier_picphone'], "", "", $_SESSION['Xuserpkey'], "", "", $myitq['itq_requestor'], $myusername);
					$icount++;
				}
			}
		}
		*/

		// return result..
		if ($sa==1) {
			return $p_eval_itqpkey;
		} else {
			return false;
		}
	}
	
	
	
//#####################################################################

	/* ********************************************************************************
	Generate PO automatically
	******************************************************************************** */

	function generate_po($p_po_projectpkey, $p_po_mropkey, $p_po_itqpkey, $p_po_supplierpkey, $p_po_no, $p_po_date, $p_po_top, $p_po_attn, $p_po_literaltotal, $p_po_co, $p_po_personnelpkey, $p_po_contactperson, $p_po_contactnumber, $p_po_requestor, $p_po_approver) {

		include_once('poModel.php');
		$mypoModel=new poModel;

		// create POs automatically!!
		$sa = $mypoModel->insertdata_po("", $p_po_projectpkey, $p_po_mropkey, $p_po_itqpkey, $p_po_supplierpkey, $p_po_no, $p_po_date, $p_po_top, $p_po_attn, $p_po_literaltotal, $p_po_co, $p_po_personnelpkey, $p_po_contactperson, $p_po_contactnumber, $p_po_requestor, $p_po_approver);

	}


	/* ********************************************************************************
	Insert/Create a new itq approval (cumulative)
	Type: 1 = Recommendation, 2 = Approval
	Status: 0 = Unprocessed/Unknown, 1 = Recommended/Approved, 2 = Rejected
	NOTE: At the same, must update status field in table itq_details!
	******************************************************************************** */

	function insertdata_approval($p_approval_pkey, $p_approval_itqpkey, $p_approval_itempkey, $p_approval_supplierpkey, $p_approval_quantity, $p_approval_type, $p_approval_userpkey, $p_approval_officername, $p_approval_date, $p_approval_status, $p_approval_remarks) {

		// clean/convert/add params..
		//$p_approval_date=converttounixfull($p_approval_date." ".date('H:i:s'));	// use convertfull coz timestamp;
		$p_approval_date=gettimestamp();

		$p_itq_approved="0";
		if ($p_approval_status=="1") $p_itq_approved=$p_approval_type;

		// update..
		$new_approval_pkey=md5(microtime());

		$sa = $this->add_data("ITQ -> Approval [Add]", "itq_approvals", "approval_pkey, approval_itqpkey, approval_itempkey, approval_supplierpkey, approval_quantity, approval_type, approval_userpkey, approval_officername, approval_date, approval_status, approval_remarks",
			"'".$new_approval_pkey."','".$p_approval_itqpkey."','".$p_approval_itempkey.
			"','".$p_approval_supplierpkey."',".$p_approval_quantity.
			",".$p_approval_type.",'".$p_approval_userpkey."','".$p_approval_officername.
			"','".$p_approval_date."',".$p_approval_status.",'".$p_approval_remarks."'");

		// NOTE: the below will be done multiple times since one approval record per supplier :P

		// NOTE: ONLY SUBMIT HAPPENS HERE, APPROVAL HAPPENS IN updatedata_approval!!

		if ($p_itq_approved=="3") {

			$myusername = $_SESSION['Xstaffname'];

			$sa2 = $this->update_data("ITQ [Edit]", "itq_details", "itq_evalstatus=".$p_itq_approved.
				", itq_approver='".$myusername."'",
				"where itq_pkey='".$p_approval_itqpkey."'");

		} else {
			$sa2 = $this->update_data("ITQ [Edit]", "itq_details", "itq_evalstatus=".$p_itq_approved,
				"where itq_pkey='".$p_approval_itqpkey."'");
		}

		// return result..
		if ($sa==1) {
			return $new_approval_pkey;
		} else {
			return false;
		}
	}


	/* FUNCTIONS TO UPDATE RECORDS */


	/* ********************************************************************************
	Update/Override an itq
	> Currently not used. Each time itq is 'added' and overwritten
	******************************************************************************** */

	function updatedata_itq($p_itq_pkey, $p_itq_mropkey, $p_itq_subtradepkey, $p_itq_date, $p_itq_from, $p_itq_type, $p_itq_returndate, $p_itq_suppliers, $p_alert) {

		include_once('supplierModel.php');
		$mysupplierModel=new supplierModel;

		// clean/convert/add params..
		$p_itq_date=converttounix($p_itq_date);
		$p_itq_returndate=converttounix($p_itq_returndate);
		$p_itq_supplierpkeys=explode(";",$p_itq_suppliers);

		$myusername = $_SESSION['Xstaffname'];

		// update..
		$sa = $this->update_data("ITQ [Edit]", "itq_details", "itq_mropkey = '".$p_itq_mropkey.
			"', itq_subsubtradepkey = '".$p_itq_subsubtradepkey.
			"', itq_date = '".$p_itq_date.
			"', itq_from = '".$p_itq_from.
			"', itq_type = ".$p_itq_type.
			", itq_returndate = '".$p_itq_returndate.
			"', itq_requestor = '".$myusername."'",
			"where itq_pkey = '".$p_itq_pkey."'");

		// clear old itq suppliers
		$sa2 = $this->deletedata_itqsuppliers($p_itq_pkey);

		foreach($p_itq_supplierpkeys as $p_itq_supplierpkey) {

			$supplier_data = $mysupplierModel->getdata_supplier($p_itq_supplierpkey);
			$p_itq_attn=$supplier_data['supplier_pic'];

			$sa3 = $this->add_data("ITQ Supplier [Add]", "itq_suppliers", "itq_pkey, itq_supplierpkey, itq_attn",
				"'".$p_itq_pkey."','".$p_itq_supplierpkey."','".$p_itq_attn."'");

		}

		// return result..
		if ($sa==1) {
			//return $p_itq_mropkey;
			return $p_itq_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update approval data (actually insert!!)
	> Copy submitted data into reviewed/approved data, basically..
	******************************************************************************** */

	function updatedata_approval($p_approval_pkey, $p_approval_itqpkey, $p_approval_mropkey, $p_approval_type, $p_approval_userpkey, $p_approval_officername, $p_approval_date, $p_approval_status, $p_approval_remarks) {

		// clean/convert/add params..
		//$p_approval_date=converttounixfull($p_approval_date." ".date('H:i:s'));	// use convertfull coz timestamp;
		$p_approval_date=gettimestamp();

		$p_itq_approved="0";
		if ($p_approval_status=="1") $p_itq_approved=$p_approval_type;

		// get saved rfq data..
		$myapprovals = $this->getlist_itqapprovalssaved($p_approval_itqpkey);

		foreach ($myapprovals as $myapproval) {

			// update..
			$new_approval_pkey=md5(microtime());

			$sa = $this->add_data("ITQ -> Approval [Add]", "itq_approvals", "approval_pkey, approval_itqpkey, approval_itempkey, approval_supplierpkey, approval_quantity, approval_type, approval_userpkey, approval_officername, approval_date, approval_status, approval_remarks",
				"'".$new_approval_pkey."','".$p_approval_itqpkey."','".$myapproval['approval_itempkey'].
				"','".$myapproval['approval_supplierpkey']."',".$myapproval['approval_quantity'].
				",".$p_approval_type.",'".$p_approval_userpkey."','".$p_approval_officername.
				"','".$p_approval_date."',".$p_approval_status.",'".$p_approval_remarks."'");

		}

		// NOTE: the below will be done multiple times since one approval record per supplier :P


		if ($p_itq_approved=="3") {

			// if approval (3) and approved, update itq with status and approver info 
			// also set cancel to 0 (in case rejected earlier)..

			$myusername = $_SESSION['Xstaffname'];

			$sa2 = $this->update_data("ITQ [Edit]", "itq_details", "itq_evalstatus=".$p_itq_approved.
				", itq_cancel=0".
				", itq_approver='".$myusername."'",
				"where itq_pkey='".$p_approval_itqpkey."'");

			// then do stuff with mro

			// update mro status!
			include_once('mroModel.php');
			include_once('poModel.php');
			include_once('supplierModel.php');
			$mymroModel=new mroModel;
			$mypoModel=new poModel;
			$mysupplierModel=new supplierModel;

			$sa4 = $mymroModel->updatestatus_mro($p_approval_mropkey,"5");

			// create POs automatically!!

			$myitq = $this->getdata_itq($p_approval_itqpkey);
			$myusername = $_SESSION['Xstaffname'];
			
			$icount = 0;
			$prevsupp = "";

			reset($myapprovals);

			foreach ($myapprovals as $myapproval) {

				if ($myapproval['approval_quantity']>0) {

					// careful not to create more than 1 PO per supplier!
					//if ($mypoModel->getstatus_poexists($_SESSION['Xprojectpkey'], $p_approval_mropkey, $p_approval_itqpkey, $myapproval['approval_supplierpkey'])=="0") {
					$currpo = $mypoModel->getstatus_poexists($_SESSION['Xprojectpkey'], $p_approval_mropkey, $p_approval_itqpkey, $myapproval['approval_supplierpkey']);
					if ($currpo['po_pkey']=="") {

						// get supplier data
						$mysupplier = $mysupplierModel->getdata_supplier($myapproval['approval_supplierpkey']);

						// get last po id..
						$lastid=$mypoModel->getdata_lastpoid();
						$lastid++;

						$sa5 = $this->generate_po($_SESSION['Xprojectpkey'], $p_approval_mropkey, $p_approval_itqpkey, $myapproval['approval_supplierpkey'], $lastid, unconverttounix(gettimestamp()), 30, $mysupplier['supplier_pic']." ".$mysupplier['supplier_picphone'], "", "", $_SESSION['Xuserpkey'], "", "", $myitq['itq_requestor'], $myusername);
						$icount++;

					} else {

						// even if po exists, still proceed and let po function deal with it

						// get supplier data
						$mysupplier = $mysupplierModel->getdata_supplier($myapproval['approval_supplierpkey']);

						// get last po id..
						$lastid=$mypoModel->getdata_lastpoid();
						$lastid++;

						$sa5 = $this->generate_po($_SESSION['Xprojectpkey'], $p_approval_mropkey, $p_approval_itqpkey, $myapproval['approval_supplierpkey'], $lastid, unconverttounix(gettimestamp()), 30, $mysupplier['supplier_pic']." ".$mysupplier['supplier_picphone'], "", "", $_SESSION['Xuserpkey'], "", "", $myitq['itq_requestor'], $myusername);
						$icount++;

					}
				}
			}

		} else {
			$sa2 = $this->update_data("ITQ [Edit]", "itq_details", "itq_evalstatus=".$p_itq_approved,
				"where itq_pkey='".$p_approval_itqpkey."'");

			if ($p_approval_status=="1") {

				// if submission or recommendation (accepted), update itq status..

				//$sa2 = $this->update_data("ITQ [Edit]", "itq_details", "itq_evalstatus=".$p_itq_approved,
				//	"where itq_pkey='".$p_approval_itqpkey."'");

				$sa2 = $this->update_data("ITQ [Edit]", "itq_details", "itq_evalstatus=".$p_itq_approved.
					", itq_cancel=0",
					"where itq_pkey='".$p_approval_itqpkey."'");
					
				// tambahan 18-1-2012 yusrul .. set po_details to normal (before reject)
				$sa3 = $this->update_data("PO [Edit]", "po_details", "po_cancel = 0",
				"where po_itqpkey = '".$p_approval_itqpkey."'");				
					
				// update po_item value
				// po_details-->po_supplierpkey -> itq_evaluation --> eval_supplierpkey -> get eval_supplierrate
				// update po_items
				//$sql_update_po_item = mysql_query("update po_items ");
					

			} else if ($p_approval_status=="2") {

				// if cancelled, update cancel status but not itq status (cannot do anything)..

				//$sa2 = $this->update_data("ITQ [Edit]", "itq_details", "itq_cancel=1",
				//	"where itq_pkey='".$p_approval_itqpkey."'");

				$sa2 = $this->update_data("ITQ [Edit]", "itq_details", "itq_cancel=1".
					", itq_evalstatus=9",
					"where itq_pkey='".$p_approval_itqpkey."'");
				//yusr 13-9-2011
				// insert cancel to mro
			   $sqly2 = mysql_query("update mro_details set mro_cancel = '1' where mro_pkey='$p_approval_mropkey'");
				//insert value 0 to mro_items
			   $sqly3 = mysql_query("update mro_items set item_quantity = '0' where item_mropkey='$p_approval_mropkey'");
					
					
					
					
			} else if ($p_approval_status=="3") {

				// if rejected, update cancel status and set itq status to 0 (new)..
				// and increment rev no

				$myrev = $this->getdata_revno($p_approval_itqpkey);
				$myrev++;

				//$sa2 = $this->update_data("ITQ [Edit]", "itq_details", "itq_cancel=2".
				//	", itq_revno=".$myrev.
				//	", itq_evalstatus=0",
				//	"where itq_pkey='".$p_approval_itqpkey."'");

				$sa2 = $this->update_data("ITQ [Edit]", "itq_details", "itq_cancel=2".
					", itq_evalstatus=9, itq_approval1=''",
					" where itq_pkey='".$p_approval_itqpkey."'");
					

				//$ca = $this->copy_itq($p_approval_itqpkey, $myrev); //defaul enable this.. disable at 28-12-2011

			}

		}

		// return result..
		if ($sa==1) {
			return $new_approval_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update itq status (after printing)
	> 
	******************************************************************************** */

	function updatestatus_itq($p_itq_pkey, $p_itq_status) {

		// update..
		$sa = $this->update_data("ITQ [Edit]", "itq_details", "itq_status = ".$p_itq_status,
			"where itq_pkey = '".$p_itq_pkey."'");

		// return result..
		if ($sa==1) {
			return $p_itq_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update rfq status (tabulation)
	> 
	******************************************************************************** */

	function updatestatus_rfq($p_itq_pkey, $p_itq_evalstatus) {

		// update..
		$sa = $this->update_data("ITQ [Edit]", "itq_details", "itq_evalstatus = ".$p_itq_evalstatus,
			"where itq_pkey = '".$p_itq_pkey."'");

		// also do submission!!
		$sa2 = $this->updatedata_approval("", $p_itq_pkey, "", "1", $_SESSION['Xuserpkey'], $_SESSION['Xstaffname'], gettimestamp(), "1", "");

		// return result..
		if ($sa==1) {
			return $p_itq_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Cancel an existing itq (?)
	******************************************************************************** */

	function cancel_itq($p_itq_pkey) {

		// clean/convert/add params..

		// update..
		$sa = $this->update_data("ITQ [Cancel]", "itq_details", "itq_cancel = 1",
			"where itq_pkey = '".$p_itq_pkey."'");

				
			
		// return result..
		if ($sa==1) {
			return $p_itq_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Reject an existing itq evaluation
	******************************************************************************** */
	function reject_itq($p_itq_pkey) {

		// clean/convert/add params..

		// update..
		$nullx = NULL;
		$sa = $this->update_data("ITQ [Reject]", "itq_details", "itq_cancel = 2",
		    ", itq_approval1 ='".$nullx."'",
			"where itq_pkey = '".$p_itq_pkey."'");
			
		//$sa2 = $this->update_data("ITQ [Reject]", "itq_approvals", "approval_officername = ''",
		//	"where approval_itq_pkey = '".$p_itq_pkey."'");

		// return result..
		if ($sa2==1) {
			return $p_itq_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Copy rejected ITQ into new ITQ!! (RFQ)
	******************************************************************************** */

	function copy_itq($p_itq_pkey, $p_revno) {

		// first, copy the itq..
		$myitq = $this->getdata_itq($p_itq_pkey);

		// add new itq with status=0 and cancel status = 2..
		$new_itq_pkey=md5(microtime());

		$sa = $this->add_data("ITQ [Add]", "itq_details", "itq_pkey, itq_mropkey, itq_subtradepkey, itq_rfqno, itq_revno, itq_date, itq_from, itq_type, itq_returndate, itq_requestor, itq_status, itq_evalstatus, itq_cancel",
			"'".$new_itq_pkey."','".$myitq['itq_mropkey']."','".$myitq['itq_subtradepkey'].
			"',".$myitq['itq_rfqno'].",".$p_revno.
			",'".$myitq['itq_date']."','".$myitq['itq_from']."',".$myitq['itq_type'].
			",'".$myitq['itq_returndate']."','".$myitq['itq_requestor']."',1,0,2");

		// now, copy all suppliers..
		$supp_items = $this->getlist_suppliers($p_itq_pkey);

		foreach($supp_items as $myitem) {

			// update..
			//$new_item_pkey=md5(microtime());

			$sa2 = $this->add_data("ITQ Supplier [Add]", "itq_suppliers", "itq_pkey, itq_supplierpkey, itq_attn, itq_remarks, itq_transportrate",
				"'".$new_itq_pkey."','".$myitem['itq_supplierpkey'].
				"','".$myitem['itq_attn']."','".$myitem['itq_remarks'].
				"',".$myitem['itq_transportrate']);

		}

		// now, copy all evaluations..
		$eval_items = $this->getlist_evaluations($p_itq_pkey);

		foreach($eval_items as $myitem) {

			// update..
			//$new_item_pkey=md5(microtime());

			$sa3 = $this->add_data("ITQ Evaluation [Add]", "itq_evaluation", "eval_itqpkey, eval_mropkey, eval_itempkey, eval_supplierpkey, eval_supplierrate",
				"'".$new_itq_pkey."','".$myitem['eval_mropkey'].
				"','".$myitem['eval_itempkey']."','".$myitem['eval_supplierpkey'].
				"',".$myitem['eval_supplierrate']);

		}

		// return result..
		if ($sa==1) {
			return $new_itq_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Update/Override an itq evaluation item
	> 
	******************************************************************************** */

	function updatedata_itqitem($p_eval_pkey, $p_eval_itqpkey, $p_eval_mropkey, $p_eval_itempkey, $p_eval_supplierpkey, $p_eval_supplierrate) {

		// clean/convert/add params..
		$p_eval_supplierrate=str_replace(",","",$p_eval_supplierrate);

		// update..
		$sa = $this->update_data("ITQ Item [Edit]", "itq_evaluation", "eval_itqpkey = '".$p_eval_itqpkey.
			"', eval_mropkey = '".$p_eval_mropkey.
			"', eval_itempkey = '".$p_eval_itempkey.
			"', eval_supplierpkey = '".$p_eval_supplierpkey.
			"', eval_supplierrate = ".$p_eval_supplierrate,
			"where eval_pkey = '".$p_eval_pkey."'");

		// return result..
		if ($sa==1) {
			return $p_eval_pkey;
		} else {
			return false;
		}
	}


	/* FUNCTIONS TO DELETE RECORDS */


	/* ********************************************************************************
	Delete an existing itq (by mro)
	******************************************************************************** */

	function deletedata_itq($p_itq_mropkey) {

		$itq_data = $this->getdata_itqbymro($p_itq_mropkey);

		// delete suppliers
		$sa = $this->deletedata_itqsuppliers($itq_data['itq_pkey']);

		// delete itq..
		$sa = $this->delete_data("ITQ [Delete]", "itq_details", "where itq_mropkey = '".$p_itq_mropkey."'");

		// return result..
		if ($sa==1) {
			return $p_itq_mropkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Delete an existing itq (by itq)
	******************************************************************************** */

	function deletedata_itqbyitq($p_itq_pkey) {

		// delete itq..
		$sa = $this->delete_data("ITQ [Delete]", "itq_details", "where itq_pkey = '".$p_itq_pkey."'");

		// return result..
		if ($sa==1) {
			return $p_itq_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Delete an existing itq supplier list
	******************************************************************************** */

	function deletedata_itqsuppliers($p_itq_pkey) {

		// delete subject..
		$sa = $this->delete_data("ITQ Suppliers [Delete]", "itq_suppliers", "where itq_pkey = '".$p_itq_pkey."'");

		// return result..
		if ($sa==1) {
			return $p_itq_pkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Delete an existing itq evaluation item
	******************************************************************************** */

	function deletedata_itqevaluation($p_eval_itqpkey) {

		// delete subject..
		$sa = $this->delete_data("ITQ Evaluation [Delete]", "itq_evaluation", "where eval_itqpkey = '".$p_eval_itqpkey."'");

		// return result..
		if ($sa==1) {
			return $p_eval_itqpkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Delete an existing itq approval set
	******************************************************************************** */

	function deletedata_itqapprovals($p_approval_itqpkey) {

		// delete subject..
		$sa = $this->delete_data("ITQ Approval [Delete]", "itq_approvals", "where approval_itqpkey = '".$p_approval_itqpkey."'");

		// return result..
		if ($sa==1) {
			return $p_approval_itqpkey;
		} else {
			return false;
		}
	}


	/* ********************************************************************************
	Delete an existing itq approval set (by type)
	******************************************************************************** */

	function deletedata_itqapproval($p_approval_itqpkey, $p_approval_type) {

		// delete subject..
		$sa = $this->delete_data("ITQ Approval [Delete]", "itq_approvals", "where approval_itqpkey = '".$p_approval_itqpkey."' and approval_type = ".$p_approval_type);

		// return result..
		if ($sa==1) {
			return $p_approval_itqpkey;
		} else {
			return false;
		}
	}

}
?>