<?

/*
  Notes: 210.001mm x 297.00mm
 */

$pubuserpkey = $_GET['userid'];

//include_once('../includes.php');
include_once('../dbincludes.php');
include_once('../lib/lib_general.php');

define('FPDF_FONTPATH', '../lib/fpdf/font/');
require('../lib/fpdf/fpdf.php');

include_once('../models/userModel.php');
$myuserModel = new userModel;

$user_data = $myuserModel->getdata_user($pubuserpkey);

include_once('../models/reportModel.php');
$myreportModel = new reportModel;

$header_data = $myreportModel->loadheader_supplierlist($pubuserpkey);
$report_data = $myreportModel->loaddata_supplierlist($pubuserpkey);

//$projectname = $header_data['hdr_projectname'];


class MPDF extends FPDF {

    var $widths;
    var $aligns;
    var $lineheight;

    function SetWidths($w) {
        //Set the array of column widths
        $this->widths = $w;
    }

    function SetAligns($a) {
        //Set the array of column alignments
        $this->aligns = $a;
    }

    function SetLineHeight($h) {  //  added
        $this->lineheight = $h;
    }

    function Row($data) {
        //Calculate the height of the row
        $nb = 0;
        $lh = isset($this->lineheight) ? $this->lineheight : 5; // added
        for ($i = 0; $i < count($data); $i++)
            $nb = max($nb, $this->NbLines($this->widths[$i], $data[$i]));
        //$h=($lh+1)*$nb;	//  changed from 5 to $lh
        $h = ($lh * $nb) + 2;
        //Issue a page break first if needed
        $this->CheckPageBreak($h);
        //Draw the cells of the row
        for ($i = 0; $i < count($data); $i++) {
            $w = $this->widths[$i];
            $a = isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
            //$lh=isset($this->lineheight) ? $this->lineheight : 5;
            //Save the current position
            $x = $this->GetX();
            $y = $this->GetY();
            //Draw the border
            $this->Rect($x, $y, $w, $h);
            //Print the text
            $this->SetXY($x, $y + 1); //  added
            $this->MultiCell($w, $lh, $data[$i], 0, $a);
            //Put the position to the right of the cell
            $this->SetXY($x + $w, $y);
        }
        //Go to the next line
        $this->Ln($h);
    }

    function CheckPageBreak($h) {
        //If the height h would cause an overflow, add a new page immediately
        if ($this->GetY() + $h > $this->PageBreakTrigger)
            $this->AddPage($this->CurOrientation);
    }

    function NbLines($w, $txt) {
        //Computes the number of lines a MultiCell of width w will take
        $cw = &$this->CurrentFont['cw'];
        if ($w == 0)
            $w = $this->w - $this->rMargin - $this->x;
        $wmax = ($w - 2 * $this->cMargin) * 1000 / $this->FontSize;
        $s = str_replace("\r", '', $txt);
        $nb = strlen($s);
        if ($nb > 0 and $s[$nb - 1] == "\n")
            $nb--;
        $sep = -1;
        $i = 0;
        $j = 0;
        $l = 0;
        $nl = 1;
        while ($i < $nb) {
            $c = $s[$i];
            if ($c == "\n") {
                $i++;
                $sep = -1;
                $j = $i;
                $l = 0;
                $nl++;
                continue;
            }
            if ($c == ' ')
                $sep = $i;
            $l+=$cw[$c];
            if ($l > $wmax) {
                if ($sep == -1) {
                    if ($i == $j)
                        $i++;
                }
                else
                    $i=$sep + 1;
                $sep = -1;
                $j = $i;
                $l = 0;
                $nl++;
            }
            else
                $i++;
        }
        return $nl;
    }

    // Page header
    function Header() {

        global $header_data;

        if ($this->PageNo() == 1) {

            // zikay logo..
            $this->Image('../gfx/zikayheader.png', 98, 10, 80, 16); //390, 87);
            // title
            $this->SetXY(128, 30);
            $this->SetFont('Arial', 'B', 8);
            $this->Cell(40, 3, 'SUPPLIER REGISTERED LIST', 'B', 1, 'C');

            //Line break
            $this->Ln(5);

        }


        $this->SetFont('Arial', 'B', 6);
        $this->SetX(10);

        $header = array('No', 'Register Date', 'Approved Date', 'Supplier Reg No', 'Supplier Name & Address', 'Contact Person', 'Contact Number (PIC)', 'Credit Terms', 'Nature of Business', 'Products', 'Status', 'Credit Facilities');

        //Column widths
      //  $w = array(8, 13, 13, 12, 40, 20, 18, 12, 20, 18, 13, 92);
        $this->SetWidths(array(8, 13, 13, 12, 40, 20, 18, 12, 20, 18, 13, 92));

        $this->SetAligns(array('C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C', 'C'));
        $this->SetLineHeight(4);

        //Headers
        //for($i=0;$i<count($header);$i++)
        //    $this->Cell($w[$i],5,$header[$i],'B',0,'C');

        $this->Row($header);

        $cury = $this->GetY() - 5;

        $this->SetXY(197, $cury);
        $this->Cell(10, 5, 'Ratio', 1, 0, 'C');
        $this->SetXY(207, $cury);
        $this->Cell(18, 5, 'Bank Guarantee', 1, 0, 'C');
        $this->SetXY(225, $cury);
        $this->Cell(18, 5, 'Pers. Guarantee', 1, 0, 'C');
        $this->SetXY(243, $cury);
        $this->Cell(18, 5, 'Total Amount', 1, 0, 'C');
        $this->SetXY(261, $cury);
        $this->Cell(28, 5, 'Remarks', 1, 1, 'C');

        $this->Ln();

        $cury = $this->GetY() - 5;

        $this->SetXY(10, $cury);

        //$nexty = $this->GetY()+1;
        //$this->Line(10,$nexty,286,$nexty);
        //$this->Ln();

        //set back width to 16 column
        $this->SetWidths(array(8, 13, 13, 12, 40, 20, 18, 12, 20, 18, 13, 10, 18, 18, 18, 28));
        $this->SetAligns(array('C', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'R', 'R', 'R', 'L'));

    }

    // Page footer
    function Footer() {

        global $user_data;

        // $this->Line(10,194,290,194);
        // printer and date (1.5 cm from bottom)..
        $this->SetXY(10, -15);
        $this->SetFont('Arial', '', 7);
        $this->Cell(0, 5, 'Print Date : ' . unconverttounixslash(getdatestamp()) . ' - Printed By : ' . $user_data['staff_name'], 0, 0, 'L');

        // page no (1.5 cm from bottom)..
        $this->SetXY(-15, -15);
        $this->SetFont('Arial', '', 7);
        $this->Cell(0, 5, 'Page ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
 
    }

}

//setlocale(LC_NUMERIC,'en');

$pdf = new MPDF('L', 'mm', 'A4');
$pdf->Open();
$pdf->AliasNbPages();
$pdf->AddPage('L', 'A4');
$pdf->SetFont('Arial', '', 8);

// data area..
//Column widths
$w = array(8, 13, 13, 12, 40, 20, 18, 12, 20, 18, 13, 10, 18, 18, 18, 28);
$pdf->SetWidths(array(8, 13, 13, 12, 40, 20, 18, 12, 20, 18, 13, 10, 18, 18, 18, 28));

$pdf->SetAligns(array('C', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'L', 'R', 'R', 'R', 'L'));
$pdf->SetLineHeight(3);

$pdf->SetFont('Arial', '', 6);

//$grandtotal=0;
//$i = 0;
$count = 1;
foreach ($report_data as $row) {
    $pdf->Row(array($count . " ", $row['data_regdate'], $row['data_approvedate'], $row['data_regid'], $row['data_fullname'], $row['data_contactperson'], $row['data_contactno'], $row['data_ct'], $row['data_nob'], $row['data_products'], $row['data_status'], $row['data_bgratio'] . " ", number_format($row['data_bgamount'], 2) . " ", number_format($row['data_pgamount'], 2) . " ", number_format($row['data_totalamount'], 2), $row['data_bgremarks']));
  //  $i++;
   // $pdf->Row(array($i,'22','33','44','55','66','77','88','99','1A','2A','3A','4A','5A','6A','7A'));
 $count++;
   }




// output..

$pdf->Output();
exit;


/* For outputting to a file..
  $file = basename(tempnam('.', 'tmp'));
  rename($file, $file.'.pdf');
  $file .= '.pdf';
  $pdf->Output($file, 'F');
  header('Location: '.$file);
 */
?>